/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.exporter.impl.optel.config;

import java.util.List;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeSpanExporterConfiguration
implements ObservabilitySignalConfiguration,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeSpanExporterConfiguration.class);
    private final List<ObservabilitySignalConfiguration> spanExporterConfigurations;

    public CompositeSpanExporterConfiguration(List<ObservabilitySignalConfiguration> spanExporterConfigurations) {
        this.spanExporterConfigurations = spanExporterConfigurations;
    }

    public String getStringValue(String key) {
        return this.spanExporterConfigurations.stream().filter(configuration -> configuration.getStringValue(key) != null).findFirst().map(configuration -> configuration.getStringValue(key)).orElse(null);
    }

    public String getStringValue(String key, String defaultValue) {
        return this.spanExporterConfigurations.stream().filter(configuration -> configuration.getStringValue(key) != null).findFirst().map(configuration -> configuration.getStringValue(key)).orElse(defaultValue);
    }

    public void doOnConfigurationChanged(Runnable doOnConfigurationChanged) {
        this.spanExporterConfigurations.forEach(configuration -> configuration.doOnConfigurationChanged(doOnConfigurationChanged));
    }

    public void dispose() {
        this.spanExporterConfigurations.forEach(configuration -> LifecycleUtils.disposeIfNeeded((Object)configuration, (Logger)LOGGER));
    }
}

