/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.simple;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.internal.transformer.simple.ByteArrayToSerializable;
import org.mule.runtime.core.internal.util.func.CheckedFunction;

public final class ByteArrayToObject
extends ByteArrayToSerializable {
    @Override
    public Object doTransform(Object src, Charset encoding) throws TransformerException {
        if (src instanceof byte[]) {
            byte[] bytes = (byte[])src;
            if (this.checkStreamHeader(bytes[0])) {
                return super.doTransform(src, encoding);
            }
            return new String(bytes, encoding);
        }
        try {
            return ByteArrayToObject.ifInputStream(src, stream -> {
                String string;
                PushbackInputStream pushbackStream = new PushbackInputStream((InputStream)stream);
                int firstByte = pushbackStream.read();
                pushbackStream.unread((byte)firstByte);
                if (this.checkStreamHeader((byte)firstByte)) {
                    return super.doTransform(pushbackStream, encoding);
                }
                try {
                    string = IOUtils.toString((InputStream)pushbackStream, (Charset)encoding);
                }
                catch (Throwable throwable) {
                    try {
                        pushbackStream.close();
                        throw throwable;
                    }
                    catch (IOException iox) {
                        throw new TransformerException(this, (Throwable)iox);
                    }
                }
                pushbackStream.close();
                return string;
            });
        }
        catch (NotAnInputStreamException e) {
            throw new TransformerException(CoreMessages.transformOnObjectUnsupportedTypeOfEndpoint(this.getName(), src.getClass()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T ifInputStream(Object value, CheckedFunction<InputStream, T> function) throws NotAnInputStreamException {
        boolean shouldCloseStream = false;
        InputStream stream = null;
        if (value instanceof CursorStreamProvider) {
            CursorStreamProvider cursorStreamProviderValue = (CursorStreamProvider)value;
            stream = (InputStream)cursorStreamProviderValue.openCursor();
            shouldCloseStream = true;
        } else if (value instanceof InputStream) {
            InputStream inputStreamValue;
            stream = inputStreamValue = (InputStream)value;
        } else {
            throw new NotAnInputStreamException(stream);
        }
        try {
            T t = function.apply(stream);
            return t;
        }
        finally {
            if (shouldCloseStream) {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
    }

    private boolean checkStreamHeader(byte firstByte) {
        return firstByte == -84;
    }

    public static final class NotAnInputStreamException
    extends MuleException {
        private static final long serialVersionUID = 1L;

        public NotAnInputStreamException(Object value) {
            super(I18nMessageFactory.createStaticMessage((String)("Was expecting an InputStream or a stream provider but " + (value != null ? value.getClass().getName() : "null") + " was found instead")));
        }
    }
}

