/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.dsl.syntax;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.api.annotation.NoExtend;
import org.mule.api.annotation.NoInstantiate;
import org.mule.metadata.api.model.MetadataType;

@NoExtend
@NoInstantiate
public class DslElementSyntax {
    private final String attributeName;
    private final String elementName;
    private final String prefix;
    private final String namespace;
    private final boolean isWrapped;
    private final boolean supportsAttributeDeclaration;
    private final boolean supportsChildDeclaration;
    private final boolean supportsTopLevelDeclaration;
    private final boolean requiresConfig;
    private final Map<MetadataType, DslElementSyntax> genericsDsl;
    private final Map<String, DslElementSyntax> childs;
    private final Map<String, DslElementSyntax> attributes;
    private final Map<String, DslElementSyntax> containedElements;

    public DslElementSyntax(String attributeName, String elementName, String prefix, String namespace, boolean isWrapped, boolean supportsAttributeDeclaration, boolean supportsChildDeclaration, boolean supportsTopLevelDeclaration, boolean requiresConfig, Map<MetadataType, DslElementSyntax> genericsDsl, Map<String, DslElementSyntax> containedElements) {
        this.attributeName = attributeName;
        this.elementName = elementName;
        this.prefix = prefix;
        this.namespace = namespace;
        this.isWrapped = isWrapped;
        this.supportsAttributeDeclaration = supportsAttributeDeclaration;
        this.supportsChildDeclaration = supportsChildDeclaration;
        this.supportsTopLevelDeclaration = supportsTopLevelDeclaration;
        this.requiresConfig = requiresConfig;
        this.genericsDsl = genericsDsl;
        this.containedElements = containedElements;
        this.childs = containedElements.entrySet().stream().filter(e -> ((DslElementSyntax)e.getValue()).supportsChildDeclaration()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.attributes = containedElements.entrySet().stream().filter(e -> ((DslElementSyntax)e.getValue()).supportsAttributeDeclaration()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean isWrapped() {
        return this.isWrapped;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public boolean supportsAttributeDeclaration() {
        return this.supportsAttributeDeclaration;
    }

    public boolean supportsChildDeclaration() {
        return this.supportsChildDeclaration;
    }

    public boolean supportsTopLevelDeclaration() {
        return this.supportsTopLevelDeclaration;
    }

    public boolean requiresConfig() {
        return this.requiresConfig;
    }

    public Optional<DslElementSyntax> getGeneric(MetadataType type) {
        return Optional.ofNullable(this.genericsDsl.get(type));
    }

    public Map<MetadataType, DslElementSyntax> getGenerics() {
        return this.genericsDsl;
    }

    public Optional<DslElementSyntax> getChild(String name) {
        return Optional.ofNullable(this.childs.get(name));
    }

    public List<DslElementSyntax> getChilds() {
        return Collections.unmodifiableList(new ArrayList<DslElementSyntax>(this.childs.values()));
    }

    public Optional<DslElementSyntax> getAttribute(String name) {
        return Optional.ofNullable(this.attributes.get(name));
    }

    public List<DslElementSyntax> getAttributes() {
        return Collections.unmodifiableList(new ArrayList<DslElementSyntax>(this.attributes.values()));
    }

    public Optional<DslElementSyntax> getContainedElement(String name) {
        return Optional.ofNullable(this.containedElements.get(name));
    }

    public List<DslElementSyntax> getContainedElements() {
        return Collections.unmodifiableList(new ArrayList<DslElementSyntax>(this.containedElements.values()));
    }

    public Map<String, DslElementSyntax> getContainedElementsByName() {
        return Collections.unmodifiableMap(new LinkedHashMap<String, DslElementSyntax>(this.containedElements));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DslElementSyntax)) {
            return false;
        }
        DslElementSyntax that = (DslElementSyntax)o;
        return this.isWrapped == that.isWrapped && this.supportsAttributeDeclaration == that.supportsAttributeDeclaration && this.supportsChildDeclaration == that.supportsChildDeclaration && this.supportsTopLevelDeclaration == that.supportsTopLevelDeclaration && this.requiresConfig == that.requiresConfig && Objects.equals(this.attributeName, that.attributeName) && Objects.equals(this.elementName, that.elementName) && Objects.equals(this.prefix, that.prefix) && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.genericsDsl, that.genericsDsl) && Objects.equals(this.childs, that.childs) && Objects.equals(this.attributes, that.attributes) && Objects.equals(this.containedElements, that.containedElements);
    }

    public int hashCode() {
        return Objects.hash(this.attributeName, this.elementName, this.prefix, this.namespace, this.isWrapped, this.supportsAttributeDeclaration, this.supportsChildDeclaration, this.supportsTopLevelDeclaration, this.requiresConfig, this.genericsDsl, this.childs, this.attributes, this.containedElements);
    }

    public String toString() {
        return "{ \nAttributeName: " + this.attributeName + ",\nElementName: " + this.elementName + ",\nPrefix: " + this.prefix + ",\nNamespace: " + this.namespace + ",\nSupportsAttributeDeclaration: " + this.supportsAttributeDeclaration + ",\nSupportsChildDeclaration: " + this.supportsChildDeclaration + ",\nSupportsTopLevelDeclaration: " + this.supportsTopLevelDeclaration + ",\nRequiresConfig: " + this.requiresConfig + "}";
    }
}

