/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.store;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.TreeBidiMap;
import org.apache.commons.io.FileUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.api.store.ExpirableObjectStore;
import org.mule.runtime.api.store.ObjectAlreadyExistsException;
import org.mule.runtime.api.store.ObjectDoesNotExistException;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreNotAvailableException;
import org.mule.runtime.api.store.TemplateObjectStore;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.internal.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentObjectStorePartition<T extends Serializable>
extends TemplateObjectStore<T>
implements ExpirableObjectStore<T> {
    private static final String OBJECT_FILE_EXTENSION = ".obj";
    private static final String PARTITION_DESCRIPTOR_FILE = "partition-descriptor";
    public static final String CORRUPTED_FOLDER = "corrupted-files";
    private static final Logger LOGGER = LoggerFactory.getLogger(PersistentObjectStorePartition.class);
    private final MuleConfiguration muleConfiguration;
    private final ObjectSerializer serializer;
    private boolean loaded = false;
    private File partitionDirectory;
    private String partitionName;
    private final BidiMap realKeyToUUIDIndex = new TreeBidiMap();
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock rLock = this.rwLock.readLock();
    private final Lock wLock = this.rwLock.writeLock();

    public PersistentObjectStorePartition(MuleConfiguration muleConfiguration, ObjectSerializer serializer, String partitionName, File partitionDirectory) {
        this.muleConfiguration = muleConfiguration;
        this.serializer = serializer;
        this.partitionName = partitionName;
        this.partitionDirectory = partitionDirectory;
    }

    public PersistentObjectStorePartition(MuleConfiguration muleConfiguration, ObjectSerializer serializer, File partitionDirectory) throws ObjectStoreNotAvailableException {
        this.muleConfiguration = muleConfiguration;
        this.serializer = serializer;
        this.partitionDirectory = partitionDirectory;
        this.partitionName = this.readPartitionFileName(partitionDirectory);
    }

    protected PersistentObjectStorePartition() {
        this.muleConfiguration = null;
        this.serializer = null;
    }

    private String readPartitionFileName(File partitionDirectory) throws ObjectStoreNotAvailableException {
        File partitionDescriptorFile = new File(partitionDirectory, PARTITION_DESCRIPTOR_FILE);
        try {
            return Files.readString(partitionDescriptorFile.toPath());
        }
        catch (IOException e) {
            throw new ObjectStoreNotAvailableException((Throwable)e);
        }
    }

    public synchronized void open() throws ObjectStoreException {
        this.createDirectory(this.partitionDirectory);
        this.createOrRetrievePartitionDescriptorFile();
    }

    public void close() throws ObjectStoreException {
        this.wLock.lock();
        try {
            try {
                FileUtils.cleanDirectory((File)this.partitionDirectory);
                Files.deleteIfExists(this.partitionDirectory.toPath());
            }
            catch (IOException e) {
                throw new ObjectStoreException(I18nMessageFactory.createStaticMessage((String)"Could not close object store partition"), (Throwable)e);
            }
            this.realKeyToUUIDIndex.clear();
        }
        finally {
            this.wLock.unlock();
        }
    }

    public List<String> allKeys() throws ObjectStoreException {
        this.assureLoaded();
        this.rLock.lock();
        try {
            List<String> list = Collections.unmodifiableList(new ArrayList(this.realKeyToUUIDIndex.keySet()));
            return list;
        }
        finally {
            this.rLock.unlock();
        }
    }

    protected boolean doContains(String key) throws ObjectStoreException {
        this.assureLoaded();
        this.rLock.lock();
        try {
            boolean bl = this.realKeyToUUIDIndex.containsKey((Object)key);
            return bl;
        }
        finally {
            this.rLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStore(String key, T value) throws ObjectStoreException {
        this.assureLoaded();
        this.wLock.lock();
        try {
            if (this.realKeyToUUIDIndex.containsKey((Object)key)) {
                throw new ObjectAlreadyExistsException();
            }
            File newFile = this.createFileToStoreObject();
            this.realKeyToUUIDIndex.put((Object)key, (Object)newFile.getName());
            this.serialize(newFile, new StoreValue<T>((Serializable)((Object)key), value));
        }
        finally {
            this.wLock.unlock();
        }
    }

    public void clear() throws ObjectStoreException {
        this.wLock.lock();
        try {
            try {
                FileUtils.cleanDirectory((File)this.partitionDirectory);
                this.createOrRetrievePartitionDescriptorFile();
            }
            catch (IOException e) {
                throw new ObjectStoreException(I18nMessageFactory.createStaticMessage((String)"Could not clear ObjectStore"), (Throwable)e);
            }
            this.realKeyToUUIDIndex.clear();
        }
        finally {
            this.wLock.unlock();
        }
    }

    protected T doRetrieve(String key) throws ObjectStoreException {
        this.assureLoaded();
        this.rLock.lock();
        try {
            if (!this.realKeyToUUIDIndex.containsKey((Object)key)) {
                throw new ObjectDoesNotExistException(I18nMessageFactory.createStaticMessage((String)("Key does not exist: " + key)));
            }
            T t = this.load(key);
            return t;
        }
        finally {
            this.rLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, T> retrieveAll() throws ObjectStoreException {
        this.assureLoaded();
        this.rLock.lock();
        try {
            LinkedHashMap<String, T> values = new LinkedHashMap<String, T>(this.realKeyToUUIDIndex.size());
            for (Object k : this.realKeyToUUIDIndex.keySet()) {
                String key = (String)k;
                values.put(key, this.load(key));
            }
            LinkedHashMap<String, T> linkedHashMap = values;
            return linkedHashMap;
        }
        finally {
            this.rLock.unlock();
        }
    }

    private T load(String key) throws ObjectStoreException {
        String filename = (String)this.realKeyToUUIDIndex.get((Object)key);
        File file = this.getValueFile(filename);
        return (T)((Serializable)this.deserialize(file).getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T doRemove(String key) throws ObjectStoreException {
        this.assureLoaded();
        this.wLock.lock();
        try {
            Serializable value = this.retrieve(key);
            this.deleteStoreFile(this.getValueFile((String)this.realKeyToUUIDIndex.get((Object)key)));
            Serializable serializable = value;
            return (T)serializable;
        }
        finally {
            this.wLock.unlock();
        }
    }

    public boolean isPersistent() {
        return true;
    }

    public boolean isDistributed() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire(long entryTTL, int maxEntries) throws ObjectStoreException {
        this.assureLoaded();
        this.wLock.lock();
        try {
            Long lastModified;
            File[] files = this.listValuesFiles();
            Arrays.sort(files, (f1, f2) -> {
                int result = Long.compare(f1.lastModified(), f2.lastModified());
                if (result == 0) {
                    result = f1.getName().compareTo(f2.getName());
                }
                return result;
            });
            int startIndex = this.trimToMaxSize(files, maxEntries);
            if (entryTTL == 0L) {
                return;
            }
            long now = System.currentTimeMillis();
            for (int i = startIndex; i < files.length && now - (lastModified = Long.valueOf(files[i].lastModified())) >= entryTTL; ++i) {
                this.deleteStoreFile(files[i]);
            }
        }
        finally {
            this.wLock.unlock();
        }
    }

    private void assureLoaded() throws ObjectStoreException {
        if (!this.loaded) {
            this.loadStoredKeysAndFileNames();
        }
    }

    private void createInnerDirectories(File file) {
        File parentFile = file.getParentFile();
        if (parentFile.exists()) {
            return;
        }
        this.createInnerDirectories(parentFile);
        parentFile.mkdir();
    }

    private void moveToCorruptedFilesFolder(File file) throws IOException {
        Path workingDirectory = new File(this.muleConfiguration.getWorkingDirectory()).toPath().normalize();
        Path absoluteFilePath = file.toPath();
        Path relativePath = workingDirectory.relativize(absoluteFilePath);
        File corruptedDir = new File(this.muleConfiguration.getWorkingDirectory() + File.separator + CORRUPTED_FOLDER);
        if (!corruptedDir.exists()) {
            corruptedDir.mkdir();
        }
        File corruptedFile = new File(corruptedDir.getAbsolutePath() + File.separator + relativePath.toString());
        this.createInnerDirectories(corruptedFile);
        Files.move(file.toPath(), corruptedFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    private void loadStoredKeysAndFileNames() throws ObjectStoreException {
        this.wLock.lock();
        try {
            if (this.loaded) {
                return;
            }
            this.doLoadStoredKeysAndFileNames();
        }
        finally {
            this.wLock.unlock();
        }
    }

    private void doLoadStoredKeysAndFileNames() throws ObjectStoreException {
        try {
            File[] files;
            for (File file : files = this.listValuesFiles()) {
                try {
                    StoreValue<T> storeValue = this.deserialize(file);
                    this.realKeyToUUIDIndex.put((Object)storeValue.getKey(), (Object)file.getName());
                }
                catch (ObjectStoreException e) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn(String.format("Could not deserialize the ObjectStore file: %s. The file will be skipped and moved to the Garbage folder", file.getName()));
                    }
                    this.moveToCorruptedFilesFolder(file);
                }
            }
            this.loaded = true;
        }
        catch (Exception e) {
            throw new ObjectStoreException(I18nMessageFactory.createStaticMessage((String)String.format("Could not restore object store data from %1s", this.partitionDirectory.getAbsolutePath())));
        }
    }

    public File getPartitionDirectory() {
        return this.partitionDirectory;
    }

    private File[] listValuesFiles() {
        File[] files = this.partitionDirectory.listFiles(file -> !file.isDirectory() && file.getName().endsWith(OBJECT_FILE_EXTENSION));
        if (files == null) {
            files = new File[]{};
        }
        return files;
    }

    protected void createDirectory(File directory) throws ObjectStoreException {
        try {
            if (!directory.exists() && !directory.mkdirs()) {
                throw new MuleRuntimeException(CoreMessages.failedToCreate("object store directory " + directory.getAbsolutePath()));
            }
        }
        catch (Exception e) {
            throw new ObjectStoreException((Throwable)e);
        }
    }

    private File getValueFile(String filename) {
        return new File(this.partitionDirectory, filename);
    }

    protected File createFileToStoreObject() throws ObjectStoreException {
        String filename = UUID.getUUID() + OBJECT_FILE_EXTENSION;
        try {
            return new File(this.partitionDirectory, filename);
        }
        catch (MuleRuntimeException mre) {
            throw new ObjectStoreException((Throwable)mre);
        }
    }

    protected File createOrRetrievePartitionDescriptorFile() throws ObjectStoreException {
        try {
            File partitionDescriptorFile = new File(this.partitionDirectory, PARTITION_DESCRIPTOR_FILE);
            if (partitionDescriptorFile.exists()) {
                this.partitionName = this.readPartitionFileName(this.partitionDirectory);
                return partitionDescriptorFile;
            }
            try (FileWriter fileWriter = new FileWriter(partitionDescriptorFile.getAbsolutePath(), false);){
                fileWriter.write(this.partitionName);
                fileWriter.flush();
            }
            return partitionDescriptorFile;
        }
        catch (Exception e) {
            throw new ObjectStoreException((Throwable)e);
        }
    }

    protected void serialize(File outputFile, StoreValue<T> storeValue) throws ObjectStoreException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(outputFile);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
             ObjectOutputStream objectOutputStream = new ObjectOutputStream(bufferedOutputStream);){
            this.serializer.getInternalProtocol().serialize(storeValue, (OutputStream)objectOutputStream);
            objectOutputStream.flush();
        }
        catch (Exception se) {
            throw new ObjectStoreException((Throwable)se);
        }
    }

    /*
     * Exception decompiling
     */
    protected StoreValue<T> deserialize(File file) throws ObjectStoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void deleteStoreFile(File file) throws ObjectStoreException {
        if (file.exists()) {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                throw new ObjectStoreException(I18nMessageFactory.createStaticMessage((String)("Deleting " + file.getAbsolutePath() + " failed")), (Throwable)e);
            }
        } else {
            throw new ObjectDoesNotExistException();
        }
        this.realKeyToUUIDIndex.removeValue((Object)file.getName());
    }

    private int trimToMaxSize(File[] files, int maxEntries) throws ObjectStoreException {
        if (maxEntries == 0) {
            return 0;
        }
        int expired = 0;
        int excess = files.length - maxEntries;
        if (excess > 0) {
            for (int i = 0; i < excess; ++i) {
                this.deleteStoreFile(files[i]);
                ++expired;
            }
        }
        return expired;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public static class StoreValue<T>
    implements Serializable {
        private final Serializable key;
        private final T value;

        public StoreValue(Serializable key, T value) {
            this.key = key;
            this.value = value;
        }

        public Serializable getKey() {
            return this.key;
        }

        public T getValue() {
            return this.value;
        }
    }
}

