/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal.singleapp;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.internal.util.rx.ImmediateScheduler;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.internal.AbstractDeploymentService;
import org.mule.runtime.module.deployment.internal.DefaultArchiveDeployer;
import org.mule.runtime.module.deployment.internal.DefaultArtifactDeployer;
import org.mule.runtime.module.deployment.internal.DeploymentDirectoryWatcher;
import org.mule.runtime.module.deployment.internal.DeploymentFileResolver;
import org.mule.runtime.module.deployment.internal.DeploymentUtils;
import org.mule.runtime.module.deployment.internal.DomainArchiveDeployer;
import org.mule.runtime.module.deployment.internal.DomainBundleArchiveDeployer;
import org.mule.runtime.module.deployment.internal.singleapp.SingleAppApplicationDeployerBuilder;
import org.mule.runtime.module.deployment.internal.singleapp.SingleAppDomainDeployerBuilder;
import org.mule.runtime.module.deployment.internal.util.ObservableList;

public class SingleAppDeploymentService
extends AbstractDeploymentService
implements DeploymentService,
Startable {
    public static final String MULE_APPS_PATH_ENV = "MULE_APPS_PATH";
    private final DomainArchiveDeployer domainDeployer;
    private final ObservableList<Domain> domains = new ObservableList();
    private final ObservableList<Application> applications = new ObservableList();
    private final DeploymentFileResolver fileResolver;
    private final Supplier<SchedulerService> artifactStartExecutorSupplier;
    private DefaultArchiveDeployer<ApplicationDescriptor, Application> applicationDeployer;
    private Consumer<Throwable> deploymentErrorConsumer = t -> {};
    private DeploymentDirectoryWatcher deploymentDirectoryWatcher;

    public SingleAppDeploymentService(SingleAppDomainDeployerBuilder singleAppDomainDeployerBuilder, SingleAppApplicationDeployerBuilder applicationDeployerBuilder, DeploymentFileResolver fileResolver, List<Application> applications, List<Domain> domains, Supplier<SchedulerService> artifactStartExecutorSupplier) {
        this.applications.addAll(applications);
        this.domains.addAll(domains);
        this.fileResolver = fileResolver;
        this.artifactStartExecutorSupplier = artifactStartExecutorSupplier;
        Supplier<Scheduler> artifactStartExecutor = () -> ImmediateScheduler.IMMEDIATE_SCHEDULER;
        DefaultArtifactDeployer<Application> applicationMuleDeployer = new DefaultArtifactDeployer<Application>(artifactStartExecutor);
        this.domainDeployer = singleAppDomainDeployerBuilder.withDomains(this.domains).withDeploymentService(this).withDomainArtifactDeployer(new DefaultArtifactDeployer<Domain>(artifactStartExecutor)).withDomainDeploymentListener(this.getDomainDeploymentListener()).withApplications(applications).withApplicationDeploymentListener(this.getApplicationDeploymentListener()).withApplicationArtifactDeployer(applicationMuleDeployer).build();
        this.applicationDeployer = applicationDeployerBuilder.withApplicationDeployer(new DefaultArtifactDeployer<Application>(artifactStartExecutor)).withApplicationDeploymentListener(this.getApplicationDeploymentListener()).withApplications(this.applications).build();
        this.applicationDeployer.setDeploymentListener(this.getApplicationDeploymentListener());
    }

    @Override
    public Application findApplication(String appName) {
        Preconditions.checkArgument((appName != null ? 1 : 0) != 0, (String)"Application name cannot be null");
        return this.applications.stream().filter(app -> app.getArtifactName().equals(appName)).findFirst().orElse(null);
    }

    @Override
    public List<Application> getApplications() {
        return this.applications;
    }

    @Override
    public Domain findDomain(String domainName) {
        Preconditions.checkArgument((domainName != null ? 1 : 0) != 0, (String)"Domain name cannot be null");
        return this.domains.stream().filter(domain -> domain.getArtifactName().contains(domainName)).findFirst().orElse(null);
    }

    @Override
    public Collection<Application> findDomainApplications(String domainName) {
        Preconditions.checkArgument((domainName != null ? 1 : 0) != 0, (String)"Domain name cannot be null");
        return this.applications.stream().filter(application -> application.getDomain() != null && application.getDomain().getArtifactName().equals(domainName)).collect(Collectors.toList());
    }

    @Override
    public List<Domain> getDomains() {
        return Collections.unmodifiableList(this.domains);
    }

    @Override
    public void undeploy(String appName) {
        throw new UnsupportedOperationException("Application undeploy operation not supported");
    }

    @Override
    public void deploy(URI appArchiveUri) throws IOException {
        this.deploy(appArchiveUri, Optional.empty());
    }

    @Override
    public void deploy(URI appArchiveUri, Properties appProperties) throws IOException {
        this.deploy(appArchiveUri, Optional.ofNullable(appProperties));
    }

    private synchronized void deploy(URI appUri, Optional<Properties> deploymentProperties) throws IOException {
        block7: {
            if (!this.applications.isEmpty()) {
                throw new UnsupportedOperationException("A deployment cannot be done if there is an already deployed app in single app mode.");
            }
            try {
                File artifactLocation = this.fileResolver.resolve(appUri);
                String fileName = artifactLocation.getName();
                if (fileName.endsWith(".jar")) {
                    this.applicationDeployer.deployPackagedArtifact(appUri, this.mergeDeploymentProperties(deploymentProperties));
                    break block7;
                }
                if (!artifactLocation.getParent().equals(appUri.getPath())) {
                    try {
                        FileUtils.copyDirectory((File)artifactLocation, (File)new File(MuleFoldersUtil.getAppsFolder(), fileName));
                    }
                    catch (IOException e) {
                        throw new MuleRuntimeException((Throwable)e);
                    }
                }
                this.applicationDeployer.deployExplodedArtifact(fileName, this.mergeDeploymentProperties(deploymentProperties));
            }
            catch (Throwable t) {
                this.deploymentErrorConsumer.accept(t);
            }
        }
    }

    private Optional<Properties> mergeDeploymentProperties(Optional<Properties> deploymentProperties) {
        if (deploymentProperties.isEmpty()) {
            return this.createAdditionalDeploymentProperties();
        }
        return deploymentProperties.map(p -> {
            this.createAdditionalDeploymentProperties().ifPresent(p::putAll);
            return p;
        });
    }

    @Override
    public void redeploy(String artifactName) {
        throw new UnsupportedOperationException("Application redeploy operation not supported");
    }

    @Override
    public void redeploy(String artifactName, Properties appProperties) {
        throw new UnsupportedOperationException("Application redeploy operation not supported");
    }

    @Override
    public void redeploy(URI archiveUri, Properties appProperties) throws IOException {
        throw new UnsupportedOperationException("Application redeploy operation not supported");
    }

    @Override
    public void redeploy(URI archiveUri) throws IOException {
        throw new UnsupportedOperationException("Application redeploy operation not supported");
    }

    @Override
    public void undeployDomain(String domainName) {
        throw new UnsupportedOperationException("Domain undeploy operation not supported");
    }

    @Override
    public void deployDomain(URI domainArchiveUri) throws IOException {
        throw new UnsupportedOperationException("Domain deploy operation not supported");
    }

    @Override
    public void deployDomain(URI domainArchiveUri, Properties deploymentProperties) throws IOException {
        throw new UnsupportedOperationException("Domain deploy operation not supported");
    }

    @Override
    public void redeployDomain(String domainName, Properties deploymentProperties) {
        throw new UnsupportedOperationException("Domain redeploy operation not supported");
    }

    @Override
    public void redeployDomain(String domainName) {
        throw new UnsupportedOperationException("Domain redeploy operation not supported");
    }

    @Override
    public void deployDomainBundle(URI domainArchiveUri) throws IOException {
        throw new UnsupportedOperationException("Domain bundle deploy operation not supported");
    }

    @Override
    public void start() {
        try {
            String muleAppsPath = System.getenv(MULE_APPS_PATH_ENV);
            if (muleAppsPath != null) {
                if (muleAppsPath.toLowerCase().endsWith(".jar")) {
                    throw new IllegalArgumentException("Invalid Mule app path: '" + muleAppsPath + "'");
                }
                this.startDeployment(new File(muleAppsPath).toURI());
            } else {
                this.startDeploymentDirectoryWatcher();
            }
            this.notifyStartupListeners();
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Error on starting single app mode"), (Throwable)e);
        }
    }

    private void startDeployment(URI appUri) throws IOException {
        DeploymentUtils.deployExplodedDomains(this.domainDeployer);
        this.deploy(appUri);
    }

    private void startDeploymentDirectoryWatcher() {
        this.deploymentDirectoryWatcher = this.resolveDeploymentDirectoryWatcher();
        this.addDeploymentListener(new DeploymentListener(){

            @Override
            public void onDeploymentSuccess(String artifactName) {
                SingleAppDeploymentService.this.deploymentDirectoryWatcher.stop();
            }

            @Override
            public void onDeploymentFailure(String artifactName, Throwable cause) {
                SingleAppDeploymentService.this.deploymentErrorConsumer.accept(cause);
            }
        });
        this.deploymentDirectoryWatcher.start();
    }

    protected DeploymentDirectoryWatcher resolveDeploymentDirectoryWatcher() {
        Optional<Properties> additionalDeploymentProperties = this.createAdditionalDeploymentProperties();
        return new DeploymentDirectoryWatcher(additionalDeploymentProperties, new DomainBundleArchiveDeployer(additionalDeploymentProperties, this.getDomainDeploymentListener(), this.domainDeployer, this.domains, this.applicationDeployer, this.getDomainDeploymentListener(), this.getApplicationDeploymentListener(), this), this.domainDeployer, this.applicationDeployer, this.domains, this.applications, this.artifactStartExecutorSupplier, this.getLock(), false);
    }

    @Override
    public void stop() {
        if (this.deploymentDirectoryWatcher != null) {
            this.deploymentDirectoryWatcher.stop(true);
        }
    }

    @Override
    public void onDeploymentError(Consumer<Throwable> deploymentErrorConsumer) {
        this.deploymentErrorConsumer = deploymentErrorConsumer;
    }
}

