/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.store;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.TemplateObjectStore;

public class ProvidedObjectStoreWrapper<T extends Serializable>
extends TemplateObjectStore<T>
implements Disposable {
    private ObjectStore<T> wrapped;
    private final boolean provided;

    public ProvidedObjectStoreWrapper(ObjectStore<T> providedObjectStore, Supplier<ObjectStore> objectStoreSupplier) {
        if (providedObjectStore == null) {
            this.provided = false;
            this.wrapped = objectStoreSupplier.get();
        } else {
            this.provided = true;
            this.wrapped = providedObjectStore;
        }
    }

    protected boolean doContains(String key) throws ObjectStoreException {
        return this.getWrapped().contains(key);
    }

    protected void doStore(String key, T value) throws ObjectStoreException {
        this.getWrapped().store(key, value);
    }

    protected T doRetrieve(String key) throws ObjectStoreException {
        return (T)this.getWrapped().retrieve(key);
    }

    protected T doRemove(String key) throws ObjectStoreException {
        return (T)this.getWrapped().remove(key);
    }

    public boolean isPersistent() {
        return this.getWrapped().isPersistent();
    }

    public boolean isDistributed() {
        return this.getWrapped().isDistributed();
    }

    public void clear() throws ObjectStoreException {
        this.getWrapped().clear();
    }

    public void dispose() {
        if (!this.provided && this.wrapped != null && this.wrapped instanceof Disposable) {
            ((Disposable)this.wrapped).dispose();
        }
        this.wrapped = null;
    }

    public void open() throws ObjectStoreException {
        this.getWrapped().open();
    }

    public void close() throws ObjectStoreException {
        this.getWrapped().close();
    }

    public List<String> allKeys() throws ObjectStoreException {
        return this.getWrapped().allKeys();
    }

    public Map<String, T> retrieveAll() throws ObjectStoreException {
        return this.getWrapped().retrieveAll();
    }

    protected ObjectStore<T> getWrapped() {
        return this.wrapped;
    }
}

