/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.server;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.ServerAddress;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.service.http.netty.impl.server.ForwardingToListenerHandler;
import org.mule.service.http.netty.impl.server.util.DefaultServerAddress;
import org.mule.service.http.netty.impl.server.util.HttpListenerRegistry;
import org.mule.service.http.test.netty.tck.ExecutorRule;
import org.mule.tck.probe.PollingProber;

public class ForwardingToListenerHandlerTestCase {
    @ClassRule
    public static ExecutorRule executorRule = new ExecutorRule();
    private ForwardingToListenerHandler handler;
    @Rule
    public MockitoRule rule = MockitoJUnit.rule();
    @Mock
    private HttpListenerRegistry httpListenerRegistry;
    @Mock
    private RequestHandler requestHandler;
    @Mock
    private RequestHandler errorRequestHandler;
    @Mock
    private SslHandler sslHandler;
    @Mock
    private ChannelHandlerContext ctx;
    @Mock
    private Channel channel;

    @Before
    public void setUp() {
        Mockito.when((Object)this.ctx.channel()).thenReturn((Object)this.channel);
        Mockito.when((Object)this.httpListenerRegistry.getRequestHandler((ServerAddress)ArgumentMatchers.any(ServerAddress.class), (HttpRequest)ArgumentMatchers.any(HttpRequest.class))).thenReturn((Object)this.requestHandler);
        Mockito.when((Object)this.httpListenerRegistry.getErrorHandler((Throwable)ArgumentMatchers.any(Throwable.class))).thenReturn((Object)this.errorRequestHandler);
        ServerAddress serverAddress = ForwardingToListenerHandlerTestCase.createServerAddress("localhost", 54321);
        this.handler = new ForwardingToListenerHandler(serverAddress, this.httpListenerRegistry, this.sslHandler, (Executor)executorRule.getExecutor());
    }

    @Test
    public void whenExceptionCaughtThenContextIsClosed() {
        this.handler.exceptionCaught(this.ctx, new Throwable("Expected"));
        ((ChannelHandlerContext)Mockito.verify((Object)this.ctx)).close();
    }

    @Test
    public void handleRequestInMultipleObjects() throws Exception {
        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "https://www.mulesoft.com");
        request.headers().addInt((CharSequence)"Content-Length", 12);
        this.handler.channelRead0(this.ctx, (HttpObject)request);
        ArgumentCaptor reqCtxCaptor = ArgumentCaptor.forClass(HttpRequestContext.class);
        PollingProber.probe(() -> {
            ((RequestHandler)Mockito.verify((Object)this.requestHandler)).handleRequest((HttpRequestContext)reqCtxCaptor.capture(), (HttpResponseReadyCallback)ArgumentMatchers.any(HttpResponseReadyCallback.class));
            return true;
        });
        HttpRequest muleRequest = ((HttpRequestContext)reqCtxCaptor.getValue()).getRequest();
        HttpEntity entity = muleRequest.getEntity();
        byte[] bytes = new byte[4];
        this.handler.channelRead0(this.ctx, (HttpObject)new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])"abcd".getBytes())));
        int actuallyRead = entity.getContent().read(bytes);
        MatcherAssert.assertThat((Object)actuallyRead, (Matcher)Matchers.is((Object)4));
        MatcherAssert.assertThat((Object)new String(bytes), (Matcher)Matchers.is((Object)"abcd"));
        this.handler.channelRead0(this.ctx, (HttpObject)new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])"abcd".getBytes())));
        actuallyRead = entity.getContent().read(bytes);
        MatcherAssert.assertThat((Object)actuallyRead, (Matcher)Matchers.is((Object)4));
        MatcherAssert.assertThat((Object)new String(bytes), (Matcher)Matchers.is((Object)"abcd"));
        this.handler.channelRead0(this.ctx, (HttpObject)new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])"abcd".getBytes())));
        actuallyRead = entity.getContent().read(bytes);
        MatcherAssert.assertThat((Object)actuallyRead, (Matcher)Matchers.is((Object)4));
        MatcherAssert.assertThat((Object)new String(bytes), (Matcher)Matchers.is((Object)"abcd"));
        this.handler.channelRead0(this.ctx, (HttpObject)LastHttpContent.EMPTY_LAST_CONTENT);
        MatcherAssert.assertThat((Object)entity.getContent().read(), (Matcher)Matchers.is((Object)-1));
    }

    @Test
    public void handleRequestAsFullRequest() throws Exception {
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "https://www.mulesoft.com", Unpooled.wrappedBuffer((byte[])"abcd".getBytes()));
        request.headers().addInt((CharSequence)"Content-Length", 4);
        this.handler.channelRead0(this.ctx, (HttpObject)request);
        ArgumentCaptor reqCtxCaptor = ArgumentCaptor.forClass(HttpRequestContext.class);
        PollingProber.probe(() -> {
            ((RequestHandler)Mockito.verify((Object)this.requestHandler)).handleRequest((HttpRequestContext)reqCtxCaptor.capture(), (HttpResponseReadyCallback)ArgumentMatchers.any(HttpResponseReadyCallback.class));
            return true;
        });
        HttpRequest muleRequest = ((HttpRequestContext)reqCtxCaptor.getValue()).getRequest();
        HttpEntity entity = muleRequest.getEntity();
        byte[] bytes = new byte[4];
        int actuallyRead = entity.getContent().read(bytes);
        MatcherAssert.assertThat((Object)actuallyRead, (Matcher)Matchers.is((Object)4));
        MatcherAssert.assertThat((Object)new String(bytes), (Matcher)Matchers.is((Object)"abcd"));
        MatcherAssert.assertThat((Object)entity.getContent().read(), (Matcher)Matchers.is((Object)-1));
    }

    @Test
    public void readerClosesTheStreamAndNothingFails() throws Exception {
        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "https://www.mulesoft.com");
        request.headers().addInt((CharSequence)"Content-Length", 12);
        this.handler.channelRead0(this.ctx, (HttpObject)request);
        ArgumentCaptor reqCtxCaptor = ArgumentCaptor.forClass(HttpRequestContext.class);
        PollingProber.probe(() -> {
            ((RequestHandler)Mockito.verify((Object)this.requestHandler)).handleRequest((HttpRequestContext)reqCtxCaptor.capture(), (HttpResponseReadyCallback)ArgumentMatchers.any(HttpResponseReadyCallback.class));
            return true;
        });
        HttpRequest muleRequest = ((HttpRequestContext)reqCtxCaptor.getValue()).getRequest();
        HttpEntity entity = muleRequest.getEntity();
        byte[] bytes = new byte[4];
        this.handler.channelRead0(this.ctx, (HttpObject)new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])"abcd".getBytes())));
        int actuallyRead = entity.getContent().read(bytes);
        MatcherAssert.assertThat((Object)actuallyRead, (Matcher)Matchers.is((Object)4));
        MatcherAssert.assertThat((Object)new String(bytes), (Matcher)Matchers.is((Object)"abcd"));
        entity.getContent().close();
        this.handler.channelRead0(this.ctx, (HttpObject)new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])"abcd".getBytes())));
    }

    @Test
    public void errorHandler() throws Exception {
        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "https://www.mulesoft.com");
        request.setDecoderResult(DecoderResult.failure((Throwable)new DecoderException("Expected")));
        this.handler.channelRead0(this.ctx, (HttpObject)request);
        PollingProber.probe(() -> {
            ((RequestHandler)Mockito.verify((Object)this.errorRequestHandler)).handleRequest((HttpRequestContext)ArgumentMatchers.any(HttpRequestContext.class), (HttpResponseReadyCallback)ArgumentMatchers.any(HttpResponseReadyCallback.class));
            return true;
        });
    }

    private static ServerAddress createServerAddress(String host, int port) {
        InetSocketAddress localAddress = new InetSocketAddress(host, port);
        return new DefaultServerAddress(localAddress.getAddress(), localAddress.getPort());
    }
}

