/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.FlowConstructNotification;
import org.mule.runtime.api.notification.FlowConstructNotificationListener;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.context.notification.ServerNotificationManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.execution.ExceptionContextProvider;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.policy.OperationPolicyParametersTransformer;
import org.mule.runtime.core.api.policy.Policy;
import org.mule.runtime.core.api.policy.PolicyProvider;
import org.mule.runtime.core.api.policy.SourcePolicyParametersTransformer;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.event.InternalEvent;
import org.mule.runtime.core.internal.exception.MessagingExceptionResolver;
import org.mule.runtime.core.internal.policy.CompositePolicyFactory;
import org.mule.runtime.core.internal.policy.DefaultOperationPolicyProcessorFactory;
import org.mule.runtime.core.internal.policy.DefaultSourcePolicyProcessorFactory;
import org.mule.runtime.core.internal.policy.DeferredDisposable;
import org.mule.runtime.core.internal.policy.MessageSourceResponseParametersProcessor;
import org.mule.runtime.core.internal.policy.NoSourcePolicy;
import org.mule.runtime.core.internal.policy.NullPolicyProvider;
import org.mule.runtime.core.internal.policy.OperationParametersProcessor;
import org.mule.runtime.core.internal.policy.OperationPolicy;
import org.mule.runtime.core.internal.policy.OperationPolicyProcessorFactory;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.core.internal.policy.PolicyPointcutParametersManager;
import org.mule.runtime.core.internal.policy.SourcePolicy;
import org.mule.runtime.core.internal.policy.SourcePolicyContext;
import org.mule.runtime.core.internal.policy.SourcePolicyProcessorFactory;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.mule.runtime.core.privileged.exception.MessagingException;
import org.mule.runtime.policy.api.OperationPolicyPointcutParametersFactory;
import org.mule.runtime.policy.api.PolicyPointcutParameters;
import org.mule.runtime.policy.api.SourcePolicyPointcutParametersFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPolicyManager
implements PolicyManager,
Lifecycle {
    public static final long POLL_INTERVAL = TimeUnit.SECONDS.toMillis(5L);
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPolicyManager.class);
    private static final OperationPolicy NO_POLICY_OPERATION = (operationEvent, operationExecutionFunction, opParamProcessor, componentLocation, callback) -> operationExecutionFunction.execute(opParamProcessor.getOperationParameters(), operationEvent, callback);
    @Inject
    private ErrorTypeLocator errorTypeLocator;
    @Inject
    private Collection<ExceptionContextProvider> exceptionContextProviders;
    private ServerNotificationManager notificationManager;
    private CompositePolicyFactory compositePolicyFactory = new CompositePolicyFactory();
    private final AtomicBoolean isSourcePoliciesAvailable = new AtomicBoolean(false);
    private final AtomicBoolean isOperationPoliciesAvailable = new AtomicBoolean(false);
    private final ReferenceQueue<DeferredDisposable> stalePoliciesQueue = new ReferenceQueue();
    private final Set<DeferredDisposableWeakReference> activePolicies = new HashSet<DeferredDisposableWeakReference>();
    private final ReentrantReadWriteLock cacheInvalidateLock = new ReentrantReadWriteLock();
    private volatile boolean stopped = true;
    private Future<?> taskHandle;
    private MuleConfiguration configuration;
    private SchedulerService schedulerService;
    private Provider<SchedulerConfig> schedulerBaseConfig;
    private Scheduler scheduler;
    private final Cache<String, SourcePolicy> noPolicySourceInstances = Caffeine.newBuilder().build();
    private final Cache<Pair<String, List<Policy>>, SourcePolicy> sourcePolicyInnerCache = Caffeine.newBuilder().build();
    private final Cache<Pair<String, List<Policy>>, OperationPolicy> operationPolicyInnerCache = Caffeine.newBuilder().build();
    private Cache<Pair<String, PolicyPointcutParameters>, SourcePolicy> sourcePolicyOuterCache = Caffeine.newBuilder().expireAfterAccess(60L, TimeUnit.SECONDS).build();
    private Cache<Pair<String, PolicyPointcutParameters>, OperationPolicy> operationPolicyOuterCache = Caffeine.newBuilder().expireAfterAccess(60L, TimeUnit.SECONDS).build();
    private Optional<PolicyProvider> policyProvider;
    private Collection<SourcePolicyParametersTransformer> sourcePolicyParametersTransformers;
    private Collection<OperationPolicyParametersTransformer> operationPolicyParametersTransformers;
    private Collection<SourcePolicyPointcutParametersFactory> sourcePolicyPointcutParametersFactories;
    private Collection<OperationPolicyPointcutParametersFactory> operationPolicyPointcutParametersFactories;
    private OperationPolicyProcessorFactory operationPolicyProcessorFactory;
    private SourcePolicyProcessorFactory sourcePolicyProcessorFactory;
    private PolicyPointcutParametersManager policyPointcutParametersManager;
    @Inject
    private FeatureFlaggingService featureFlaggingService;

    public static OperationPolicy noPolicyOperation() {
        return NO_POLICY_OPERATION;
    }

    public static boolean isNoPolicyOperation(OperationPolicy policy) {
        return NO_POLICY_OPERATION.equals(policy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SourcePolicy createSourcePolicyInstance(Component source, CoreEvent sourceEvent, ReactiveProcessor flowExecutionProcessor, MessageSourceResponseParametersProcessor messageSourceResponseParametersProcessor) {
        ComponentIdentifier sourceIdentifier = source.getLocation().getComponentIdentifier().getIdentifier();
        String sourceRootName = source.getRootContainerLocation().getGlobalName();
        if (!this.isSourcePoliciesAvailable.get()) {
            SourcePolicy policy = (SourcePolicy)this.noPolicySourceInstances.getIfPresent((Object)sourceRootName);
            if (policy != null) {
                return policy;
            }
            return (SourcePolicy)this.noPolicySourceInstances.get((Object)sourceRootName, k -> new NoSourcePolicy(flowExecutionProcessor));
        }
        SourcePolicyContext ctx = SourcePolicyContext.from(sourceEvent);
        PolicyPointcutParameters sourcePointcutParameters = ctx.getPointcutParameters();
        Pair policyKey = new Pair((Object)sourceRootName, (Object)sourcePointcutParameters);
        SourcePolicy policy = (SourcePolicy)this.sourcePolicyOuterCache.getIfPresent((Object)policyKey);
        if (policy != null) {
            return policy;
        }
        this.cacheInvalidateLock.readLock().lock();
        try {
            LOGGER.debug("Source policy - populating outer cache for {}", (Object)policyKey);
            SourcePolicy sourcePolicy = (SourcePolicy)this.sourcePolicyOuterCache.get((Object)policyKey, outerKey -> (SourcePolicy)this.sourcePolicyInnerCache.get((Object)new Pair((Object)sourceRootName, this.policyProvider.orElse(new NullPolicyProvider()).findSourceParameterizedPolicies(sourcePointcutParameters)), innerKey -> ((List)innerKey.getSecond()).isEmpty() ? new NoSourcePolicy(flowExecutionProcessor) : this.compositePolicyFactory.createSourcePolicy((List)innerKey.getSecond(), flowExecutionProcessor, this.lookupSourceParametersTransformer(sourceIdentifier), this.sourcePolicyProcessorFactory, exception -> new MessagingExceptionResolver(source).resolve((MessagingException)((Object)((Object)((Object)exception))), this.errorTypeLocator, this.exceptionContextProviders))));
            this.activePolicies.add(new DeferredDisposableWeakReference((DeferredDisposable)((Object)sourcePolicy), this.stalePoliciesQueue));
            SourcePolicy sourcePolicy2 = sourcePolicy;
            return sourcePolicy2;
        }
        finally {
            this.cacheInvalidateLock.readLock().unlock();
        }
    }

    @Override
    public PolicyPointcutParameters addSourcePointcutParametersIntoEvent(Component source, TypedValue<?> attributes, InternalEvent event) {
        PolicyPointcutParameters sourcePolicyParams = this.policyPointcutParametersManager.createSourcePointcutParameters(source, attributes);
        event.setSourcePolicyContext(new SourcePolicyContext(sourcePolicyParams));
        return sourcePolicyParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationPolicy createOperationPolicy(Component operation, CoreEvent event, OperationParametersProcessor operationParameters) {
        if (!this.isOperationPoliciesAvailable.get()) {
            return NO_POLICY_OPERATION;
        }
        PolicyPointcutParameters operationPointcutParameters = this.policyPointcutParametersManager.createOperationPointcutParameters(operation, event, operationParameters.getOperationParameters());
        String operationLocation = operation.getLocation().getLocation();
        ComponentIdentifier operationIdentifier = operation.getLocation().getComponentIdentifier().getIdentifier();
        Pair policyKey = new Pair((Object)operationLocation, (Object)operationPointcutParameters);
        OperationPolicy policy = (OperationPolicy)this.operationPolicyOuterCache.getIfPresent((Object)policyKey);
        if (policy != null) {
            return policy;
        }
        this.cacheInvalidateLock.readLock().lock();
        try {
            LOGGER.debug("Operation policy - populating outer cache for {}", (Object)policyKey);
            OperationPolicy operationPolicy = (OperationPolicy)this.operationPolicyOuterCache.get((Object)policyKey, outerKey -> (OperationPolicy)this.operationPolicyInnerCache.get((Object)new Pair((Object)operationLocation, this.policyProvider.orElse(new NullPolicyProvider()).findOperationParameterizedPolicies((PolicyPointcutParameters)outerKey.getSecond())), innerKey -> ((List)innerKey.getSecond()).isEmpty() ? NO_POLICY_OPERATION : this.compositePolicyFactory.createOperationPolicy(operation, (List)innerKey.getSecond(), this.lookupOperationParametersTransformer(operationIdentifier), this.operationPolicyProcessorFactory, this.configuration.getShutdownTimeout(), this.schedulerService.ioScheduler(((SchedulerConfig)this.schedulerBaseConfig.get()).withMaxConcurrentTasks(1).withName(operationLocation + ".policy.flux.")), this.featureFlaggingService)));
            if (operationPolicy instanceof DeferredDisposable) {
                this.activePolicies.add(new DeferredDisposableWeakReference((DeferredDisposable)((Object)operationPolicy), this.stalePoliciesQueue));
            }
            OperationPolicy operationPolicy2 = operationPolicy;
            return operationPolicy2;
        }
        finally {
            this.cacheInvalidateLock.readLock().unlock();
        }
    }

    private Optional<OperationPolicyParametersTransformer> lookupOperationParametersTransformer(ComponentIdentifier componentIdentifier) {
        return this.operationPolicyParametersTransformers.stream().filter(policyOperationParametersTransformer -> policyOperationParametersTransformer.supports(componentIdentifier)).findAny();
    }

    private Optional<SourcePolicyParametersTransformer> lookupSourceParametersTransformer(ComponentIdentifier componentIdentifier) {
        return this.sourcePolicyParametersTransformers.stream().filter(policyOperationParametersTransformer -> policyOperationParametersTransformer.supports(componentIdentifier)).findAny();
    }

    public void initialise() throws InitialisationException {
        this.scheduler = this.schedulerService.customScheduler(SchedulerConfig.config().withMaxConcurrentTasks(1).withName("PolicyManager-StaleCleaner"));
        this.operationPolicyProcessorFactory = new DefaultOperationPolicyProcessorFactory();
        this.sourcePolicyProcessorFactory = new DefaultSourcePolicyProcessorFactory();
        if (this.configuration.getArtifactType().equals((Object)ArtifactType.APP)) {
            PolicyProvider resolvedPolicyProvider = this.policyProvider.orElse(new NullPolicyProvider());
            resolvedPolicyProvider.onPoliciesChanged(() -> {
                this.evictCaches();
                this.isSourcePoliciesAvailable.set(resolvedPolicyProvider.isSourcePoliciesAvailable());
                this.isOperationPoliciesAvailable.set(resolvedPolicyProvider.isOperationPoliciesAvailable());
            });
            this.isSourcePoliciesAvailable.set(resolvedPolicyProvider.isSourcePoliciesAvailable());
            this.isOperationPoliciesAvailable.set(resolvedPolicyProvider.isOperationPoliciesAvailable());
        }
        this.policyPointcutParametersManager = new PolicyPointcutParametersManager(this.sourcePolicyPointcutParametersFactories, this.operationPolicyPointcutParametersFactories);
        this.notificationManager.addListener((NotificationListener<?>)new FlowConstructNotificationListener<FlowConstructNotification>(){

            public boolean isBlocking() {
                return false;
            }

            public void onNotification(FlowConstructNotification notification) {
                if (Integer.parseInt(notification.getAction().getIdentifier()) == 1503) {
                    LOGGER.debug("Invalidating flow from caches named {}", (Object)notification.getResourceIdentifier());
                    DefaultPolicyManager.this.invalidateDisposedFlowFromCaches(notification.getResourceIdentifier());
                }
            }
        });
    }

    private void invalidateDisposedFlowFromCaches(String flowName) {
        this.noPolicySourceInstances.invalidate((Object)flowName);
        this.sourcePolicyInnerCache.asMap().keySet().stream().filter(pair -> ((String)pair.getFirst()).equals(flowName)).forEach(matchingPair -> this.sourcePolicyInnerCache.invalidate(matchingPair));
        this.sourcePolicyOuterCache.asMap().keySet().stream().filter(pair -> ((String)pair.getFirst()).equals(flowName)).forEach(matchingPair -> this.sourcePolicyOuterCache.invalidate(matchingPair));
    }

    public void start() throws MuleException {
        this.stopped = false;
        try {
            LOGGER.trace("starting disposeStalePolicies...");
            this.taskHandle = this.scheduler.submit(this::disposeStalePolicies);
        }
        catch (Exception e) {
            this.stopped = true;
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public void stop() throws MuleException {
        this.stopped = true;
        this.taskHandle.cancel(true);
        this.taskHandle = null;
    }

    public void dispose() {
        this.disposePolicies();
        try {
            while (this.stalePoliciesQueue.remove(1L) != null) {
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MuleRuntimeException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            if (System.getProperty("mule.lifecycle.failOnFirstDisposeError") != null) {
                throw new MuleRuntimeException((Throwable)e);
            }
            LOGGER.warn("Exception when disposing DefaultPolicyManager", (Throwable)e);
        }
        this.evictCaches();
        this.scheduler.stop();
        this.activePolicies.clear();
    }

    private void disposePolicies() {
        this.noPolicySourceInstances.asMap().values().forEach(policy -> {
            this.clearActive(policy);
            LifecycleUtils.disposeIfNeeded(policy, LOGGER);
        });
        this.sourcePolicyInnerCache.asMap().values().forEach(policy -> {
            this.clearActive(policy);
            LifecycleUtils.disposeIfNeeded(policy, LOGGER);
        });
        this.operationPolicyInnerCache.asMap().values().forEach(policy -> {
            this.clearActive(policy);
            LifecycleUtils.disposeIfNeeded(policy, LOGGER);
        });
    }

    private void clearActive(Object policy) {
        Iterator<DeferredDisposableWeakReference> iterator = this.activePolicies.iterator();
        while (iterator.hasNext()) {
            if (policy != iterator.next().get()) continue;
            iterator.remove();
        }
    }

    private void evictCaches() {
        this.cacheInvalidateLock.writeLock().lock();
        try {
            this.noPolicySourceInstances.invalidateAll();
            this.sourcePolicyInnerCache.invalidateAll();
            this.operationPolicyInnerCache.invalidateAll();
            this.sourcePolicyOuterCache.invalidateAll();
            this.operationPolicyOuterCache.invalidateAll();
        }
        finally {
            this.cacheInvalidateLock.writeLock().unlock();
        }
    }

    public void setCompositePolicyFactory(CompositePolicyFactory compositePolicyFactory) {
        this.compositePolicyFactory = compositePolicyFactory;
    }

    private void disposeStalePolicies() {
        while (!this.stopped && !Thread.currentThread().isInterrupted()) {
            try {
                LOGGER.trace("Checking for stale policy ...");
                DeferredDisposableWeakReference stalePolicy = (DeferredDisposableWeakReference)this.stalePoliciesQueue.remove(POLL_INTERVAL);
                if (stalePolicy != null) {
                    LOGGER.debug("Disposing stale policy '{}'...", (Object)stalePolicy);
                    LifecycleUtils.disposeIfNeeded(stalePolicy, LOGGER);
                    this.activePolicies.remove(stalePolicy);
                    continue;
                }
                LOGGER.trace("No stale policy, will retry");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.debug("Stale policies cleaner thread was interrupted. Finalizing.");
            }
            catch (Exception e) {
                LOGGER.error("Unhandled exception in disposeStalePolicies", (Throwable)e);
            }
        }
        LOGGER.trace("disposeStalePolicies finished. Stopped: {}; interrupted: {}", (Object)this.stopped, (Object)Thread.currentThread().isInterrupted());
    }

    void setOuterCachesExpireTime(int timeout, TimeUnit timeUnit) {
        this.sourcePolicyOuterCache = Caffeine.newBuilder().expireAfterAccess((long)timeout, timeUnit).build();
        this.operationPolicyOuterCache = Caffeine.newBuilder().expireAfterAccess((long)timeout, timeUnit).build();
    }

    int getActivePoliciesCount() {
        return this.activePolicies.size();
    }

    @Inject
    public void setConfiguration(MuleConfiguration configuration) {
        this.configuration = configuration;
    }

    @Inject
    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    @Inject
    public void setSchedulerBaseConfig(Provider<SchedulerConfig> schedulerBaseConfig) {
        this.schedulerBaseConfig = schedulerBaseConfig;
    }

    @Inject
    public void setNotificationManager(ServerNotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    @Inject
    public void setPolicyProvider(Optional<PolicyProvider> policyProvider) {
        this.policyProvider = policyProvider;
    }

    @Inject
    public void setSourcePolicyParametersTransformers(Optional<Collection<SourcePolicyParametersTransformer>> sourcePolicyParametersTransformers) {
        this.sourcePolicyParametersTransformers = sourcePolicyParametersTransformers.orElse(Collections.emptySet());
    }

    @Inject
    public void setOperationPolicyParametersTransformers(Optional<Collection<OperationPolicyParametersTransformer>> operationPolicyParametersTransformers) {
        this.operationPolicyParametersTransformers = operationPolicyParametersTransformers.orElse(Collections.emptySet());
    }

    @Inject
    public void setSourcePolicyPointcutParametersFactories(Optional<Collection<SourcePolicyPointcutParametersFactory>> sourcePolicyPointcutParametersFactories) {
        this.sourcePolicyPointcutParametersFactories = sourcePolicyPointcutParametersFactories.orElse(Collections.emptySet());
    }

    @Inject
    public void setOperationPolicyPointcutParametersFactories(Optional<Collection<OperationPolicyPointcutParametersFactory>> operationPolicyPointcutParametersFactories) {
        this.operationPolicyPointcutParametersFactories = operationPolicyPointcutParametersFactories.orElse(Collections.emptySet());
    }

    private static final class DeferredDisposableWeakReference
    extends WeakReference<DeferredDisposable>
    implements Disposable {
        private final Disposable deferredDispose;
        private final int hash;

        public DeferredDisposableWeakReference(DeferredDisposable referent, ReferenceQueue<? super DeferredDisposable> q) {
            super(referent, q);
            this.deferredDispose = referent.deferredDispose();
            this.hash = referent.hashCode();
        }

        public void dispose() {
            this.deferredDispose.dispose();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (!(o instanceof DeferredDisposableWeakReference)) {
                return false;
            }
            DeferredDisposable referent = (DeferredDisposable)this.get();
            DeferredDisposable otherReferent = (DeferredDisposable)((DeferredDisposableWeakReference)o).get();
            if (referent != null) {
                return referent.equals(otherReferent);
            }
            return otherReferent == null;
        }
    }
}

