/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer;

import jakarta.inject.Inject;
import java.nio.charset.Charset;
import java.util.Objects;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.config.ArtifactEncoding;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.transformer.MessageTransformerException;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.internal.transformer.TransformersRegistry;
import org.mule.runtime.core.internal.util.func.CheckedSupplier;

@NoExtend
public class DefaultTransformationService
implements TransformationService {
    @Inject
    private TransformersRegistry transformersRegistry;
    private ArtifactEncoding artifactEncoding;

    private Message internalTransform(Message message, DataType outputDataType) throws MessageTransformerException {
        Objects.requireNonNull(message, "Message cannot be null");
        Objects.requireNonNull(outputDataType, "DataType cannot be null");
        return Message.builder((Message)message).value(this.getPayload(message, outputDataType, this.resolveEncoding(message))).build();
    }

    private Object internalTransform(Object value, DataType valueDataType, DataType expectedDataType) throws MessageTransformerException, TransformerException {
        if (value != null) {
            Transformer transformer;
            try {
                transformer = this.transformersRegistry.lookupTransformer(valueDataType, expectedDataType);
            }
            catch (TransformerException e) {
                throw new TransformerException(I18nMessageFactory.createStaticMessage((String)"The value '%s' of type %s could not be transformed to the desired type %s", (Object[])new Object[]{value.toString().trim(), value.getClass().getName(), expectedDataType.getType().getName()}), (Throwable)((Object)e));
            }
            return transformer.transform(value);
        }
        return null;
    }

    protected <T> T getPayload(Message message, DataType resultType, Charset encoding) throws MessageTransformerException {
        if (resultType == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("resultType").getMessage());
        }
        DataType dataType = DataType.builder((DataType)resultType).type(message.getPayload().getDataType().getType()).build();
        if (resultType.isCompatibleWith(dataType)) {
            return (T)message.getPayload().getValue();
        }
        Transformer transformer = null;
        try {
            transformer = this.transformersRegistry.lookupTransformer(dataType, resultType);
            if (transformer == null) {
                throw new MessageTransformerException(CoreMessages.noTransformerFoundForMessage(dataType, resultType), null, message);
            }
            Object result = transformer.transform(message, encoding);
            this.checkResultDataType(message, resultType, result);
            return (T)result;
        }
        catch (MessageTransformerException e) {
            throw e;
        }
        catch (TransformerException e) {
            throw new MessageTransformerException(transformer, (Throwable)((Object)e), message);
        }
    }

    protected void checkResultDataType(Message message, DataType resultType, Object value) throws MessageTransformerException {
        if (value != null && !resultType.getType().isAssignableFrom(value.getClass())) {
            TypedValue actualType = TypedValue.of((Object)value);
            Message transformedMessage = Message.builder((Message)message).payload(actualType).build();
            throw new MessageTransformerException(CoreMessages.transformOnObjectNotOfSpecifiedType(resultType, actualType), null, transformedMessage);
        }
    }

    protected Charset resolveEncoding(Message message) {
        return message.getPayload().getDataType().getMediaType().getCharset().orElse(this.artifactEncoding.getDefaultEncoding());
    }

    public Object transform(Object value, DataType valueDataType, DataType expectedDataType) {
        return this.transformThrowingRuntimeException(() -> this.internalTransform(value, valueDataType, expectedDataType));
    }

    public Message transform(Message message, DataType outputDataType) {
        return this.transformThrowingRuntimeException(() -> this.internalTransform(message, outputDataType));
    }

    private <T> T transformThrowingRuntimeException(CheckedSupplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public ArtifactEncoding getArtifactEncoding() {
        return this.artifactEncoding;
    }

    @Inject
    public void setArtifactEncoding(ArtifactEncoding artifactEncoding) {
        this.artifactEncoding = artifactEncoding;
    }
}

