/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.benchmark;

import io.netty.util.ReferenceCounted;
import java.util.concurrent.TimeUnit;
import org.mule.service.http.test.netty.impl.benchmark.ServerPipelineBenchmarkState;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Fork(value=1, jvmArgsAppend={})
public class ServerPipelineBenchmark {
    @Benchmark
    @Threads(value=1)
    @Warmup(iterations=1, time=3, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=2, time=60, timeUnit=TimeUnit.SECONDS)
    public void readRequests(ServerPipelineBenchmarkState state) {
        state.requestAsByteBuf.resetReaderIndex();
        state.requestAsByteBuf.retain();
        try {
            state.channel.writeInbound(new Object[]{state.requestAsByteBuf});
            Object responseAsByteBuf = state.channel.readOutbound();
            if (responseAsByteBuf == null) {
                throw new IllegalStateException("No response read");
            }
            if (responseAsByteBuf instanceof ReferenceCounted) {
                ReferenceCounted referenceCounted = (ReferenceCounted)responseAsByteBuf;
                referenceCounted.release();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Request execution failed", e);
        }
    }
}

