/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.profiling.ProfilingService;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.Sink;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategyFactory;
import org.mule.runtime.core.internal.processor.strategy.AbstractProcessingStrategy;
import org.mule.runtime.core.internal.processor.strategy.DirectSink;
import org.mule.runtime.core.internal.processor.strategy.PerThreadSink;
import reactor.util.concurrent.Queues;

public class DirectStreamPerThreadProcessingStrategyFactory
implements ProcessingStrategyFactory {
    public static final ProcessingStrategy DIRECT_STREAM_PER_THREAD_PROCESSING_STRATEGY_INSTANCE = new AbstractProcessingStrategy(){

        @Override
        public boolean isSynchronous() {
            return true;
        }

        @Override
        public Sink createSink(FlowConstruct flowConstruct, ReactiveProcessor pipeline) {
            return new PerThreadSink(() -> new DirectSink(pipeline, event -> {}, Queues.SMALL_BUFFER_SIZE));
        }
    };

    @Override
    public ProcessingStrategy create(ProfilingService profilingService, FeatureFlaggingService featureFlaggingService, SchedulerService schedulerService, Supplier<SchedulerConfig> schedulerBaseConfig, String schedulersNamePrefix, String artifactId, ArtifactType artifactType, LongSupplier shutdownTimeoutSupplier) {
        return DIRECT_STREAM_PER_THREAD_PROCESSING_STRATEGY_INSTANCE;
    }
}

