/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Strings;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.container.internal.splash.SplashScreen;
import org.mule.runtime.deployment.model.api.DeployableArtifact;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.module.artifact.api.Artifact;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor;
import org.mule.runtime.module.deployment.impl.internal.util.DeploymentPropertiesUtils;
import org.mule.runtime.module.deployment.internal.ArchiveDeployer;
import org.mule.runtime.module.deployment.internal.DeploymentUtils;
import org.mule.runtime.module.deployment.internal.DomainBundleArchiveDeployer;
import org.mule.runtime.module.deployment.internal.util.DebuggableReentrantLock;
import org.mule.runtime.module.deployment.internal.util.ElementAddedEvent;
import org.mule.runtime.module.deployment.internal.util.ElementRemovedEvent;
import org.mule.runtime.module.deployment.internal.util.ObservableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentDirectoryWatcher
implements Runnable {
    public static final String ARTIFACT_ANCHOR_SUFFIX = "-anchor.txt";
    private static final Predicate<Path> IS_ANCHOR_FILE = ((Predicate<Path>)x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).and(p -> p.getFileName().toString().toLowerCase().endsWith(ARTIFACT_ANCHOR_SUFFIX));
    private static final Predicate<Path> IS_JAR_FILE = ((Predicate<Path>)x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).and(p -> p.getFileName().toString().toLowerCase().endsWith(".jar"));
    private static final Predicate<Path> IS_ZIP_FILE = ((Predicate<Path>)x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).and(p -> p.getFileName().toString().toLowerCase().endsWith(".zip"));
    private static final Pattern VERSION_CLASSIFIER_PATTERN = Pattern.compile("-\\d+(?:\\.\\d+)*+(?:-[\\w-]++)*+$");
    public static final String CHANGE_CHECK_INTERVAL_PROPERTY = "mule.launcher.changeCheckInterval";
    protected static final int DEFAULT_CHANGES_CHECK_INTERVAL_MS = 5000;
    private static final Logger logger = LoggerFactory.getLogger(DeploymentDirectoryWatcher.class);
    private static final Logger SPLASH_LOGGER = LoggerFactory.getLogger((String)"org.mule.runtime.core.internal.logging");
    private final ReentrantLock deploymentLock;
    private final Optional<Properties> additionalDeploymentProperties;
    private final ArchiveDeployer<DomainDescriptor, Domain> domainArchiveDeployer;
    protected final ArchiveDeployer<ApplicationDescriptor, Application> applicationArchiveDeployer;
    protected final Supplier<SchedulerService> schedulerServiceSupplier;
    private final ArtifactTimestampListener<Application> applicationTimestampListener;
    private final ArtifactTimestampListener<Domain> domainTimestampListener;
    private final ObservableList<Application> applications;
    private final ObservableList<Domain> domains;
    private final DomainBundleArchiveDeployer domainBundleDeployer;
    private final Path appsDir;
    private final Path domainsDir;
    private final boolean disposeArtifactsOnStop;
    private Scheduler artifactDirMonitorScheduler;
    protected volatile boolean dirty;

    public DeploymentDirectoryWatcher(Optional<Properties> additionalDeploymentProperties, DomainBundleArchiveDeployer domainBundleDeployer, ArchiveDeployer<DomainDescriptor, Domain> domainArchiveDeployer, ArchiveDeployer<ApplicationDescriptor, Application> applicationArchiveDeployer, ObservableList<Domain> domains, ObservableList<Application> applications, Supplier<SchedulerService> schedulerServiceSupplier, ReentrantLock deploymentLock) {
        this(additionalDeploymentProperties, domainBundleDeployer, domainArchiveDeployer, applicationArchiveDeployer, domains, applications, schedulerServiceSupplier, deploymentLock, true);
    }

    public DeploymentDirectoryWatcher(Optional<Properties> additionalDeploymentProperties, DomainBundleArchiveDeployer domainBundleDeployer, ArchiveDeployer<DomainDescriptor, Domain> domainArchiveDeployer, ArchiveDeployer<ApplicationDescriptor, Application> applicationArchiveDeployer, ObservableList<Domain> domains, ObservableList<Application> applications, Supplier<SchedulerService> schedulerServiceSupplier, ReentrantLock deploymentLock, boolean disposeArtifactsOnStop) {
        this.additionalDeploymentProperties = additionalDeploymentProperties;
        this.disposeArtifactsOnStop = disposeArtifactsOnStop;
        this.domainBundleDeployer = domainBundleDeployer;
        this.appsDir = applicationArchiveDeployer.getDeploymentDirectoryPath();
        this.domainsDir = domainArchiveDeployer.getDeploymentDirectoryPath();
        this.deploymentLock = deploymentLock;
        this.domainArchiveDeployer = domainArchiveDeployer;
        this.applicationArchiveDeployer = applicationArchiveDeployer;
        this.applications = applications;
        this.domains = domains;
        applications.addPropertyChangeListener(e -> {
            if (e instanceof ElementAddedEvent || e instanceof ElementRemovedEvent) {
                logger.debug("Deployed applications set has been modified, flushing state.");
                this.dirty = true;
            }
        });
        domains.addPropertyChangeListener(e -> {
            if (e instanceof ElementAddedEvent || e instanceof ElementRemovedEvent) {
                logger.debug("Deployed applications set has been modified, flushing state.");
                this.dirty = true;
            }
        });
        this.schedulerServiceSupplier = schedulerServiceSupplier;
        this.applicationTimestampListener = new ArtifactTimestampListener<Application>(applications);
        this.domainTimestampListener = new ArtifactTimestampListener<Domain>(domains);
    }

    public void start() {
        this.deploymentLock.lock();
        this.deleteAllAnchors();
        try {
            this.trigger();
            if (System.getProperty("mule.deploy.applications") == null) {
                this.scheduleChangeMonitor();
            }
        }
        finally {
            if (this.deploymentLock.isHeldByCurrentThread()) {
                this.deploymentLock.unlock();
            }
        }
    }

    void trigger() {
        String appString = System.getProperty("mule.deploy.applications");
        if (appString == null) {
            this.run();
        } else {
            this.runForFixedSet(appString);
        }
    }

    public void stop() {
        this.stop(this.disposeArtifactsOnStop);
    }

    public void stop(boolean disposeArtifacts) {
        this.stopAppDirMonitorTimer();
        if (disposeArtifacts) {
            this.deploymentLock.lock();
            try {
                this.setDoNotPersistStopStatusOfArtifacts();
                this.stopArtifacts(this.applications);
                this.stopArtifacts(this.domains);
            }
            finally {
                this.deploymentLock.unlock();
            }
        }
    }

    private void stopArtifacts(List<? extends DeployableArtifact> artifacts) {
        Collections.reverse(artifacts);
        for (DeployableArtifact deployableArtifact : artifacts) {
            try {
                deployableArtifact.stop();
                deployableArtifact.dispose();
            }
            catch (Throwable t) {
                logger.error("Error stopping artifact {}", (Object)deployableArtifact.getArtifactName(), (Object)t);
            }
        }
    }

    static int getChangesCheckIntervalMs() {
        try {
            String value = System.getProperty(CHANGE_CHECK_INTERVAL_PROPERTY);
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return 5000;
        }
    }

    private void scheduleChangeMonitor() {
        int reloadIntervalMs = DeploymentDirectoryWatcher.getChangesCheckIntervalMs();
        SchedulerConfig schedulerConfig = SchedulerConfig.config().withName("Mule.app.deployer.monitor").withPriority(1).withMaxConcurrentTasks(1);
        this.artifactDirMonitorScheduler = this.schedulerServiceSupplier.get().customScheduler(schedulerConfig);
        this.artifactDirMonitorScheduler.scheduleWithFixedDelay((Runnable)this, (long)reloadIntervalMs, (long)reloadIntervalMs, TimeUnit.MILLISECONDS);
        SPLASH_LOGGER.info(SplashScreen.miniSplash((String)String.format("Mule is up and kicking (every %dms)", reloadIntervalMs)));
    }

    protected void deployPackedApps(Collection<Path> zips) {
        for (Path zip : zips) {
            try {
                String artifactName = Strings.CI.removeEnd(zip.getFileName().toString(), (CharSequence)".jar");
                this.applicationArchiveDeployer.deployPackagedArtifact(zip, this.mergeDeploymentProperties(artifactName));
            }
            catch (Exception exception) {}
        }
    }

    protected void deployExplodedApps(List<Path> apps) {
        apps.forEach(addedApp -> {
            try {
                String appName = addedApp.getFileName().toString();
                if (this.applicationArchiveDeployer.isUpdatedZombieArtifact(appName)) {
                    this.applicationArchiveDeployer.deployExplodedArtifact((Path)addedApp, this.mergeDeploymentProperties(appName));
                }
            }
            catch (DeploymentException deploymentException) {
                // empty catch block
            }
        });
    }

    private Optional<Properties> mergeDeploymentProperties(String artifactName) {
        Optional deploymentProperties = DeploymentPropertiesUtils.getPersistedDeploymentProperties((String)artifactName);
        if (deploymentProperties.isEmpty()) {
            return this.additionalDeploymentProperties;
        }
        return deploymentProperties.map(p -> {
            this.additionalDeploymentProperties.ifPresent(p::putAll);
            return p;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            logger.debug("Checking for changes...");
            if (!this.deploymentLock.tryLock(0L, TimeUnit.SECONDS)) {
                logger.debug("Another deployment operation in progress, will skip this cycle. Owner thread: {}", (Object)((DebuggableReentrantLock)this.deploymentLock).getOwner());
                return;
            }
            this.undeployRemovedApps();
            this.undeployRemovedDomains();
            this.deployDomainBundles();
            List<Path> domainFiles = DeploymentUtils.listFiles(this.domainsDir, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));
            List<Path> domainJars = DeploymentUtils.listFiles(this.domainsDir, IS_JAR_FILE);
            this.redeployModifiedDomains();
            this.deployPackedDomains(domainJars);
            if (!domainJars.isEmpty() || this.dirty) {
                domainFiles = DeploymentUtils.listFiles(this.domainsDir, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));
            }
            DeploymentUtils.deployExplodedDomains(this.domainArchiveDeployer, domainFiles, this.additionalDeploymentProperties);
            this.redeployModifiedApplications();
            List<Path> apps = DeploymentUtils.listFiles(this.appsDir, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));
            List<Path> appJars = DeploymentUtils.listFiles(this.appsDir, IS_JAR_FILE);
            this.deployPackedApps(appJars);
            if (!appJars.isEmpty() || this.dirty) {
                apps = DeploymentUtils.listFiles(this.appsDir, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));
            }
            this.deployExplodedApps(apps.stream().sorted().toList());
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            } else {
                logger.error("Exception processing deployment watch dir.", (Throwable)e);
            }
        }
        finally {
            if (this.deploymentLock.isHeldByCurrentThread()) {
                this.deploymentLock.unlock();
            }
            this.dirty = false;
        }
    }

    private void runForFixedSet(String appString) {
        List<Path> explodedDomains = DeploymentUtils.listFiles(this.domainsDir, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));
        List<Path> packagedDomains = DeploymentUtils.listFiles(this.domainsDir, IS_JAR_FILE);
        this.deployPackedDomains(packagedDomains);
        DeploymentUtils.deployExplodedDomains(this.domainArchiveDeployer, explodedDomains, this.additionalDeploymentProperties);
        String[] apps = appString.split(":");
        apps = this.removeDuplicateAppNames(apps);
        List<Path> packagedApps = DeploymentUtils.listFiles(this.appsDir, IS_JAR_FILE);
        HashMap<String, Path> packagedAppsMap = new HashMap<String, Path>();
        for (Path path : packagedApps) {
            packagedAppsMap.put(this.extractArtifactName(path), path);
        }
        for (String app : apps) {
            try {
                Path applicationFile = (Path)packagedAppsMap.get(app);
                if (applicationFile == null) {
                    applicationFile = this.appsDir.resolve(app + ".jar");
                }
                if (Files.exists(applicationFile, new LinkOption[0]) && Files.isRegularFile(applicationFile, new LinkOption[0])) {
                    this.applicationArchiveDeployer.deployPackagedArtifact(applicationFile, this.additionalDeploymentProperties);
                    continue;
                }
                if (!this.applicationArchiveDeployer.isUpdatedZombieArtifact(app)) continue;
                this.applicationArchiveDeployer.deployExplodedArtifact(this.appsDir.resolve(app), this.additionalDeploymentProperties);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        SPLASH_LOGGER.info(SplashScreen.miniSplash((String)"Mule is up and running in a fixed app set mode"));
    }

    public String extractArtifactName(Path path) {
        String fileName = path.getFileName().toString();
        String artifactName = Strings.CI.removeEnd(fileName, (CharSequence)".jar");
        artifactName = VERSION_CLASSIFIER_PATTERN.matcher(artifactName).replaceFirst("");
        return artifactName;
    }

    private void deployDomainBundles() {
        List<Path> domainBundles = DeploymentUtils.listFiles(this.domainsDir, IS_ZIP_FILE);
        domainBundles.forEach(domainBundle -> {
            try {
                this.domainBundleDeployer.deployArtifact(domainBundle.toFile().toURI());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public <D extends DeployableArtifactDescriptor, T extends Artifact<D>> T findArtifact(String artifactName, ObservableList<T> artifacts) {
        return (T)((Artifact)artifacts.stream().filter(artifact -> artifact.getArtifactName().equals(artifactName)).findFirst().orElse(null));
    }

    private void undeployRemovedDomains() {
        this.undeployRemovedArtifacts(this.domainsDir, this.domains, this.domainArchiveDeployer);
    }

    private void undeployRemovedApps() {
        this.undeployRemovedArtifacts(this.appsDir, this.applications, this.applicationArchiveDeployer);
    }

    private <D extends DeployableArtifactDescriptor> void undeployRemovedArtifacts(Path artifactDir, ObservableList<? extends Artifact<D>> artifacts, ArchiveDeployer<D, ? extends Artifact<D>> archiveDeployer) {
        List<String> currentAnchors = DeploymentUtils.listFiles(artifactDir, IS_ANCHOR_FILE).stream().map(a -> a.getFileName().toString()).toList();
        logger.debug("Current anchors: {}", currentAnchors);
        HashSet<String> currentAnchorsSet = new HashSet<String>(currentAnchors);
        List deletedAnchors = Arrays.stream(this.findExpectedAnchorFiles(artifacts)).filter(a -> !currentAnchorsSet.contains(a)).collect(Collectors.toList());
        logger.debug("Deleted anchors: {}", deletedAnchors);
        for (String deletedAnchor : deletedAnchors) {
            String artifactName = Strings.CS.removeEnd(deletedAnchor, (CharSequence)ARTIFACT_ANCHOR_SUFFIX);
            try {
                if (this.findArtifact(artifactName, artifacts) != null) {
                    archiveDeployer.undeployArtifact(artifactName);
                    continue;
                }
                logger.debug("Artifact [{}] has already been undeployed via API", (Object)artifactName);
            }
            catch (Throwable t) {
                logger.error("Failed to undeployArtifact artifact: " + artifactName, t);
            }
        }
    }

    private <D extends DeployableArtifactDescriptor> String[] findExpectedAnchorFiles(List<? extends Artifact<D>> artifacts) {
        String[] anchors = new String[artifacts.size()];
        int i = 0;
        for (Artifact<D> artifact : artifacts) {
            anchors[i++] = artifact.getArtifactName() + ARTIFACT_ANCHOR_SUFFIX;
        }
        return anchors;
    }

    private void deployPackedDomains(List<Path> domainJars) {
        domainJars.forEach(domainJar -> {
            try {
                this.domainArchiveDeployer.deployPackagedArtifact((Path)domainJar, this.additionalDeploymentProperties);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private void deleteAllAnchors() {
        this.deleteAnchorsFromDirectory(this.domainsDir);
        this.deleteAnchorsFromDirectory(this.appsDir);
    }

    private void deleteAnchorsFromDirectory(Path directory) {
        DeploymentUtils.listFiles(directory, IS_ANCHOR_FILE).forEach(anchor -> {
            try {
                Files.delete(anchor);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    private String[] removeDuplicateAppNames(String[] apps) {
        LinkedList<String> appNames = new LinkedList<String>();
        for (String appName : apps) {
            if (appNames.contains(appName)) continue;
            appNames.add(appName);
        }
        return appNames.toArray(new String[appNames.size()]);
    }

    private void redeployModifiedDomains() {
        Collection<String> redeployableDomains = this.getArtifactsToRedeploy(this.domains, this.domainTimestampListener);
        this.redeployModifiedArtifacts(redeployableDomains, this.domainArchiveDeployer);
    }

    private void redeployModifiedApplications() {
        Collection<String> redeployableApplications = this.getArtifactsToRedeploy(this.applications, this.applicationTimestampListener);
        this.redeployModifiedArtifacts(redeployableApplications, this.applicationArchiveDeployer);
    }

    private <D extends DeployableArtifactDescriptor, T extends DeployableArtifact<D>> Collection<String> getArtifactsToRedeploy(Collection<T> collection, ArtifactTimestampListener<T> artifactTimestampListener) {
        return collection.stream().filter(artifact -> artifact.getDescriptor().isRedeploymentEnabled()).filter(artifactTimestampListener::isArtifactResourceUpdated).map(Artifact::getArtifactName).toList();
    }

    private <D extends DeployableArtifactDescriptor, T extends Artifact<D>> void redeployModifiedArtifacts(Collection<String> artifactNames, ArchiveDeployer<D, T> artifactArchiveDeployer) {
        for (String artifactName : artifactNames) {
            try {
                artifactArchiveDeployer.redeploy(artifactName, this.additionalDeploymentProperties);
            }
            catch (DeploymentException e) {
                logger.debug("Error redeploying artifact {}", (Object)artifactName, (Object)e);
            }
        }
    }

    private void stopAppDirMonitorTimer() {
        if (this.artifactDirMonitorScheduler != null) {
            this.artifactDirMonitorScheduler.shutdown();
            try {
                this.artifactDirMonitorScheduler.awaitTermination((long)DeploymentDirectoryWatcher.getChangesCheckIntervalMs(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void setDoNotPersistStopStatusOfArtifacts() {
        for (Application application : this.applications) {
            this.applicationArchiveDeployer.doNotPersistArtifactStop(application);
        }
        for (Domain domain : this.domains) {
            this.domainArchiveDeployer.doNotPersistArtifactStop(domain);
        }
    }

    private static class ArtifactTimestampListener<T extends Artifact>
    implements PropertyChangeListener {
        private final Map<String, ArtifactResourcesTimestamp<T>> artifactConfigResourcesTimestaps = new HashMap<String, ArtifactResourcesTimestamp<T>>();

        public ArtifactTimestampListener(ObservableList<T> artifacts) {
            artifacts.addPropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (event instanceof ElementAddedEvent) {
                Artifact artifactAdded = (Artifact)event.getNewValue();
                this.artifactConfigResourcesTimestaps.put(artifactAdded.getArtifactName(), new ArtifactResourcesTimestamp(artifactAdded));
            } else if (event instanceof ElementRemovedEvent) {
                Artifact artifactRemoved = (Artifact)event.getNewValue();
                this.artifactConfigResourcesTimestaps.remove(artifactRemoved.getArtifactName());
            }
        }

        public boolean isArtifactResourceUpdated(T artifact) {
            ArtifactResourcesTimestamp<T> applicationResourcesTimestamp = this.artifactConfigResourcesTimestaps.get(artifact.getArtifactName());
            return !applicationResourcesTimestamp.resourcesHaveSameTimestamp();
        }
    }

    private static class ArtifactResourcesTimestamp<T extends Artifact> {
        private final Map<String, Long> timestampsPerResource = new HashMap<String, Long>();

        public ArtifactResourcesTimestamp(Artifact artifact) {
            for (File configResourceFile : artifact.getResourceFiles()) {
                this.timestampsPerResource.put(configResourceFile.getAbsolutePath(), configResourceFile.lastModified());
            }
            File descriptorFile = new File(((DeployableArtifactDescriptor)artifact.getDescriptor()).getArtifactLocation(), ArtifactDescriptor.MULE_ARTIFACT_JSON_DESCRIPTOR_LOCATION);
            if (descriptorFile.exists()) {
                this.timestampsPerResource.put(descriptorFile.getAbsolutePath(), descriptorFile.lastModified());
            }
        }

        public boolean resourcesHaveSameTimestamp() {
            return this.timestampsPerResource.entrySet().stream().noneMatch(entry -> {
                long currentTimestamp;
                File trackedFile = new File((String)entry.getKey());
                long originalTimestamp = (Long)entry.getValue();
                if (originalTimestamp != (currentTimestamp = trackedFile.lastModified())) {
                    this.timestampsPerResource.put((String)entry.getKey(), currentTimestamp);
                    return true;
                }
                return false;
            });
        }
    }
}

