/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.connection;

import jakarta.inject.Inject;
import java.util.Optional;
import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.connection.PoolingConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.connection.ConnectionManagementType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.internal.connection.ConnectionProviderWrapper;
import org.mule.runtime.core.internal.connection.ConnectionUtils;
import org.mule.runtime.core.internal.connection.adapter.XATransactionalConnectionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnectionProviderWrapper<C>
implements ConnectionProviderWrapper<C> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractConnectionProviderWrapper.class);
    private final ConnectionProvider<C> delegate;
    private Object delegateForInjection;
    @Inject
    protected MuleContext muleContext;

    public AbstractConnectionProviderWrapper(ConnectionProvider<C> delegate) {
        this.delegate = delegate;
    }

    public C connect() throws ConnectionException {
        return ConnectionUtils.connect(this.delegate);
    }

    public ConnectionValidationResult validate(C connection) {
        return this.delegate.validate(connection);
    }

    public void disconnect(C connection) {
        this.delegate.disconnect(connection);
    }

    @Override
    public ConnectionProvider<C> getDelegate() {
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getDelegateForInjection() {
        if (this.delegateForInjection == null) {
            AbstractConnectionProviderWrapper abstractConnectionProviderWrapper = this;
            synchronized (abstractConnectionProviderWrapper) {
                if (this.delegateForInjection == null) {
                    this.delegateForInjection = ConnectionUtils.getInjectionTarget(this.delegate);
                }
            }
        }
        return this.delegateForInjection;
    }

    @Override
    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return ConnectionUtils.getRetryPolicyTemplate(this.getReconnectionConfig());
    }

    @Override
    public ConnectionManagementType getConnectionManagementType() {
        if (this.delegate instanceof ConnectionProviderWrapper) {
            return ((ConnectionProviderWrapper)this.delegate).getConnectionManagementType();
        }
        ConnectionManagementType type = ConnectionManagementType.NONE;
        if (this.delegate instanceof PoolingConnectionProvider) {
            type = ConnectionManagementType.POOLING;
        } else if (this.delegate instanceof CachedConnectionProvider) {
            type = ConnectionManagementType.CACHED;
        }
        return type;
    }

    @Override
    public boolean supportsXa() {
        if (this.delegate instanceof ConnectionProviderWrapper) {
            return ((ConnectionProviderWrapper)this.delegate).supportsXa();
        }
        return this.delegate instanceof XATransactionalConnectionProvider;
    }

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.delegate, true, this.muleContext);
        LifecycleUtils.initialiseIfNeeded(this.getRetryPolicyTemplate(), true, this.muleContext);
    }

    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.delegate);
        LifecycleUtils.startIfNeeded(this.getRetryPolicyTemplate());
    }

    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.delegate);
        LifecycleUtils.stopIfNeeded(this.getRetryPolicyTemplate());
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.delegate, LOGGER);
        LifecycleUtils.disposeIfNeeded(this.getRetryPolicyTemplate(), LOGGER);
    }

    public Optional<PoolingProfile> getPoolingProfile() {
        ConnectionProvider<C> delegate = this.getDelegate();
        return delegate instanceof ConnectionProviderWrapper ? ((ConnectionProviderWrapper)delegate).getPoolingProfile() : Optional.empty();
    }
}

