/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.internal.processor.strategy.AbstractProcessingStrategy;
import org.mule.runtime.core.internal.processor.strategy.AbstractProcessingStrategyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.util.concurrent.Queues;

public abstract class AbstractStreamProcessingStrategyFactory
extends AbstractProcessingStrategyFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractStreamProcessingStrategyFactory.class);
    protected static final String SYSTEM_PROPERTY_PREFIX = AbstractStreamProcessingStrategyFactory.class.getName() + ".";
    protected static final int CORES = Integer.getInteger(SYSTEM_PROPERTY_PREFIX + "AVAILABLE_CORES", Runtime.getRuntime().availableProcessors());
    protected static final int DEFAULT_BUFFER_SIZE = Integer.getInteger(SYSTEM_PROPERTY_PREFIX + "DEFAULT_BUFFER_SIZE", 1024);
    protected static final int FLOW_DISPATCH_WORKERS = Integer.getInteger(SYSTEM_PROPERTY_PREFIX + "FLOW_DISPATCH_WORKERS", 0);
    protected static final int DEFAULT_SUBSCRIBER_COUNT = Integer.getInteger(SYSTEM_PROPERTY_PREFIX + "DEFAULT_SUBSCRIBER_COUNT", Integer.max(1, CORES / 2));
    private int bufferSize = DEFAULT_BUFFER_SIZE;
    private int subscriberCount = DEFAULT_SUBSCRIBER_COUNT;

    public void setBufferSize(int bufferSize) {
        if (!Queues.isPowerOfTwo((int)bufferSize)) {
            throw new IllegalArgumentException("bufferSize must be a power of 2 : " + bufferSize);
        }
        this.bufferSize = bufferSize;
    }

    public void setSubscriberCount(int subscriberCount) {
        this.subscriberCount = subscriberCount;
    }

    protected int getBufferSize() {
        return this.bufferSize;
    }

    protected int getSubscriberCount() {
        return this.subscriberCount;
    }

    @Override
    public Class<? extends ProcessingStrategy> getProcessingStrategyType() {
        return AbstractStreamProcessingStrategy.class;
    }

    protected Supplier<Scheduler> getCpuLightSchedulerSupplier(SchedulerService schedulerService, Supplier<SchedulerConfig> schedulerBaseConfig, String schedulersNamePrefix) {
        return () -> schedulerService.cpuLightScheduler(((SchedulerConfig)schedulerBaseConfig.get()).withName(schedulersNamePrefix + "." + ReactiveProcessor.ProcessingType.CPU_LITE.name()));
    }

    protected int resolveParallelism() {
        return Math.min(CORES, this.getMaxConcurrency());
    }

    static abstract class AbstractStreamProcessingStrategy
    extends AbstractProcessingStrategy {
        protected final int subscribers;
        protected final int maxConcurrency;
        protected final boolean maxConcurrencyEagerCheck;
        protected final ClassLoader executionClassloader;
        private final Supplier<Thread> threadSupplier;

        protected AbstractStreamProcessingStrategy(int subscribers, int maxConcurrency, boolean maxConcurrencyEagerCheck, Supplier<Thread> threadSupplier) {
            this.subscribers = Objects.requireNonNull(subscribers);
            this.maxConcurrency = Objects.requireNonNull(maxConcurrency);
            this.maxConcurrencyEagerCheck = maxConcurrency < Integer.MAX_VALUE && maxConcurrencyEagerCheck;
            this.executionClassloader = threadSupplier.get().getContextClassLoader();
            this.threadSupplier = threadSupplier;
        }

        protected void awaitSubscribersCompletion(FlowConstruct flowConstruct, long shutdownTimeout, CountDownLatch completionLatch, long startMillis) {
            try {
                if (!completionLatch.await(Long.max(startMillis - System.currentTimeMillis() + shutdownTimeout, 0L), TimeUnit.MILLISECONDS)) {
                    if (System.getProperty("mule.lifecycle.failOnFirstDisposeError") != null) {
                        throw new IllegalStateException(String.format("Subscribers of ProcessingStrategy for flow '%s' not completed in %d ms", flowConstruct.getName(), shutdownTimeout));
                    }
                    LOGGER.warn("Subscribers of ProcessingStrategy for flow '{}' not completed in {} ms", (Object)flowConstruct.getName(), (Object)shutdownTimeout);
                }
            }
            catch (InterruptedException e) {
                this.threadSupplier.get().interrupt();
                if (System.getProperty("mule.lifecycle.failOnFirstDisposeError") != null) {
                    throw new IllegalStateException(String.format("Subscribers of ProcessingStrategy for flow '%s' not completed before thread interruption", flowConstruct.getName()));
                }
                LOGGER.warn("Subscribers of ProcessingStrategy for flow '{}' not completed before thread interruption", (Object)flowConstruct.getName());
            }
        }
    }
}

