/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.store;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.cluster.ClusterService;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.api.store.ObjectStoreSettings;
import org.mule.runtime.api.store.PartitionableExpirableObjectStore;
import org.mule.runtime.api.store.PartitionableObjectStore;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.store.AbstractPartitionableObjectStore;
import org.mule.runtime.core.internal.util.store.MonitoredObjectStoreWrapper;
import org.mule.runtime.core.internal.util.store.ObjectStorePartition;
import org.mule.runtime.core.internal.util.store.PartitionedObjectStoreWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleObjectStoreManager
implements ObjectStoreManager,
Initialisable,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleObjectStoreManager.class);
    public static final int UNBOUNDED = 0;
    private ClusterService clusterService;
    private Provider<SchedulerConfig> schedulerConfig;
    private SchedulerService schedulerService;
    private Registry registry;
    private final ConcurrentMap<String, ObjectStore<?>> stores = new ConcurrentHashMap();
    private final ConcurrentMap<String, Scheduler> expirationSchedulers = new ConcurrentHashMap<String, Scheduler>();
    private String baseTransientStoreKey = "_defaultInMemoryObjectStore";
    private String basePersistentStoreKey = "_defaultPersistentObjectStore";
    private ObjectStore<?> baseTransientStore;
    private ObjectStore<?> basePersistentStore;
    private ObjectStore<?> baseTransientPartition;
    private ObjectStore<?> basePersistentPartition;

    public void initialise() throws InitialisationException {
        this.basePersistentStore = this.lookupBaseStore(this.basePersistentStoreKey, "Persistent");
        this.baseTransientStore = this.lookupBaseStore(this.baseTransientStoreKey, "Transient");
        try {
            this.baseTransientPartition = this.getPartitionFromBaseObjectStore(this.baseTransientStore, this.baseTransientStoreKey);
            this.basePersistentPartition = this.getPartitionFromBaseObjectStore(this.basePersistentStore, this.basePersistentStoreKey);
        }
        catch (ObjectStoreException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    private ObjectStore<?> lookupBaseStore(String key, String baseType) throws InitialisationException {
        return (ObjectStore)this.registry.lookupByName(key).orElseThrow(() -> new InitialisationException(I18nMessageFactory.createStaticMessage((String)String.format("%s base store of key '%s' does not exists", baseType, key)), (Initialisable)this));
    }

    public void dispose() {
        LOGGER.debug("Disposing MuleObjectStoreManager: {}", (Object)this);
        for (Scheduler scheduler : this.expirationSchedulers.values()) {
            scheduler.stop();
        }
        this.expirationSchedulers.clear();
        this.basePersistentPartition = null;
        this.baseTransientPartition = null;
        this.basePersistentStore = null;
        this.baseTransientStore = null;
        this.stores.values().forEach(store -> LifecycleUtils.disposeIfNeeded(store, LOGGER));
        this.stores.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ObjectStore<? extends Serializable>> T getObjectStore(String name) {
        ObjectStore store;
        if (this.basePersistentStoreKey.equals(name)) {
            return (T)this.basePersistentPartition;
        }
        if (this.baseTransientStoreKey.equals(name)) {
            return (T)this.baseTransientPartition;
        }
        ConcurrentMap<String, ObjectStore<?>> concurrentMap = this.stores;
        synchronized (concurrentMap) {
            store = (ObjectStore)this.stores.get(name);
        }
        if (store == null) {
            throw this.noSuchStoreException(name);
        }
        return (T)store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ObjectStore<? extends Serializable>> T createObjectStore(String name, ObjectStoreSettings settings) {
        ConcurrentMap<String, ObjectStore<?>> concurrentMap = this.stores;
        synchronized (concurrentMap) {
            if (this.baseTransientStoreKey.equals(name) || this.basePersistentStoreKey.equals(name) || this.stores.containsKey(name)) {
                throw new IllegalArgumentException("An Object Store was already defined for name " + name);
            }
            LOGGER.debug("Creating OS '{}' in MuleObjectStoreManager: {}", (Object)name, (Object)this);
            T store = this.doCreateObjectStore(name, settings);
            this.stores.put(name, (ObjectStore<?>)store);
            return store;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ObjectStore<? extends Serializable>> T getOrCreateObjectStore(String name, ObjectStoreSettings settings) {
        T objectStore;
        ConcurrentMap<String, ObjectStore<?>> concurrentMap = this.stores;
        synchronized (concurrentMap) {
            try {
                objectStore = this.getObjectStore(name);
            }
            catch (NoSuchElementException e) {
                objectStore = this.createObjectStore(name, settings);
            }
        }
        return objectStore;
    }

    private <T extends ObjectStore<?>> T doCreateObjectStore(String name, ObjectStoreSettings settings) {
        T store;
        T baseStore = this.getBaseStore(settings);
        try {
            store = this.getPartitionFromBaseObjectStore((ObjectStore<? extends Serializable>)baseStore, name);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Found exception trying to create Object Store of name " + name)), (Throwable)e);
        }
        if (settings.getExpirationInterval() > 0L && (settings.getMaxEntries().isPresent() || settings.getEntryTTL().isPresent())) {
            store = this.getMonitorablePartition(name, (ObjectStore)baseStore, store, settings);
        }
        return store;
    }

    private <T extends ObjectStore<? extends Serializable>> T getBaseStore(ObjectStoreSettings settings) {
        return (T)(settings.isPersistent() ? Objects.requireNonNull(this.basePersistentStore, "basePersistentStore is null") : Objects.requireNonNull(this.baseTransientStore, "baseTransientStore is null"));
    }

    private <T extends ObjectStore<? extends Serializable>> T getPartitionFromBaseObjectStore(ObjectStore<? extends Serializable> baseStore, String partitionName) throws ObjectStoreException {
        if (baseStore instanceof PartitionableObjectStore) {
            PartitionableObjectStore pos = (PartitionableObjectStore)baseStore;
            ObjectStorePartition objectStorePartition = new ObjectStorePartition(partitionName, pos);
            objectStorePartition.open();
            return (T)((Object)objectStorePartition);
        }
        PartitionedObjectStoreWrapper<? extends Serializable> partitionedObjectStoreWrapper = new PartitionedObjectStoreWrapper<Serializable>(partitionName, baseStore);
        partitionedObjectStoreWrapper.open();
        return (T)((Object)partitionedObjectStoreWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends ObjectStore<? extends Serializable>> T getMonitorablePartition(String name, ObjectStore baseStore, T store, ObjectStoreSettings settings) {
        MonitoredObjectStoreWrapper monObjectStore;
        if (baseStore instanceof PartitionableExpirableObjectStore) {
            PartitionableExpirableObjectStore peos = (PartitionableExpirableObjectStore)baseStore;
            Scheduler scheduler = this.schedulerService.customScheduler(((SchedulerConfig)this.schedulerConfig.get()).withName("ObjectStoreManager-Monitor-" + name).withMaxConcurrentTasks(1));
            scheduler.scheduleWithFixedDelay((Runnable)new Monitor(name, (PartitionableExpirableObjectStore<? extends Serializable>)peos, settings.getEntryTTL().orElse(0L), settings.getMaxEntries().orElse(0)), 0L, settings.getExpirationInterval(), TimeUnit.MILLISECONDS);
            this.expirationSchedulers.put(name, scheduler);
            return store;
        }
        MuleObjectStoreManager muleObjectStoreManager = this;
        synchronized (muleObjectStoreManager) {
            monObjectStore = new MonitoredObjectStoreWrapper(store, settings);
            monObjectStore.setClusterService(this.clusterService);
            monObjectStore.setSchedulerService(this.schedulerService);
            monObjectStore.setSchedulerConfig(this.schedulerConfig);
            try {
                monObjectStore.initialise();
            }
            catch (InitialisationException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
        return (T)monObjectStore;
    }

    public void clearStoreCache() {
        this.stores.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeStore(String name) throws ObjectStoreException {
        if (this.basePersistentStoreKey.equals(name) || this.baseTransientStoreKey.equals(name)) {
            return;
        }
        LOGGER.debug("Disposing OS '{}' from MuleObjectStoreManager: {}", (Object)name, (Object)this);
        ObjectStore store = (ObjectStore)this.stores.remove(name);
        if (store == null) {
            throw this.noSuchStoreException(name);
        }
        try {
            if (store instanceof ObjectStorePartition) {
                ObjectStorePartition partition = (ObjectStorePartition)store;
                String partitionName = partition.getPartitionName();
                partition.getBaseStore().disposePartition(partitionName);
                Scheduler scheduler = (Scheduler)this.expirationSchedulers.remove(partitionName);
                if (scheduler != null) {
                    scheduler.stop();
                }
            } else {
                try {
                    store.clear();
                }
                catch (UnsupportedOperationException e) {
                    LOGGER.warn(String.format("ObjectStore of class %s does not support clearing", store.getClass().getCanonicalName()), (Throwable)e);
                }
            }
        }
        finally {
            LifecycleUtils.disposeIfNeeded(store, LOGGER);
        }
    }

    private NoSuchElementException noSuchStoreException(String name) {
        return new NoSuchElementException("ObjectStore '" + name + "' is not defined");
    }

    int getMonitorsCount() {
        return this.expirationSchedulers.size();
    }

    public void setBasePersistentStoreKey(String basePersistentStoreKey) {
        this.basePersistentStoreKey = basePersistentStoreKey;
    }

    public void setBaseTransientStoreKey(String baseTransientStoreKey) {
        this.baseTransientStoreKey = baseTransientStoreKey;
    }

    @Inject
    public void setClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    @Inject
    public void setSchedulerConfig(Provider<SchedulerConfig> schedulerConfig) {
        this.schedulerConfig = schedulerConfig;
    }

    @Inject
    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    @Inject
    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    class Monitor
    implements Runnable {
        private final String partitionName;
        private final PartitionableExpirableObjectStore<? extends Serializable> store;
        private final long entryTTL;
        private final int maxEntries;

        public Monitor(String partitionName, PartitionableExpirableObjectStore<? extends Serializable> store, long entryTTL, int maxEntries) {
            this.partitionName = partitionName;
            this.store = store;
            this.entryTTL = entryTTL;
            this.maxEntries = maxEntries;
            if (this.entryTTL < 0L) {
                LOGGER.warn("Partition {} configured with negative max entries, defaulting to UNBOUNDED", (Object)partitionName);
            }
        }

        @Override
        public void run() {
            AbstractPartitionableObjectStore pos;
            boolean expireRegardlessPollingInstance;
            PartitionableExpirableObjectStore<? extends Serializable> partitionableExpirableObjectStore = this.store;
            boolean bl = expireRegardlessPollingInstance = partitionableExpirableObjectStore instanceof AbstractPartitionableObjectStore && (pos = (AbstractPartitionableObjectStore)partitionableExpirableObjectStore).shouldAlwaysExpire();
            if (expireRegardlessPollingInstance || MuleObjectStoreManager.this.clusterService.isPrimaryPollingInstance()) {
                try {
                    this.store.expire(this.entryTTL, this.maxEntries, this.partitionName);
                }
                catch (Exception e) {
                    LOGGER.warn("Running expiry on partition {} of {} threw {}:{}", new Object[]{this.partitionName, this.store, e, e.getMessage()});
                }
            }
        }
    }
}

