/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.CaseInsensitiveMultiMap;
import org.mule.runtime.http.api.domain.HttpProtocol;
import org.mule.runtime.http.api.domain.entity.FeedableHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.server.HttpServerProperties;
import org.mule.runtime.http.api.utils.HttpEncoderDecoderUtils;
import org.mule.runtime.http.api.utils.UriCache;
import org.mule.service.http.netty.impl.message.content.NettyFeedableHttpEntity;
import org.mule.service.http.netty.impl.util.NettyUtils;

public class NettyHttp2RequestAdapter
implements HttpRequest {
    private static final char PSEUDO_HEADER_PREFIX = ':';
    private final Http2HeadersFrame headersFrame;
    private final URI uri;
    private final String path;
    private final MultiMap<String, String> queryParams;
    private final LazyValue<MultiMap<String, String>> headersAsMultiMap;
    private final MultiMap<String, String> trailers = new CaseInsensitiveMultiMap(!HttpServerProperties.PRESERVE_HEADER_CASE);
    private final FeedableHttpEntity entity;

    public NettyHttp2RequestAdapter(Http2HeadersFrame headersFrame) {
        this.headersFrame = headersFrame;
        String uriString = headersFrame.headers().path().toString();
        this.uri = UriCache.getUriFromString((String)uriString);
        this.path = this.uri.getPath();
        this.queryParams = HttpEncoderDecoderUtils.decodeQueryString((String)HttpEncoderDecoderUtils.extractQueryParams((String)uriString));
        this.entity = new NettyFeedableHttpEntity();
        this.headersAsMultiMap = new LazyValue(() -> NettyHttp2RequestAdapter.headersToMultiMap(headersFrame.headers()));
    }

    public HttpProtocol getProtocol() {
        return HttpProtocol.HTTP_2;
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.headersFrame.headers().method().toString();
    }

    public URI getUri() {
        return this.uri;
    }

    public MultiMap<String, String> getQueryParams() {
        return this.queryParams;
    }

    public HttpEntity getEntity() {
        return this.entity;
    }

    public Collection<String> getHeaderNames() {
        return ((MultiMap)this.headersAsMultiMap.get()).keySet();
    }

    public boolean containsHeader(String headerName) {
        return this.headersFrame.headers().contains((Object)headerName);
    }

    public String getHeaderValue(String headerName) {
        return this.getHeaderValueIgnoreCase(headerName);
    }

    public String getHeaderValueIgnoreCase(String headerName) {
        if (this.headersAsMultiMap.isComputed()) {
            return (String)((MultiMap)this.headersAsMultiMap.get()).get((Object)headerName);
        }
        CharSequence asCharSequence = (CharSequence)this.headersFrame.headers().get((Object)headerName);
        return asCharSequence == null ? null : asCharSequence.toString();
    }

    public Collection<String> getHeaderValues(String headerName) {
        return this.getHeaderValuesIgnoreCase(headerName);
    }

    public Collection<String> getHeaderValuesIgnoreCase(String headerName) {
        if (this.headersAsMultiMap.isComputed()) {
            return ((MultiMap)this.headersAsMultiMap.get()).getAll((Object)headerName);
        }
        List values = this.headersFrame.headers().getAll((Object)headerName);
        LinkedList<String> asStrings = new LinkedList<String>();
        for (CharSequence value : values) {
            asStrings.add(value.toString());
        }
        return asStrings;
    }

    public MultiMap<String, String> getHeaders() {
        return (MultiMap)this.headersAsMultiMap.get();
    }

    private static MultiMap<String, String> headersToMultiMap(Http2Headers nettyHeaders) {
        CaseInsensitiveMultiMap asMultiMap = new CaseInsensitiveMultiMap(!HttpServerProperties.PRESERVE_HEADER_CASE);
        for (Map.Entry entry : nettyHeaders) {
            CharSequence headerName = (CharSequence)entry.getKey();
            if (headerName.charAt(0) == ':') continue;
            CharSequence headerValue = (CharSequence)entry.getValue();
            asMultiMap.put((Object)headerName.toString(), (Object)headerValue.toString());
        }
        return asMultiMap;
    }

    public void finishEntityAndSetTrailers() throws IOException {
        this.entity.completeWithTrailers(this.trailers);
    }

    public void pushContent(ByteBuf content) throws IOException {
        this.entity.feed(NettyUtils.toNioBuffer(content));
    }

    public void addTrailer(String name, String value) {
        this.trailers.put((Object)name, (Object)value);
    }
}

