/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.persistence.type.adapter;

import com.google.gson.Gson;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Optional;

final class OptionalTypeAdapter<T>
extends TypeAdapter<Optional<T>> {
    private final Gson gson;
    private final Type innerType;

    OptionalTypeAdapter(Gson gson, Type innerType) {
        this.gson = gson;
        this.innerType = innerType;
    }

    public void write(JsonWriter out, Optional<T> value) throws IOException {
        if (value != null && value.isPresent()) {
            TypeAdapter adapter = this.gson.getAdapter(TypeToken.get((Type)this.innerType));
            adapter.write(out, value.get());
        } else {
            out.nullValue();
        }
    }

    public Optional<T> read(JsonReader in) throws IOException {
        TypeAdapter adapter = this.gson.getAdapter(TypeToken.get((Type)this.innerType));
        Object t = adapter.fromJson(JsonParser.parseReader((JsonReader)in).toString());
        return Optional.ofNullable(t);
    }
}

