/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.mule.weave.v2.module.writer.FlushBufferCapable;
import org.mule.weave.v2.module.writer.FlushBufferedOutputStream;
import org.mule.weave.v2.module.writer.FlushBufferedOutputStream$;
import org.mule.weave.v2.module.writer.SStreamEncoder;
import org.mule.weave.v2.module.writer.SStreamEncoder$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\tUa\u0001\u0002\u0013&\u0001IB\u0001b\u0010\u0001\u0003\u0006\u0004%\t\u0001\u0011\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005g!A!\t\u0001BC\u0002\u0013\u00051\t\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003E\u0011!a\u0005A!b\u0001\n\u0003i\u0005\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\t\u000bU\u0003A\u0011\u0001,\t\u000fm\u0003\u0001\u0019!C\u0005\u0001\"9A\f\u0001a\u0001\n\u0013i\u0006BB2\u0001A\u0003&1\u0007C\u0004e\u0001\u0001\u0007I\u0011B3\t\u000f%\u0004\u0001\u0019!C\u0005U\"1A\u000e\u0001Q!\n\u0019Dq!\u001c\u0001C\u0002\u0013%a\u000e\u0003\u0004v\u0001\u0001\u0006Ia\u001c\u0005\bm\u0002\u0001\r\u0011\"\u0003N\u0011\u001d9\b\u00011A\u0005\naDaA\u001f\u0001!B\u0013q\u0005bB>\u0001\u0005\u0004%I\u0001 \u0005\b\u0003#\u0001\u0001\u0015!\u0003~\u0011\u001d\t\u0019\u0002\u0001C!\u0003+Aq!a\u0005\u0001\t\u0003\n\u0019\u0003C\u0004\u00020\u0001!I!!\r\t\u000f\u0005M\u0001\u0001\"\u0011\u00024!9\u0011q\u0007\u0001\u0005\u0002\u0005E\u0002bBA>\u0001\u0011%\u0011\u0011\u0007\u0005\b\u0003{\u0002A\u0011BA\u0019\u0011\u001d\t\u0019\u0002\u0001C\u0001\u0003\u007fBq!!%\u0001\t\u0013\t\u0019\nC\u0004\u0002\u0014\u0001!\t!a)\t\u000f\u0005M\u0001\u0001\"\u0001\u0002:\"9\u00111\u0003\u0001\u0005\u0002\u0005=\u0007bBAk\u0001\u0011\u0005\u0011\u0011\u0007\u0005\b\u0003G\u0004A\u0011IA\u0019\u0011\u001d\t\t\u0010\u0001C!\u0003c\u00111bU7beR<&/\u001b;fe*\u0011aeJ\u0001\u0007oJLG/\u001a:\u000b\u0005!J\u0013AB7pIVdWM\u0003\u0002+W\u0005\u0011aO\r\u0006\u0003Y5\nQa^3bm\u0016T!AL\u0018\u0002\t5,H.\u001a\u0006\u0002a\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aM\u001e\u0011\u0005QJT\"A\u001b\u000b\u0005Y:\u0014AA5p\u0015\u0005A\u0014\u0001\u00026bm\u0006L!AO\u001b\u0003\u0019=+H\u000f];u'R\u0014X-Y7\u0011\u0005qjT\"A\u0013\n\u0005y*#A\u0005$mkND')\u001e4gKJ\u001c\u0015\r]1cY\u0016\fAb\\;uaV$8\u000b\u001e:fC6,\u0012aM\u0001\u000e_V$\b/\u001e;TiJ,\u0017-\u001c\u0011\u0002\u000f\rD\u0017M]:fiV\tA\t\u0005\u0002F\u00136\taI\u0003\u0002C\u000f*\u0011\u0001jN\u0001\u0004]&|\u0017B\u0001&G\u0005\u001d\u0019\u0005.\u0019:tKR\f\u0001b\u00195beN,G\u000fI\u0001\u0007]\u000eC\u0017M]:\u0016\u00039\u0003\"a\u0014*\u000e\u0003AS\u0011!U\u0001\u0006g\u000e\fG.Y\u0005\u0003'B\u00131!\u00138u\u0003\u001dq7\t[1sg\u0002\na\u0001P5oSRtD\u0003B,Y3j\u0003\"\u0001\u0010\u0001\t\u000b}:\u0001\u0019A\u001a\t\u000b\t;\u0001\u0019\u0001#\t\u000b1;\u0001\u0019\u0001(\u0002\u0005=\u001c\u0018AB8t?\u0012*\u0017\u000f\u0006\u0002_CB\u0011qjX\u0005\u0003AB\u0013A!\u00168ji\"9!-CA\u0001\u0002\u0004\u0019\u0014a\u0001=%c\u0005\u0019qn\u001d\u0011\u0002\u0005M,W#\u00014\u0011\u0005q:\u0017B\u00015&\u00059\u00196\u000b\u001e:fC6,enY8eKJ\faa]3`I\u0015\fHC\u00010l\u0011\u001d\u0011G\"!AA\u0002\u0019\f1a]3!\u0003\t\u0019'-F\u0001p!\ry\u0005O]\u0005\u0003cB\u0013Q!\u0011:sCf\u0004\"aT:\n\u0005Q\u0004&\u0001B\"iCJ\f1a\u00192!\u0003\u0019\tWn\\;oi\u0006Q\u0011-\\8v]R|F%Z9\u0015\u0005yK\bb\u00022\u0012\u0003\u0003\u0005\rAT\u0001\bC6|WO\u001c;!\u00035a\u0017N\\3TKB\f'/\u0019;peV\tQ\u0010E\u0002\u007f\u0003\u0017q1a`A\u0004!\r\t\t\u0001U\u0007\u0003\u0003\u0007Q1!!\u00022\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\u0002)\u0002\rA\u0013X\rZ3g\u0013\u0011\ti!a\u0004\u0003\rM#(/\u001b8h\u0015\r\tI\u0001U\u0001\u000fY&tWmU3qCJ\fGo\u001c:!\u0003\u00159(/\u001b;f)\rq\u0016q\u0003\u0005\b\u00033)\u0002\u0019AA\u000e\u0003\u0005\u0011\u0007\u0003B(q\u0003;\u00012aTA\u0010\u0013\r\t\t\u0003\u0015\u0002\u0005\u0005f$X\rF\u0004_\u0003K\t9#a\u000b\t\u000f\u0005ea\u00031\u0001\u0002\u001c!1\u0011\u0011\u0006\fA\u00029\u000b1a\u001c4g\u0011\u0019\tiC\u0006a\u0001\u001d\u0006\u0019A.\u001a8\u0002)Y\fG.\u001b3bi\u0016|U\u000f\u001e9viN#(/Z1n)\u0005qFc\u00010\u00026!1\u0011\u0011\u0004\rA\u00029\u000b1B\u001a7vg\"\u0014UO\u001a4fe\"*\u0011$a\u000f\u0002HA)q*!\u0010\u0002B%\u0019\u0011q\b)\u0003\rQD'o\\<t!\r!\u00141I\u0005\u0004\u0003\u000b*$aC%P\u000bb\u001cW\r\u001d;j_:\fdAH?\u0002J\u0005e\u0014'C\u0012\u0002L\u0005E\u0013qNA*+\ra\u0018Q\n\u0003\b\u0003\u001f\n$\u0019AA-\u0005\u0005!\u0016\u0002BA*\u0003+\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n$bAA,!\u00061A\u000f\u001b:poN\fB!a\u0017\u0002bA\u0019q*!\u0018\n\u0007\u0005}\u0003KA\u0004O_RD\u0017N\\4\u0011\t\u0005\r\u0014\u0011\u000e\b\u0004\u001f\u0006\u0015\u0014bAA4!\u00069\u0001/Y2lC\u001e,\u0017\u0002BA6\u0003[\u0012\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u0005\u001d\u0004+M\u0005$\u0003c\n\u0019(!\u001e\u0002X9\u0019q*a\u001d\n\u0007\u0005]\u0003+M\u0003#\u001fB\u000b9HA\u0003tG\u0006d\u0017-M\u0002'\u0003\u0003\n\u0001C\u001a7vg\"$V\r\u001f;Ck\u001a4WM]:\u0002+\u0011|g\t\\;tQ&sG/\u001a:oC2\u0014UO\u001a4feR\u0019a,!!\t\r\u0005\rE\u00041\u0001s\u0003\u0005\u0019\u0007&\u0002\u000f\u0002<\u0005\u001d\u0015G\u0002\u0010~\u0003\u0013\u000by)M\u0005$\u0003\u0017\n\t&a#\u0002TEJ1%!\u001d\u0002t\u00055\u0015qK\u0019\u0006E=\u0003\u0016qO\u0019\u0004M\u0005\u0005\u0013aA7j]R)a*!&\u0002\u001a\"1\u0011qS\u000fA\u00029\u000b\u0011!\u0019\u0005\u0007\u00033i\u0002\u0019\u0001()\u0007u\ti\nE\u0002P\u0003?K1!!)Q\u0005\u0019Ig\u000e\\5oKR9a,!*\u0002*\u0006-\u0006BBAT=\u0001\u0007q.\u0001\u0003dEV4\u0007BBA\u0015=\u0001\u0007a\n\u0003\u0004\u0002.y\u0001\rA\u0014\u0015\u0006=\u0005m\u0012qV\u0019\u0007=u\f\t,a.2\u0013\r\nY%!\u0015\u00024\u0006M\u0013'C\u0012\u0002r\u0005M\u0014QWA,c\u0015\u0011s\nUA<c\r1\u0013\u0011\t\u000b\b=\u0006m\u0016qXAa\u0011\u0019\til\ba\u0001{\u0006\t1\u000f\u0003\u0004\u0002*}\u0001\rA\u0014\u0005\u0007\u0003[y\u0002\u0019\u0001()\u000b}\tY$!22\ryi\u0018qYAgc%\u0019\u00131JA)\u0003\u0013\f\u0019&M\u0005$\u0003c\n\u0019(a3\u0002XE*!e\u0014)\u0002xE\u001aa%!\u0011\u0015\u0007y\u000b\t\u000e\u0003\u0004\u0002T\u0002\u0002\r!`\u0001\u0004gR\u0014\u0018a\u00028fo2Kg.\u001a\u0015\u0006C\u0005m\u0012\u0011\\\u0019\u0007=u\fY.!92\u0013\r\nY%!\u0015\u0002^\u0006M\u0013'C\u0012\u0002r\u0005M\u0014q\\A,c\u0015\u0011s\nUA<c\r1\u0013\u0011I\u0001\u0006M2,8\u000f\u001b\u0015\u0006E\u0005m\u0012q]\u0019\u0007=u\fI/a<2\u0013\r\nY%!\u0015\u0002l\u0006M\u0013'C\u0012\u0002r\u0005M\u0014Q^A,c\u0015\u0011s\nUA<c\r1\u0013\u0011I\u0001\u0006G2|7/\u001a\u0015\u0006G\u0005m\u0012Q_\u0019\u0007=u\f90!@2\u0013\r\nY%!\u0015\u0002z\u0006M\u0013'C\u0012\u0002r\u0005M\u00141`A,c\u0015\u0011s\nUA<c\r1\u0013\u0011\t\u0015\bG\t\u0005!Q\u0002B\b!\u0011\u0011\u0019A!\u0003\u000e\u0005\t\u0015!b\u0001B\u0004o\u0005!A.\u00198h\u0013\u0011\u0011YA!\u0002\u0003!M+\b\u000f\u001d:fgN<\u0016M\u001d8j]\u001e\u001c\u0018!\u0002<bYV,GF\u0001B\tC\t\u0011\u0019\"A\u0002uef\u0004")
public class SmartWriter
extends OutputStream
implements FlushBufferCapable {
    private final OutputStream outputStream;
    private final Charset charset;
    private final int nChars;
    private OutputStream os;
    private SStreamEncoder se;
    private final char[] cb;
    private int amount;
    private final String lineSeparator;

    public OutputStream outputStream() {
        return this.outputStream;
    }

    public Charset charset() {
        return this.charset;
    }

    public int nChars() {
        return this.nChars;
    }

    private OutputStream os() {
        return this.os;
    }

    private void os_$eq(OutputStream x$1) {
        this.os = x$1;
    }

    private SStreamEncoder se() {
        return this.se;
    }

    private void se_$eq(SStreamEncoder x$1) {
        this.se = x$1;
    }

    private char[] cb() {
        return this.cb;
    }

    private int amount() {
        return this.amount;
    }

    private void amount_$eq(int x$1) {
        this.amount = x$1;
    }

    private String lineSeparator() {
        return this.lineSeparator;
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.validateOutputStream();
        this.os().write(b, off, len);
    }

    private void validateOutputStream() {
        if (!(this.os() instanceof FlushBufferedOutputStream)) {
            this.se().flush();
            this.os_$eq(FlushBufferedOutputStream$.MODULE$.apply(this.outputStream(), this.nChars() * 2));
            this.se_$eq(SStreamEncoder$.MODULE$.forOutputStreamWriter(this.os(), this.charset(), this.nChars()));
        }
        this.flushTextBuffers();
    }

    @Override
    public void write(int b) {
        this.validateOutputStream();
        this.os().write(b);
    }

    @Override
    public void flushBuffer() throws IOException {
        this.flushTextBuffers();
        OutputStream outputStream = this.os();
        if (outputStream instanceof FlushBufferedOutputStream) {
            FlushBufferedOutputStream flushBufferedOutputStream = (FlushBufferedOutputStream)outputStream;
            flushBufferedOutputStream.flushBuffer();
            return;
        }
    }

    private void flushTextBuffers() {
        this.doFlushInternalBuffer();
        this.se().flushBuffer();
    }

    private void doFlushInternalBuffer() {
        if (this.amount() > 0) {
            this.se().write(this.cb(), 0, this.amount());
            this.amount_$eq(0);
            return;
        }
    }

    public void write(char c) throws IOException {
        if (this.amount() >= this.nChars()) {
            this.flushBuffer();
        }
        this.cb()[this.amount()] = c;
        this.amount_$eq(this.amount() + 1);
    }

    private int min(int a, int b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        int d;
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (len >= this.nChars()) {
            this.doFlushInternalBuffer();
            this.se().write(cbuf, off, len);
            return;
        }
        int t = off + len;
        for (int b = off; b < t; b += d) {
            d = this.min(this.nChars() - this.amount(), t - b);
            System.arraycopy(cbuf, b, this.cb(), this.amount(), d);
            this.amount_$eq(this.amount() + d);
            if (this.amount() < this.nChars()) continue;
            this.doFlushInternalBuffer();
        }
    }

    public void write(String s, int off, int len) throws IOException {
        int d;
        int t = off + len;
        for (int b = off; b < t; b += d) {
            d = this.min(this.nChars() - this.amount(), t - b);
            s.getChars(b, b + d, this.cb(), this.amount());
            this.amount_$eq(this.amount() + d);
            if (this.amount() < this.nChars()) continue;
            this.doFlushInternalBuffer();
        }
    }

    public void write(String str) {
        int stringLength = str.length();
        if (this.amount() + stringLength >= this.nChars()) {
            this.doFlushInternalBuffer();
            if (this.nChars() >= stringLength) {
                str.getChars(0, stringLength, this.cb(), this.amount());
                this.amount_$eq(this.amount() + stringLength);
                return;
            }
            this.se().write(str);
            return;
        }
        str.getChars(0, stringLength, this.cb(), this.amount());
        this.amount_$eq(this.amount() + stringLength);
    }

    public void newLine() throws IOException {
        this.write(this.lineSeparator());
    }

    @Override
    public void flush() throws IOException {
        this.doFlushInternalBuffer();
        this.se().flush();
    }

    @Override
    public void close() throws IOException {
        try (SStreamEncoder w = this.se();){
            this.doFlushInternalBuffer();
        }
    }

    public SmartWriter(OutputStream outputStream, Charset charset, int nChars) {
        this.outputStream = outputStream;
        this.charset = charset;
        this.nChars = nChars;
        this.os = outputStream;
        this.se = SStreamEncoder$.MODULE$.forOutputStreamWriter(this.os(), charset, nChars);
        this.cb = new char[nChars];
        this.amount = 0;
        this.lineSeparator = System.getProperty("line.separator");
    }
}

