/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.maven;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.maven.pom.parser.api.MavenPomParser;
import org.mule.maven.pom.parser.api.MavenPomParserProvider;
import org.mule.maven.pom.parser.api.model.AdditionalPluginDependencies;
import org.mule.maven.pom.parser.api.model.ArtifactCoordinates;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.globalconfig.api.GlobalConfigLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorCreateException;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderConfiguration;
import org.mule.runtime.module.artifact.internal.util.FileJarExplorer;
import org.mule.runtime.module.artifact.internal.util.JarInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ArtifactClassLoaderConfigurationBuilder
extends ClassLoaderConfiguration.ClassLoaderConfigurationBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArtifactClassLoaderConfigurationBuilder.class);
    private boolean processSharedLibraries = false;
    private boolean processAdditionalPluginLibraries = false;
    protected FileJarExplorer fileJarExplorer = new FileJarExplorer();
    protected File artifactFolder;
    protected ArtifactDescriptor deployableArtifactDescriptor;
    protected org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor artifactBundleDescriptor;

    public ArtifactClassLoaderConfigurationBuilder(File artifactFolder, org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor artifactBundleDescriptor) {
        Objects.requireNonNull(artifactFolder, "artifactFolder cannot be null");
        Objects.requireNonNull(artifactBundleDescriptor, "artifactBundleDescriptor cannot be null");
        this.artifactBundleDescriptor = artifactBundleDescriptor;
        this.artifactFolder = artifactFolder;
    }

    public ClassLoaderConfiguration.ClassLoaderConfigurationBuilder exportingSharedLibraries() {
        this.processSharedLibraries = true;
        return this;
    }

    public ClassLoaderConfiguration.ClassLoaderConfigurationBuilder additionalPluginLibraries() {
        this.processAdditionalPluginLibraries = true;
        return this;
    }

    public void setDeployableArtifactDescriptor(ArtifactDescriptor deployableArtifactDescriptor) {
        this.deployableArtifactDescriptor = deployableArtifactDescriptor;
    }

    public ClassLoaderConfiguration build() {
        Optional<Object> mavenParser = Optional.empty();
        if (this.processSharedLibraries || this.processAdditionalPluginLibraries) {
            mavenParser = Optional.of(MavenPomParserProvider.discoverProvider().createMavenPomParserClient(this.artifactFolder.toPath(), this.getActiveProfiles()));
        }
        if (this.processSharedLibraries) {
            mavenParser.ifPresent(this::exportSharedLibrariesResourcesAndPackages);
        }
        if (this.processAdditionalPluginLibraries) {
            mavenParser.ifPresent(this::processAdditionalPluginLibraries);
        }
        return super.build();
    }

    protected List<String> getActiveProfiles() {
        return GlobalConfigLoader.getMavenConfig().getActiveProfiles().orElse(Collections.emptyList());
    }

    private void exportSharedLibrariesResourcesAndPackages(MavenPomParser parser) {
        this.doExportSharedLibrariesResourcesAndPackages(parser);
    }

    private void processAdditionalPluginLibraries(MavenPomParser parser) {
        LinkedList<AdditionalPluginDependencies> pomAdditionalPluginDependenciesForArtifacts = new LinkedList<AdditionalPluginDependencies>(this.doProcessAdditionalPluginLibraries(parser).values());
        pomAdditionalPluginDependenciesForArtifacts.forEach(additionalDependenciesForArtifact -> {
            List pluginAdditionalLibraries = additionalDependenciesForArtifact.getAdditionalDependencies();
            this.findBundleDependency(additionalDependenciesForArtifact.getGroupId(), additionalDependenciesForArtifact.getArtifactId(), Optional.of(ArtifactType.PLUGIN.getMavenArtifactClassifier())).ifPresent(pluginArtifactBundleDependency -> this.replaceBundleDependency((BundleDependency)pluginArtifactBundleDependency, new BundleDependency.Builder(pluginArtifactBundleDependency).setAdditionalDependencies(pluginAdditionalLibraries.stream().map(additionalDependency -> new BundleDependency.Builder().setDescriptor(this.convertBundleDescriptor((BundleDescriptor)additionalDependency)).build()).collect(Collectors.toList())).build()));
        });
    }

    protected Map<ArtifactCoordinates, AdditionalPluginDependencies> doProcessAdditionalPluginLibraries(MavenPomParser parser) {
        return parser.getPomAdditionalPluginDependenciesForArtifacts();
    }

    protected void replaceBundleDependency(BundleDependency original, BundleDependency modified) {
        this.dependencies.remove(original);
        this.dependencies.add(modified);
    }

    protected void doExportSharedLibrariesResourcesAndPackages(MavenPomParser parser) {
        parser.getSharedLibraries().stream().forEach(shareLibrary -> {
            if (!this.validateMuleRuntimeSharedLibrary(shareLibrary.getGroupId(), shareLibrary.getArtifactId())) {
                this.findAndExportSharedLibrary(shareLibrary.getGroupId(), shareLibrary.getArtifactId());
            }
        });
    }

    protected final boolean validateMuleRuntimeSharedLibrary(String groupId, String artifactId) {
        if ("org.mule.runtime".equals(groupId) || "com.mulesoft.mule.runtime.modules".equals(groupId)) {
            LOGGER.warn("Shared library '{}:{}' is a Mule Runtime dependency. It will not be shared by the app in order to avoid classloading issues. Please consider removing it, or at least not putting it as a sharedLibrary.", (Object)groupId, (Object)artifactId);
            return true;
        }
        return false;
    }

    protected void findAndExportSharedLibrary(String groupId, String artifactId) {
        Optional<BundleDependency> bundleDependencyOptional = this.findBundleDependency(groupId, artifactId, Optional.empty());
        BundleDependency bundleDependency = bundleDependencyOptional.orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Dependency %s:%s could not be found within the artifact %s. It must be declared within the maven dependencies of the artifact.", groupId, artifactId, this.artifactFolder.getName()))));
        JarInfo jarInfo = this.fileJarExplorer.explore(bundleDependency.getBundleUri());
        this.exportingPackages(jarInfo.getPackages());
        this.exportingResources(jarInfo.getResources());
    }

    protected Optional<BundleDependency> findBundleDependency(String groupId, String artifactId, Optional<String> classifierOptional) {
        return this.dependencies.stream().filter(bundleDependency -> bundleDependency.getDescriptor().getArtifactId().equals(artifactId) && bundleDependency.getDescriptor().getGroupId().equals(groupId) && classifierOptional.map(classifier -> classifier.equals(bundleDependency.getDescriptor().getClassifier().orElse(null))).orElse(true) != false).findFirst();
    }

    public List<URL> includeAdditionalPluginDependencies() {
        ArrayList<URL> dependenciesArtifactsUrls = new ArrayList<URL>();
        if (this.deployableArtifactDescriptor != null) {
            this.deployableArtifactDescriptor.getClassLoaderConfiguration().getDependencies().stream().filter(bundleDescriptor -> bundleDescriptor.getDescriptor().isPlugin()).filter(bundleDescriptor -> bundleDescriptor.getDescriptor().getGroupId().equals(this.artifactBundleDescriptor.getGroupId()) && bundleDescriptor.getDescriptor().getArtifactId().equals(this.artifactBundleDescriptor.getArtifactId())).filter(bundleDependency -> bundleDependency.getAdditionalDependenciesList() != null && !bundleDependency.getAdditionalDependenciesList().isEmpty()).forEach(bundleDependency -> this.processPluginAdditionalDependenciesURIs((BundleDependency)bundleDependency).forEach(uri -> {
                URL dependencyArtifactUrl;
                try {
                    dependencyArtifactUrl = uri.toURL();
                }
                catch (MalformedURLException e) {
                    throw new ArtifactDescriptorCreateException(String.format("There was an exception obtaining the URL for the artifact [%s], file [%s]", this.artifactFolder.getAbsolutePath(), uri), (Throwable)e);
                }
                this.containing(dependencyArtifactUrl);
                dependenciesArtifactsUrls.add(dependencyArtifactUrl);
            }));
        }
        return dependenciesArtifactsUrls;
    }

    protected abstract List<URI> processPluginAdditionalDependenciesURIs(BundleDependency var1);

    private org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor convertBundleDescriptor(BundleDescriptor descriptor) {
        BundleDescriptor.Builder builder = new BundleDescriptor.Builder().setGroupId(descriptor.getGroupId()).setArtifactId(descriptor.getArtifactId()).setVersion(descriptor.getVersion());
        if (descriptor.getBaseVersion() != null) {
            builder.setBaseVersion(descriptor.getBaseVersion());
        }
        if (descriptor.getType() != null) {
            builder.setType(descriptor.getType());
        }
        descriptor.getClassifier().ifPresent(arg_0 -> ((BundleDescriptor.Builder)builder).setClassifier(arg_0));
        return builder.build();
    }
}

