/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.message.content;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;
import org.mule.service.http.netty.impl.server.util.HttpParser;

public class StreamedMultipartHttpEntity
implements HttpEntity {
    private final InputStream content;
    private final String contentType;
    private final Long contentLength;
    private final CompletableFuture<MultiMap<String, String>> futureTrailers;

    public StreamedMultipartHttpEntity(InputStream content, String contentType) {
        this(content, contentType, null, CompletableFuture.completedFuture(MultiMap.emptyMultiMap()));
    }

    public StreamedMultipartHttpEntity(InputStream content, String contentType, CompletableFuture<MultiMap<String, String>> futureTrailers) {
        this(content, contentType, null, futureTrailers);
    }

    public StreamedMultipartHttpEntity(InputStream content, String contentType, Long contentLength) {
        this(content, contentType, contentLength, CompletableFuture.completedFuture(MultiMap.emptyMultiMap()));
    }

    public StreamedMultipartHttpEntity(InputStream content, String contentType, Long contentLength, CompletableFuture<MultiMap<String, String>> futureTrailers) {
        this.content = content;
        this.contentType = contentType;
        this.contentLength = contentLength;
        this.futureTrailers = futureTrailers;
    }

    public boolean isStreaming() {
        return true;
    }

    public boolean isComposed() {
        return true;
    }

    public InputStream getContent() throws UnsupportedOperationException {
        return this.content;
    }

    public byte[] getBytes() throws UnsupportedOperationException {
        try {
            return IOUtils.toByteArray((InputStream)this.content);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<HttpPart> getParts() throws IOException, UnsupportedOperationException {
        return HttpParser.parseMultipartContent(this.content, this.contentType);
    }

    public Optional<Long> getLength() {
        return Optional.ofNullable(this.contentLength);
    }

    public void onComplete(BiConsumer<? super MultiMap<String, String>, ? super Throwable> completionCallback) {
        this.futureTrailers.whenComplete(completionCallback);
    }
}

