/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RejectFailedUpgradeHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RejectFailedUpgradeHandler.class);
    private final AtomicBoolean alreadyRejected = new AtomicBoolean(false);

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof FailedHttpUpgrade) {
            FailedHttpUpgrade failedUpgrade = (FailedHttpUpgrade)evt;
            this.alreadyRejected.set(true);
            this.sendBadRequest(ctx, failedUpgrade.upgradeRequest(), failedUpgrade.errorMessage());
        }
        ctx.fireUserEventTriggered(evt);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (this.alreadyRejected.get()) {
            LOGGER.debug("Skipping the processing of a request because it was a rejected upgrade. Processing it after this point would cause two responses to be sent for the same request.");
            ReferenceCountUtil.release((Object)msg);
            return;
        }
        ctx.fireChannelRead(msg);
    }

    private void sendBadRequest(ChannelHandlerContext ctx, HttpRequest request, String message) {
        ByteBuf messageAsByteBuf = ByteBufUtil.writeUtf8((ByteBufAllocator)ctx.alloc(), (CharSequence)message);
        DefaultFullHttpResponse badRequest = new DefaultFullHttpResponse(request.protocolVersion(), HttpResponseStatus.BAD_REQUEST, messageAsByteBuf);
        ctx.writeAndFlush((Object)badRequest).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public record FailedHttpUpgrade(HttpRequest upgradeRequest, String errorMessage) {
    }
}

