/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.reboot;

import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.mule.runtime.module.boot.internal.BootModuleLayerValidationBootstrapConfigurer;
import org.mule.runtime.module.boot.internal.BootstrapConfigurer;
import org.mule.runtime.module.boot.internal.DefaultMuleContainerFactory;
import org.mule.runtime.module.boot.internal.MuleContainerFactory;
import org.mule.runtime.module.boot.internal.MuleContainerWrapper;
import org.mule.runtime.module.boot.internal.MuleContainerWrapperProvider;
import org.mule.runtime.module.boot.internal.MuleLog4jConfigurer;
import org.mule.runtime.module.boot.internal.SLF4JBridgeHandlerBootstrapConfigurer;

public class MuleContainerBootstrap {
    public static final String[][] CLI_OPTIONS = new String[][]{{"main", "true", "Main Class"}, {"production", "false", "Modify the system class loader for production use (as in Mule 2.x)"}, {"version", "false", "Show product and version information"}};

    public static void main(String[] args) {
        CommandLine commandLine;
        DefaultMuleContainerFactory muleContainerFactory = new DefaultMuleContainerFactory("mule.home", "mule.base");
        MuleContainerWrapper muleContainerWrapper = MuleContainerWrapperProvider.getMuleContainerWrapper();
        try {
            commandLine = MuleContainerBootstrap.parseCommandLine(args);
        }
        catch (Exception ex) {
            muleContainerWrapper.haltAndCatchFire(1, ex.getMessage());
            return;
        }
        muleContainerWrapper.addBootstrapConfigurer((BootstrapConfigurer)new SLF4JBridgeHandlerBootstrapConfigurer());
        muleContainerWrapper.addBootstrapConfigurer((BootstrapConfigurer)new BootModuleLayerValidationBootstrapConfigurer());
        muleContainerWrapper.addBootstrapConfigurer((BootstrapConfigurer)new MuleLog4jConfigurer());
        muleContainerWrapper.configureAndStart((MuleContainerFactory)muleContainerFactory, commandLine);
    }

    private static CommandLine parseCommandLine(String[] args) throws ParseException {
        Options options = new Options();
        for (String[] element : CLI_OPTIONS) {
            options.addOption(element[0], "true".equalsIgnoreCase(element[1]), element[2]);
        }
        return new BasicParser().parse(options, args, true);
    }
}

