/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.lifecycle.LifecycleManager;
import org.mule.runtime.core.api.lifecycle.LifecycleState;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.runtime.resolver.LifecycleAwareValueResolverWrapper;

public class LifecycleInitialiserValueResolverWrapper<T>
extends LifecycleAwareValueResolverWrapper<T> {
    private final Injector injector;
    private final LifecycleManager lifecycleManager;
    private final Set<Reference<Object>> producedObjects = Collections.newSetFromMap(new ConcurrentHashMap());

    public LifecycleInitialiserValueResolverWrapper(ValueResolver<T> delegate, Injector injector, LifecycleManager lifecycleManager) {
        super(delegate);
        this.injector = injector;
        this.lifecycleManager = lifecycleManager;
    }

    @Override
    public T resolve(ValueResolvingContext context) throws MuleException {
        Object value = super.resolve(context);
        if (this.producedObjects.add((Reference<Object>)new Reference(value))) {
            LifecycleState state = this.lifecycleManager.getState();
            if (state.isInitialising() || state.isInitialised()) {
                LifecycleUtils.initialiseIfNeeded(value, (Injector)this.injector);
            }
            if (state.isStarting() || state.isStarted()) {
                LifecycleUtils.startIfNeeded(value);
            }
        }
        return value;
    }

    @Override
    public void dispose() {
        this.producedObjects.clear();
        super.dispose();
    }
}

