/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.mule.service.http.netty.impl.server.RejectFailedUpgradeHandler;
import org.mule.service.http.test.common.AbstractHttpTestCase;

class RejectFailedUpgradeHandlerTestCase
extends AbstractHttpTestCase {
    RejectFailedUpgradeHandlerTestCase() {
    }

    @Test
    void testNormalRequestPassesThrough() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new RejectFailedUpgradeHandler()});
        DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/test");
        channel.writeInbound(new Object[]{request});
        HttpRequest inboundRequest = (HttpRequest)channel.readInbound();
        MatcherAssert.assertThat((Object)inboundRequest, (Matcher)Matchers.is((Object)request));
        MatcherAssert.assertThat((Object)channel.isOpen(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    void testFailedUpgradeSendsBadRequestAndClosesConnection() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new RejectFailedUpgradeHandler()});
        DefaultFullHttpRequest upgradeRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/upgrade");
        String errorMessage = "Upgrade failed";
        RejectFailedUpgradeHandler.FailedHttpUpgrade failedUpgrade = new RejectFailedUpgradeHandler.FailedHttpUpgrade((HttpRequest)upgradeRequest, errorMessage);
        channel.pipeline().fireUserEventTriggered((Object)failedUpgrade);
        FullHttpResponse response = (FullHttpResponse)channel.readOutbound();
        MatcherAssert.assertThat((Object)response.status(), (Matcher)Matchers.is((Object)HttpResponseStatus.BAD_REQUEST));
        MatcherAssert.assertThat((Object)response.content().toString(CharsetUtil.UTF_8), (Matcher)Matchers.is((Object)errorMessage));
        MatcherAssert.assertThat((Object)channel.isOpen(), (Matcher)Matchers.is((Object)false));
    }
}

