/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.message;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.entity.EntityFactory;
import org.mule.runtime.http.api.domain.entity.FeedableHttpEntity;
import org.mule.service.http.test.common.AbstractHttpServiceTestCase;

class FeedableHttpEntityTestCase
extends AbstractHttpServiceTestCase {
    public static final String HELLO = "Hello ";
    public static final String WORLD = "world!";
    public static final String HELLO_WORLD = "Hello world!";

    public FeedableHttpEntityTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Test
    void feedContentAndFinish() throws Exception {
        EntityFactory entityFactory = this.service.getEntityFactory();
        FeedableHttpEntity feedableEntity = entityFactory.feedable();
        feedableEntity.feed(ByteBuffer.wrap(HELLO.getBytes()));
        feedableEntity.feed(ByteBuffer.wrap(WORLD.getBytes()));
        feedableEntity.complete();
        String out = new String(feedableEntity.getBytes());
        MatcherAssert.assertThat((Object)out, (Matcher)Matchers.is((Object)HELLO_WORLD));
        CompletableFuture futureTrailers = new CompletableFuture();
        feedableEntity.onComplete((trailers, throwable) -> {
            if (throwable != null) {
                futureTrailers.completeExceptionally((Throwable)throwable);
            } else {
                futureTrailers.complete(trailers);
            }
        });
        MultiMap trailers2 = (MultiMap)futureTrailers.get();
        MatcherAssert.assertThat((Object)trailers2.isEmpty(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)trailers2, (Matcher)Matchers.is((Matcher)Matchers.anEmptyMap()));
    }
}

