/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transaction.xa;

import java.util.Objects;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.mule.runtime.api.tx.xa.ResourceManagerException;
import org.mule.runtime.core.internal.transaction.xa.AbstractTransactionContext;
import org.mule.runtime.core.internal.transaction.xa.AbstractXAResourceManager;
import org.mule.runtime.core.internal.transaction.xa.AbstractXaTransactionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultXASession<T extends AbstractXaTransactionContext>
implements XAResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultXASession.class);
    private Xid localXid = null;
    private final AbstractXAResourceManager<T> resourceManager;
    private T localContext = null;

    protected DefaultXASession(AbstractXAResourceManager<T> resourceManager) {
        this.resourceManager = Objects.requireNonNull(resourceManager);
    }

    public XAResource getXAResource() {
        return this;
    }

    public Object getResourceManager() {
        return this.resourceManager;
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        DefaultXASession defaultXASession;
        return xares instanceof DefaultXASession && (defaultXASession = (DefaultXASession)xares).getResourceManager().equals(this.resourceManager);
    }

    private String flagsToString(int flags) {
        return switch (flags) {
            case 0 -> "starts";
            case 0x200000 -> "joins";
            case 0x8000000 -> "resumes";
            case 0x2000000 -> "suspends";
            case 0x20000000 -> "fails";
            default -> "ends";
        };
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        LOGGER.debug("Thread {} {} work on behalf of transaction branch {}", new Object[]{Thread.currentThread(), this.flagsToString(flags), xid});
        if (this.localContext != null) {
            throw new XAException(-6);
        }
        if (this.localXid != null) {
            throw new XAException(-6);
        }
        switch (flags) {
            case 0x8000000: {
                this.localContext = this.resourceManager.getSuspendedTransactionalResource(xid);
                if (this.localContext == null) {
                    throw new XAException(-4);
                }
                this.resourceManager.removeSuspendedTransactionalResource(xid);
                break;
            }
            default: {
                try {
                    this.localContext = this.createTransactionContext(xid);
                    this.resourceManager.beginTransaction((AbstractTransactionContext)this.localContext);
                    break;
                }
                catch (Exception e) {
                    LOGGER.error("Could not create new transactional resource", (Throwable)e);
                    throw (XAException)new XAException(e.getMessage()).initCause(e);
                }
            }
        }
        this.localXid = xid;
        this.resourceManager.addActiveTransactionalResource(this.localXid, this.localContext);
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        LOGGER.debug("Thread {} {} work on behalf of transaction branch {}", new Object[]{Thread.currentThread(), this.flagsToString(flags), xid});
        if (this.localContext == null) {
            throw new XAException(-4);
        }
        if (this.localXid == null || !this.localXid.equals(xid)) {
            throw new XAException(-6);
        }
        switch (flags) {
            case 0x2000000: {
                this.resourceManager.addSuspendedTransactionalResource(this.localXid, this.localContext);
                this.resourceManager.removeActiveTransactionalResource(this.localXid);
                break;
            }
            case 0x20000000: {
                this.resourceManager.setTransactionRollbackOnly((AbstractTransactionContext)this.localContext);
                break;
            }
        }
        this.localXid = null;
        this.localContext = null;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (xid == null) {
            throw new XAException(-6);
        }
        T context = this.resourceManager.getActiveTransactionalResource(xid);
        if (context == null) {
            LOGGER.debug("Commit called without a transaction context");
            this.commitDanglingTransaction(xid, onePhase);
            return;
        }
        LOGGER.debug("Committing transaction branch {}", (Object)xid);
        if (((AbstractXaTransactionContext)context).status == 1) {
            throw new XAException(100);
        }
        try {
            if (((AbstractXaTransactionContext)context).status != 2) {
                if (onePhase) {
                    this.resourceManager.prepareTransaction(context);
                } else {
                    throw new XAException(-6);
                }
            }
            this.resourceManager.commitTransaction((AbstractTransactionContext)context);
            this.localContext = null;
        }
        catch (ResourceManagerException e) {
            throw (XAException)new XAException(-3).initCause(e);
        }
        this.resourceManager.removeActiveTransactionalResource(xid);
        this.resourceManager.removeSuspendedTransactionalResource(xid);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException(-6);
        }
        T context = this.resourceManager.getActiveTransactionalResource(xid);
        if (context == null) {
            LOGGER.debug("Rollback called without a transaction context");
            this.rollbackDandlingTransaction(xid);
            return;
        }
        LOGGER.debug("Rolling back transaction branch {}", (Object)xid);
        try {
            this.resourceManager.rollbackTransaction((AbstractTransactionContext)context);
            this.localContext = null;
        }
        catch (ResourceManagerException e) {
            throw (XAException)new XAException(-3).initCause(e);
        }
        this.resourceManager.removeActiveTransactionalResource(xid);
        this.resourceManager.removeSuspendedTransactionalResource(xid);
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException(-6);
        }
        T context = this.resourceManager.getTransactionalResource(xid);
        if (context == null) {
            throw new XAException(-4);
        }
        LOGGER.debug("Preparing transaction branch {}", (Object)xid);
        if (((AbstractXaTransactionContext)context).status == 1) {
            throw new XAException(100);
        }
        try {
            return this.resourceManager.prepareTransaction(context);
        }
        catch (ResourceManagerException e) {
            throw (XAException)new XAException(-3).initCause(e);
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        LOGGER.debug("Forgetting transaction branch {}", (Object)xid);
        T context = this.resourceManager.getTransactionalResource(xid);
        if (context == null) {
            throw new XAException(-4);
        }
        this.resourceManager.removeActiveTransactionalResource(xid);
        this.resourceManager.removeSuspendedTransactionalResource(xid);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return (int)(this.resourceManager.getDefaultTransactionTimeout() / 1000L);
    }

    @Override
    public boolean setTransactionTimeout(int timeout) throws XAException {
        this.resourceManager.setDefaultTransactionTimeout((long)timeout * 1000L);
        return false;
    }

    public T getTransactionContext() {
        return this.localContext;
    }

    protected abstract void commitDanglingTransaction(Xid var1, boolean var2) throws XAException;

    protected abstract void rollbackDandlingTransaction(Xid var1) throws XAException;

    protected abstract T createTransactionContext(Xid var1);
}

