/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.core.api.registry.ServiceRegistry;

@NoExtend
public abstract class AbstractServiceRegistry
implements ServiceRegistry {
    @Override
    public final <T> Collection<T> lookupProviders(Class<T> providerClass, ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        return Collections.unmodifiableList(new ArrayList<T>(this.doLookupProviders(providerClass, classLoader)));
    }

    protected abstract <T> Collection<T> doLookupProviders(Class<T> var1, ClassLoader var2);

    @Override
    public final <T> T lookupProvider(Class<T> providerClass, ClassLoader classLoader) {
        Collection<T> providers = this.lookupProviders(providerClass, classLoader);
        if (providers.isEmpty()) {
            throw new IllegalStateException("No provider found for class " + providerClass.getName());
        }
        if (providers.size() > 1) {
            List<String> providersNames = providers.stream().map(provider -> provider.getClass().getName()).toList();
            throw new IllegalStateException("More than one provided found for class %s, providers found are: %s".formatted(providerClass.getName(), StringUtils.join(providersNames, (String)",")));
        }
        return providers.iterator().next();
    }
}

