/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.server;

import io.qameta.allure.Issue;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.netty.impl.message.content.StringHttpEntity;
import org.mule.service.http.test.common.server.AbstractHttpServerTestCase;
import org.mule.service.http.test.netty.utils.NoOpResponseStatusCallback;
import org.mule.service.http.test.netty.utils.ResponseWithoutHeaders;
import org.mule.service.http.test.netty.utils.TcpTextClient;

@Issue(value="W-17413024")
class ServerReadTimeoutTestCase
extends AbstractHttpServerTestCase {
    private static final long SMALL_READ_TIMEOUT_MILLIS = 100L;

    public ServerReadTimeoutTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Override
    protected String getServerName() {
        return "test-server";
    }

    @Override
    protected HttpServerConfiguration.Builder configureServer(HttpServerConfiguration.Builder builder) {
        return builder.setReadTimeout(100L);
    }

    @BeforeEach
    public void setup() throws Exception {
        this.setUpServer();
        this.server.addRequestHandler("/test", (requestContext, responseCallback) -> {
            String asString;
            try {
                asString = IOUtils.toString((InputStream)requestContext.getRequest().getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            responseCallback.responseReady((HttpResponse)new ResponseWithoutHeaders(HttpConstants.HttpStatus.OK, (HttpEntity)new StringHttpEntity(asString)), (ResponseStatusCallback)new NoOpResponseStatusCallback());
        });
    }

    @Test
    void sendPartialRequestShouldTimeout() throws IOException {
        try (TcpTextClient tcpTextClient = new TcpTextClient("localhost", this.port);){
            tcpTextClient.sendString("POST /test HTTP/1.1\r\nHost: localhost: %d\r\nTransfer-Encoding: chunked\r\n\r\n7\r\nPartial\r\n".formatted(this.port));
            String header = tcpTextClient.receiveUntil("\r\n\r\n");
            MatcherAssert.assertThat((Object)header, (Matcher)Matchers.equalToCompressingWhiteSpace((String)"HTTP/1.1 408 Request Timeout\r\nConnection: close\r\nContent-Length: 23"));
            String content = tcpTextClient.receiveUntil("\r\n\r\n");
            MatcherAssert.assertThat((Object)content, (Matcher)Matchers.is((Object)"Timeout reading request"));
            String nothing = tcpTextClient.receiveUntil("\r\n\r\n");
            MatcherAssert.assertThat((Object)nothing, (Matcher)Matchers.is((Object)""));
        }
    }
}

