/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.application.ApplicationStatus;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.internal.ArchiveDeployer;
import org.mule.runtime.module.deployment.internal.util.ObservableList;
import org.mule.runtime.module.deployment.internal.util.zip.ZipUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainBundleArchiveDeployer {
    protected static Logger LOGGER = LoggerFactory.getLogger(DomainBundleArchiveDeployer.class);
    private final Optional<Properties> additionalDeploymentProperties;
    private final DeploymentListener deploymentListener;
    private final ArchiveDeployer<DomainDescriptor, Domain> domainDeployer;
    private final ObservableList<Domain> domains;
    private final ArchiveDeployer<ApplicationDescriptor, Application> applicationDeployer;
    private final DeploymentListener domainDeploymentListener;
    private final DeploymentListener applicationDeploymentListener;
    private final DeploymentService deploymentService;

    public DomainBundleArchiveDeployer(Optional<Properties> additionalDeploymentProperties, DeploymentListener deploymentListener, ArchiveDeployer<DomainDescriptor, Domain> domainDeployer, ObservableList<Domain> domains, ArchiveDeployer<ApplicationDescriptor, Application> applicationDeployer, DeploymentListener domainDeploymentListener, DeploymentListener applicationDeploymentListener, DeploymentService deploymentService) {
        this.additionalDeploymentProperties = additionalDeploymentProperties;
        this.deploymentListener = deploymentListener;
        this.domainDeployer = domainDeployer;
        this.domains = domains;
        this.applicationDeployer = applicationDeployer;
        this.domainDeploymentListener = domainDeploymentListener;
        this.applicationDeploymentListener = applicationDeploymentListener;
        this.deploymentService = deploymentService;
    }

    public void deployArtifact(URI uri) throws DeploymentException {
        LOGGER.info("deploying artifact: " + String.valueOf(uri));
        File bundleFile = new File(uri);
        String bundleName = StringUtils.removeEndIgnoreCase((String)bundleFile.getName(), (String)".zip");
        this.deploymentListener.onDeploymentStart(bundleName);
        File tempFolder = null;
        boolean isRedeploy = false;
        String domainName = null;
        try {
            tempFolder = this.unzipDomainBundle(bundleFile);
            File domainFile = this.getDomainFile(tempFolder);
            domainName = FilenameUtils.getBaseName((String)domainFile.getName());
            Domain domain = this.findDomain(domainName);
            isRedeploy = domain != null;
            Set<Object> originalAppIds = new HashSet();
            if (isRedeploy) {
                this.domainDeploymentListener.onRedeploymentStart(domainName);
                Collection<Application> originalDomainApplications = this.deploymentService.findDomainApplications(domainName);
                for (Application domainApplication : originalDomainApplications) {
                    if (domainApplication.getStatus() != ApplicationStatus.STARTED && domainApplication.getStatus() != ApplicationStatus.STOPPED) continue;
                    this.applicationDeploymentListener.onRedeploymentStart(domainApplication.getArtifactName());
                }
                originalAppIds = originalDomainApplications.stream().map(a -> a.getArtifactName()).collect(Collectors.toSet());
            }
            try {
                this.deployDomain(domainFile);
            }
            catch (Exception e) {
                LOGGER.warn("Domain bundle's domain was not deployed", (Throwable)e);
            }
            this.deployApplications(tempFolder, isRedeploy);
            if (isRedeploy) {
                Collection<Application> newDomainApplications = this.deploymentService.findDomainApplications(domainName);
                originalAppIds.stream().forEach(appId -> {
                    Optional<Application> application = newDomainApplications.stream().filter(newApp -> appId.equals(newApp.getArtifactName())).findFirst();
                    if (!application.isPresent()) {
                        DeploymentException cause = new DeploymentException(I18nMessageFactory.createStaticMessage((String)"Application was not included in the updated domain bundle"));
                        this.applicationDeploymentListener.onDeploymentFailure((String)appId, (Throwable)cause);
                        this.applicationDeploymentListener.onRedeploymentFailure((String)appId, (Throwable)cause);
                    }
                });
                this.domainDeploymentListener.onRedeploymentSuccess(domainName);
            }
            this.deploymentListener.onDeploymentSuccess(bundleName);
        }
        catch (Exception e) {
            if (isRedeploy) {
                this.domainDeploymentListener.onRedeploymentFailure(domainName, e);
            }
            this.deploymentListener.onDeploymentFailure(bundleName, e);
            if (e instanceof DeploymentException) {
                throw (DeploymentException)e;
            }
            throw new DeploymentException(I18nMessageFactory.createStaticMessage((String)"Error deploying domain bundle"), (Throwable)e);
        }
        finally {
            if (tempFolder != null) {
                try {
                    FileUtils.deleteDirectory((File)tempFolder);
                }
                catch (IOException e) {
                    LOGGER.warn("Error cleaning temp dir", (Throwable)e);
                }
            }
        }
    }

    private void deployApplications(File tempFolder, boolean isRedeploy) {
        File applicationsFolder = new File(tempFolder, "applications");
        if (!applicationsFolder.exists()) {
            throw new DeploymentException(I18nMessageFactory.createStaticMessage((String)"Domain bundle does not contain an application folder"));
        }
        String[] applicationArtifacts = applicationsFolder.list((FilenameFilter)new SuffixFileFilter(".jar"));
        if (applicationArtifacts == null) {
            throw new DeploymentException(I18nMessageFactory.createStaticMessage((String)"Domain bundle does not contain applications"));
        }
        HashSet<String> deployedApps = new HashSet<String>();
        boolean applicationDeploymentError = false;
        for (String applicationArtifact : applicationArtifacts) {
            try {
                this.deployApplication(applicationsFolder, deployedApps, applicationArtifact, isRedeploy);
            }
            catch (Exception e) {
                applicationDeploymentError = true;
            }
        }
        if (applicationDeploymentError) {
            throw new DeploymentException(I18nMessageFactory.createStaticMessage((String)"There was an error deploying the bundled applications"));
        }
    }

    private void deployApplication(File applicationsFolder, Set<String> deployedApps, String applicationArtifact, boolean isRedeploy) {
        String applicationName = FilenameUtils.getBaseName((String)applicationArtifact);
        deployedApps.add(applicationName);
        try {
            this.applicationDeployer.deployPackagedArtifact(new File(applicationsFolder, applicationArtifact).toURI(), Optional.empty());
            this.applicationDeploymentListener.onRedeploymentSuccess(applicationName);
        }
        catch (RuntimeException e) {
            if (isRedeploy) {
                this.applicationDeploymentListener.onRedeploymentFailure(applicationName, e);
            }
            throw e;
        }
    }

    private void deployDomain(File domainFile) throws IOException {
        String domainName = FilenameUtils.getBaseName((String)domainFile.getName());
        Domain domain = this.findDomain(domainName);
        if (domain != null) {
            this.domainDeployer.undeployArtifact(domainName);
            ZipUtils.unzip(domainFile, domain.getLocation());
        }
        this.domainDeployer.deployPackagedArtifact(domainFile.toURI(), this.additionalDeploymentProperties);
    }

    private File getDomainFile(File tempFolder) {
        File sourceDomainFolder = new File(tempFolder, "domain");
        String domainFileName = this.getDomainFileName(sourceDomainFolder);
        return new File(sourceDomainFolder, domainFileName);
    }

    private String getDomainFileName(File sourceDomainFolder) {
        String[] domainFileNames = sourceDomainFolder.list((FilenameFilter)new SuffixFileFilter(".jar"));
        if (domainFileNames == null) {
            throw new DeploymentException(I18nMessageFactory.createStaticMessage((String)"Domain bundle does not contain a domain artifact"));
        }
        return domainFileNames[0];
    }

    private File unzipDomainBundle(File bundleFile) throws IOException {
        File tempFolder = Files.createTempDirectory(bundleFile.getName(), new FileAttribute[0]).toFile();
        tempFolder.delete();
        tempFolder.mkdirs();
        ZipUtils.unzip(bundleFile, tempFolder);
        bundleFile.delete();
        return tempFolder;
    }

    private Domain findDomain(String domainName) {
        return this.domains.stream().filter(domain -> domain.getArtifactName().equals(domainName)).findAny().orElse(null);
    }
}

