/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.util;

import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseBodyPartsInputStream;
import com.ning.http.client.Param;
import com.ning.http.client.Request;
import com.ning.http.client.uri.Uri;
import com.ning.http.util.MiscUtils;
import com.ning.http.util.StringUtils;
import com.ning.http.util.UTF8UrlEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class AsyncHttpProviderUtils {
    public static IOException REMOTELY_CLOSED_EXCEPTION = MiscUtils.buildStaticIOException("Remotely closed");
    public static final Charset DEFAULT_CHARSET;
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    public static final String WEBSOCKET = "ws";
    public static final String WEBSOCKET_SSL = "wss";
    static final byte[] EMPTY_BYTE_ARRAY;

    public static final String getBaseUrl(Uri uri) {
        return uri.getScheme() + "://" + AsyncHttpProviderUtils.getAuthority(uri);
    }

    public static final String getAuthority(Uri uri) {
        int port = uri.getPort() != -1 ? uri.getPort() : AsyncHttpProviderUtils.getDefaultPort(uri);
        return uri.getHost() + ":" + port;
    }

    public static final String contentToString(List<HttpResponseBodyPart> bodyParts, Charset charset) throws UnsupportedEncodingException {
        return new String(AsyncHttpProviderUtils.contentToByte(bodyParts), charset);
    }

    public static final byte[] contentToByte(List<HttpResponseBodyPart> bodyParts) throws UnsupportedEncodingException {
        if (bodyParts.size() == 1) {
            return bodyParts.get(0).getBodyPartBytes();
        }
        int size = 0;
        for (HttpResponseBodyPart body : bodyParts) {
            size += body.getBodyPartBytes().length;
        }
        byte[] bytes = new byte[size];
        int offset = 0;
        for (HttpResponseBodyPart body : bodyParts) {
            byte[] bodyBytes = body.getBodyPartBytes();
            System.arraycopy(bodyBytes, 0, bytes, offset, bodyBytes.length);
            offset += bodyBytes.length;
        }
        return bytes;
    }

    public static final InputStream contentToInputStream(List<HttpResponseBodyPart> bodyParts) throws UnsupportedEncodingException {
        return bodyParts.isEmpty() ? new ByteArrayInputStream(EMPTY_BYTE_ARRAY) : new HttpResponseBodyPartsInputStream(bodyParts);
    }

    public static final boolean isSameHostAndProtocol(Uri uri1, Uri uri2) {
        return uri1.getScheme().equals(uri2.getScheme()) && uri1.getHost().equals(uri2.getHost()) && AsyncHttpProviderUtils.getDefaultPort(uri1) == AsyncHttpProviderUtils.getDefaultPort(uri2);
    }

    public static final int getSchemeDefaultPort(String scheme) {
        return scheme.equalsIgnoreCase(HTTP) || scheme.equalsIgnoreCase(WEBSOCKET) ? 80 : 443;
    }

    public static final int getDefaultPort(Uri uri) {
        int port = uri.getPort();
        if (port == -1) {
            port = AsyncHttpProviderUtils.getSchemeDefaultPort(uri.getScheme());
        }
        return port;
    }

    public static final String getNonEmptyPath(Uri uri) {
        return MiscUtils.isNonEmpty(uri.getPath()) ? uri.getPath() : "/";
    }

    public static final byte[] readFully(InputStream in, int[] lengthWrapper) throws IOException {
        int left;
        int count;
        byte[] b = new byte[Math.max(512, in.available())];
        int offset = 0;
        while ((count = in.read(b, offset, left = b.length - offset)) >= 0) {
            offset += count;
            if (count != left) continue;
            b = AsyncHttpProviderUtils.doubleUp(b);
        }
        lengthWrapper[0] = offset;
        return b;
    }

    private static byte[] doubleUp(byte[] b) {
        int len = b.length;
        byte[] b2 = new byte[len + len];
        System.arraycopy(b, 0, b2, 0, len);
        return b2;
    }

    public static String parseCharset(String contentType) {
        for (String part : contentType.split(";")) {
            String[] val;
            if (!part.trim().startsWith("charset=") || (val = part.split("=")).length <= 1) continue;
            String charset = val[1].trim();
            return charset.replaceAll("\"", "").replaceAll("'", "");
        }
        return null;
    }

    public static String connectionHeader(boolean allowConnectionPooling, boolean http11) {
        if (allowConnectionPooling) {
            return "keep-alive";
        }
        if (http11) {
            return "close";
        }
        return null;
    }

    public static int requestTimeout(AsyncHttpClientConfig config, Request request) {
        return request.getRequestTimeout() != 0 ? request.getRequestTimeout() : config.getRequestTimeout();
    }

    public static boolean followRedirect(AsyncHttpClientConfig config, Request request) {
        return request.getFollowRedirect() != null ? request.getFollowRedirect().booleanValue() : config.isFollowRedirect();
    }

    public static StringBuilder urlEncodeFormParams0(List<Param> params) {
        StringBuilder sb = StringUtils.stringBuilder();
        for (Param param : params) {
            AsyncHttpProviderUtils.encodeAndAppendFormParam(sb, param.getName(), param.getValue());
        }
        sb.setLength(sb.length() - 1);
        return sb;
    }

    public static ByteBuffer urlEncodeFormParams(List<Param> params, Charset charset) {
        return StringUtils.charSequence2ByteBuffer(AsyncHttpProviderUtils.urlEncodeFormParams0(params), charset);
    }

    private static void encodeAndAppendFormParam(StringBuilder sb, CharSequence name, CharSequence value) {
        UTF8UrlEncoder.encodeAndAppendFormElement(sb, name);
        if (value != null) {
            sb.append('=');
            UTF8UrlEncoder.encodeAndAppendFormElement(sb, value);
        }
        sb.append('&');
    }

    public static String getNTLM(List<String> authenticateHeaders) {
        if (MiscUtils.isNonEmpty(authenticateHeaders)) {
            for (String authenticateHeader : authenticateHeaders) {
                if (!authenticateHeader.startsWith("NTLM")) continue;
                return authenticateHeader;
            }
        }
        return null;
    }

    public static boolean isWebSocket(String scheme) {
        return WEBSOCKET.equals(scheme) || WEBSOCKET_SSL.equalsIgnoreCase(scheme);
    }

    public static boolean isSecure(String scheme) {
        return HTTPS.equals(scheme) || WEBSOCKET_SSL.equals(scheme);
    }

    public static boolean isSecure(Uri uri) {
        return AsyncHttpProviderUtils.isSecure(uri.getScheme());
    }

    public static boolean useProxyConnect(Uri uri) {
        return AsyncHttpProviderUtils.isSecure(uri) || AsyncHttpProviderUtils.isWebSocket(uri.getScheme());
    }

    static {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            new ObjectOutputStream(buffer).writeObject(REMOTELY_CLOSED_EXCEPTION);
            REMOTELY_CLOSED_EXCEPTION = (IOException)new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray())).readObject();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception on cleaning Remotely Closed Exception backtrace", e);
        }
        DEFAULT_CHARSET = StandardCharsets.ISO_8859_1;
        EMPTY_BYTE_ARRAY = "".getBytes();
    }
}

