/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.metadata;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.InputStream;
import java.io.Reader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Proxy;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.el.ExpressionFunction;
import org.mule.runtime.api.metadata.CollectionDataType;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.DataTypeBuilder;
import org.mule.runtime.api.metadata.DataTypeParamsBuilder;
import org.mule.runtime.api.metadata.FunctionDataType;
import org.mule.runtime.api.metadata.FunctionParameter;
import org.mule.runtime.api.metadata.MapDataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.message.OutputHandler;
import org.mule.runtime.core.internal.util.generics.GenericsUtils;
import org.mule.runtime.core.privileged.metadata.DefaultCollectionDataType;
import org.mule.runtime.core.privileged.metadata.DefaultFunctionDataType;
import org.mule.runtime.core.privileged.metadata.DefaultMapDataType;
import org.mule.runtime.core.privileged.metadata.SimpleDataType;

public class DefaultDataTypeBuilder
implements DataTypeBuilder,
DataTypeBuilder.DataTypeCollectionTypeBuilder,
DataTypeBuilder.DataTypeFunctionTypeBuilder,
DataTypeBuilder.DataTypeMapTypeBuilder {
    private static final String DYNAMIC_CLASS_BUILDER_MATCH = "$ByteBuddy$";
    private static ConcurrentHashMap<String, ProxyIndicator> proxyClassCache = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, ProxyIndicator> dynamicClassCache = new ConcurrentHashMap();
    private static LoadingCache<DefaultDataTypeBuilder, DataType> dataTypeCache = Caffeine.newBuilder().weakValues().build(key -> key.doBuild());
    private Reference<Class<?>> typeRef = new WeakReference<Class<Object>>(Object.class);
    private DataTypeBuilder itemTypeBuilder;
    private MediaType mediaType = MediaType.ANY;
    private DataType returnType;
    private List<FunctionParameter> parametersType;
    private DataTypeBuilder keyTypeBuilder;
    private DataTypeBuilder valueTypeBuilder;
    private DataType keyType = DataType.OBJECT;
    private DataType itemType = DataType.OBJECT;
    private DataType valueType = DataType.OBJECT;
    private DataType original = DataType.OBJECT;
    private boolean mutated = false;
    private boolean built = false;
    private static final List<Class<?>> consumableClasses = new ArrayList();

    public DefaultDataTypeBuilder() {
    }

    public DefaultDataTypeBuilder(DataType dataType) {
        this.original = dataType;
        if (dataType instanceof CollectionDataType) {
            this.typeRef = new WeakReference<Class>(dataType.getType());
            this.itemTypeBuilder = DataType.builder((DataType)((CollectionDataType)dataType).getItemDataType());
        } else if (dataType instanceof MapDataType) {
            this.typeRef = new WeakReference<Class>(dataType.getType());
            this.keyTypeBuilder = DataType.builder((DataType)((MapDataType)dataType).getKeyDataType());
            this.valueTypeBuilder = DataType.builder((DataType)((MapDataType)dataType).getValueDataType());
        } else if (dataType instanceof FunctionDataType) {
            this.typeRef = new WeakReference<Class>(dataType.getType());
            Optional returnType = ((FunctionDataType)dataType).getReturnType();
            if (returnType.isPresent()) {
                this.returnType = (DataType)returnType.get();
            }
            this.parametersType = ((FunctionDataType)dataType).getParameters();
        } else {
            this.typeRef = new WeakReference<Class>(dataType.getType());
        }
        this.mediaType = dataType.getMediaType();
    }

    public DataTypeParamsBuilder type(Class<?> type) {
        this.validateAlreadyBuilt();
        Objects.requireNonNull(type, "'type' cannot be null.");
        this.typeRef = new WeakReference(this.handleProxy(type));
        this.mutated = true;
        return this;
    }

    protected Class<?> handleProxy(Class<?> type) {
        if (DefaultDataTypeBuilder.isProxyClass(type)) {
            return type.getInterfaces()[0];
        }
        if (DefaultDataTypeBuilder.isDynamicallyBuiltClass(type)) {
            return type.getSuperclass().equals(Object.class) ? type.getInterfaces()[0] : type.getSuperclass();
        }
        return type;
    }

    protected static <T> boolean isProxyClass(Class<T> type) {
        String typeName = type.getName();
        ProxyIndicator indicator = proxyClassCache.get(typeName);
        if (indicator != null) {
            Class classInMap = indicator.getTargetClass();
            if (classInMap == type) {
                return indicator.isProxy();
            }
            if (classInMap != null) {
                return Proxy.isProxyClass(type);
            }
        }
        boolean isProxy = Proxy.isProxyClass(type);
        proxyClassCache.put(typeName, new ProxyIndicator(type, isProxy));
        return isProxy;
    }

    protected static <T> boolean isDynamicallyBuiltClass(Class<T> type) {
        String typeName = type.getName();
        ProxyIndicator indicator = dynamicClassCache.get(typeName);
        if (indicator != null) {
            Class classInMap = indicator.getTargetClass();
            if (classInMap == type) {
                return indicator.isProxy();
            }
            if (classInMap != null) {
                return type.getName().contains(DYNAMIC_CLASS_BUILDER_MATCH);
            }
        }
        boolean isProxy = type.getName().contains(DYNAMIC_CLASS_BUILDER_MATCH);
        dynamicClassCache.put(typeName, new ProxyIndicator(type, isProxy));
        return isProxy;
    }

    public DataTypeBuilder.DataTypeCollectionTypeBuilder streamType(Class<? extends Iterator> iteratorType) {
        this.validateAlreadyBuilt();
        Objects.requireNonNull(iteratorType, "'iteratorType' cannot be null.");
        if (!Iterator.class.isAssignableFrom(iteratorType)) {
            throw new IllegalArgumentException("iteratorType " + iteratorType.getName() + " is not an Iterator type");
        }
        this.typeRef = new WeakReference(this.handleProxy(iteratorType));
        if (this.itemTypeBuilder == null) {
            this.itemTypeBuilder = DataType.builder();
        }
        return this.asCollectionTypeBuilder();
    }

    public DataTypeBuilder.DataTypeCollectionTypeBuilder collectionType(Class<? extends Collection> collectionType) {
        Class<?> itemType;
        this.validateAlreadyBuilt();
        Objects.requireNonNull(collectionType, "'collectionType' cannot be null.");
        if (!Collection.class.isAssignableFrom(collectionType)) {
            throw new IllegalArgumentException("collectionType " + collectionType.getName() + " is not a Collection type");
        }
        this.typeRef = new WeakReference(this.handleProxy(collectionType));
        if (this.itemTypeBuilder == null) {
            this.itemTypeBuilder = DataType.builder();
        }
        if ((itemType = GenericsUtils.getCollectionType(this.typeRef.get())) != null) {
            this.itemTypeBuilder.type(itemType);
        }
        return this.asCollectionTypeBuilder();
    }

    public DataTypeBuilder.DataTypeCollectionTypeBuilder asCollectionTypeBuilder() {
        this.mutated = true;
        return this;
    }

    public DataTypeBuilder.DataTypeFunctionTypeBuilder functionType(Class<? extends ExpressionFunction> functionType) {
        this.validateAlreadyBuilt();
        Objects.requireNonNull(functionType, "'functionType' cannot be null.");
        if (!ExpressionFunction.class.isAssignableFrom(functionType)) {
            throw new IllegalArgumentException("functionType " + functionType.getName() + " is not an ExpressionFunction type");
        }
        this.typeRef = new WeakReference(this.handleProxy(functionType));
        return this.asFunctionTypeBuilder();
    }

    public DataTypeBuilder.DataTypeFunctionTypeBuilder asFunctionTypeBuilder() {
        this.mutated = true;
        return this;
    }

    public DataTypeBuilder.DataTypeMapTypeBuilder mapType(Class<? extends Map> mapType) {
        Class<?> valueType;
        Class<?> keyType;
        this.validateAlreadyBuilt();
        Objects.requireNonNull(mapType, "'mapType' cannot be null.");
        if (!Map.class.isAssignableFrom(mapType)) {
            throw new IllegalArgumentException("mapType " + mapType.getName() + " is not a Map type");
        }
        this.typeRef = new WeakReference(this.handleProxy(mapType));
        if (this.keyTypeBuilder == null) {
            this.keyTypeBuilder = DataType.builder();
        }
        if ((keyType = GenericsUtils.getMapKeyType(this.typeRef.get())) != null) {
            this.keyTypeBuilder.type(keyType);
        }
        if (this.valueTypeBuilder == null) {
            this.valueTypeBuilder = DataType.builder();
        }
        if ((valueType = GenericsUtils.getMapValueType(this.typeRef.get())) != null) {
            this.valueTypeBuilder.type(valueType);
        }
        return this.asMapTypeBuilder();
    }

    public DataTypeBuilder.DataTypeMapTypeBuilder asMapTypeBuilder() {
        this.mutated = true;
        return this;
    }

    public DataTypeBuilder.DataTypeCollectionTypeBuilder itemType(Class<?> itemType) {
        this.validateAlreadyBuilt();
        Objects.requireNonNull(itemType, "'itemTypeBuilder' cannot be null.");
        if (this.itemTypeBuilder == null) {
            this.itemTypeBuilder = DataType.builder();
        }
        this.itemTypeBuilder.type(this.handleProxy(itemType));
        this.mutated = true;
        return this;
    }

    public DataTypeBuilder.DataTypeFunctionTypeBuilder returnType(DataType dataType) {
        this.returnType = dataType;
        this.mutated = true;
        return this;
    }

    public DataTypeBuilder.DataTypeFunctionTypeBuilder parametersType(List<FunctionParameter> list) {
        this.parametersType = list;
        this.mutated = true;
        return this;
    }

    public DataTypeBuilder.DataTypeMapTypeBuilder keyType(Class<?> keyType) {
        this.validateAlreadyBuilt();
        Objects.requireNonNull(keyType, "'keyType' cannot be null.");
        if (this.keyTypeBuilder == null) {
            this.keyTypeBuilder = DataType.builder();
        }
        this.keyTypeBuilder.type(this.handleProxy(keyType));
        this.mutated = true;
        return this;
    }

    public DataTypeBuilder.DataTypeMapTypeBuilder valueType(Class<?> valueType) {
        this.validateAlreadyBuilt();
        Objects.requireNonNull(valueType, "'valueType' cannot be null.");
        if (this.valueTypeBuilder == null) {
            this.valueTypeBuilder = DataType.builder();
        }
        this.valueTypeBuilder.type(this.handleProxy(valueType));
        this.mutated = true;
        return this;
    }

    public DataTypeBuilder mediaType(String mediaType) {
        Objects.requireNonNull(mediaType);
        this.validateAlreadyBuilt();
        this.mediaType = MediaType.parse((String)mediaType);
        this.mutated = true;
        return this;
    }

    public DataTypeBuilder mediaType(MediaType mediaType) {
        Objects.requireNonNull(mediaType);
        this.validateAlreadyBuilt();
        this.mediaType = mediaType;
        this.mutated = true;
        return this;
    }

    public DataTypeBuilder.DataTypeCollectionTypeBuilder itemMediaType(String itemMimeType) {
        this.validateAlreadyBuilt();
        this.itemTypeBuilder.mediaType(itemMimeType);
        this.mutated = true;
        return this;
    }

    public DataTypeBuilder.DataTypeCollectionTypeBuilder itemMediaType(MediaType itemMediaType) {
        this.validateAlreadyBuilt();
        this.itemTypeBuilder.mediaType(itemMediaType);
        this.mutated = true;
        return this;
    }

    public DataTypeBuilder.DataTypeMapTypeBuilder keyMediaType(String keyMediaType) {
        this.validateAlreadyBuilt();
        this.keyTypeBuilder.mediaType(keyMediaType);
        this.mutated = true;
        return this;
    }

    public DataTypeBuilder.DataTypeMapTypeBuilder keyMediaType(MediaType keyMediaType) {
        this.validateAlreadyBuilt();
        this.keyTypeBuilder.mediaType(keyMediaType);
        this.mutated = true;
        return this;
    }

    public DataTypeBuilder.DataTypeMapTypeBuilder valueMediaType(String valueMediaType) {
        this.validateAlreadyBuilt();
        this.valueTypeBuilder.mediaType(valueMediaType);
        this.mutated = true;
        return this;
    }

    public DataTypeBuilder.DataTypeMapTypeBuilder valueMediaType(MediaType valueMediaType) {
        this.validateAlreadyBuilt();
        this.valueTypeBuilder.mediaType(valueMediaType);
        this.mutated = true;
        return this;
    }

    public DataTypeBuilder charset(String charset) {
        this.validateAlreadyBuilt();
        this.mediaType = !StringUtils.isEmpty((CharSequence)charset) ? this.mediaType.withCharset(Charset.forName(charset)) : this.mediaType.withCharset(null);
        this.mutated = true;
        return this;
    }

    public DataTypeBuilder charset(Charset charset) {
        this.validateAlreadyBuilt();
        this.mediaType = this.mediaType.withCharset(charset);
        this.mutated = true;
        return this;
    }

    public DataTypeParamsBuilder fromObject(Object value) {
        this.validateAlreadyBuilt();
        if (value == null) {
            return this.type(Object.class);
        }
        return this.type(value.getClass());
    }

    public DataTypeBuilder.DataTypeFunctionTypeBuilder fromFunction(ExpressionFunction expressionFunction) {
        return this.functionType(expressionFunction.getClass()).returnType((DataType)expressionFunction.returnType().orElse(null)).parametersType(expressionFunction.parameters());
    }

    public DataType build() {
        if (this.built) {
            this.throwAlreadyBuilt();
        }
        if (!this.mutated) {
            return this.original;
        }
        this.built = true;
        Class<?> type = this.typeRef.get();
        if (ExpressionFunction.class.isAssignableFrom(type)) {
            return new DefaultFunctionDataType(type, this.returnType, this.parametersType != null ? this.parametersType : Collections.emptyList(), this.mediaType, DefaultDataTypeBuilder.isConsumable(type));
        }
        if (this.keyTypeBuilder != null) {
            this.keyType = this.keyTypeBuilder.build();
        }
        if (this.itemTypeBuilder != null) {
            this.itemType = this.itemTypeBuilder.build();
        }
        if (this.valueTypeBuilder != null) {
            this.valueType = this.valueTypeBuilder.build();
        }
        return (DataType)dataTypeCache.get((Object)this);
    }

    protected DataType doBuild() {
        Class<?> type = this.typeRef.get();
        if (Collection.class.isAssignableFrom(type) || Iterator.class.isAssignableFrom(type)) {
            return new DefaultCollectionDataType(type, this.itemType, this.mediaType, DefaultDataTypeBuilder.isConsumable(type));
        }
        if (Map.class.isAssignableFrom(type)) {
            return new DefaultMapDataType(type, this.keyType, this.valueType, this.mediaType, DefaultDataTypeBuilder.isConsumable(type));
        }
        return new SimpleDataType(type, this.mediaType, DefaultDataTypeBuilder.isConsumable(type));
    }

    protected void validateAlreadyBuilt() {
        if (this.built) {
            this.throwAlreadyBuilt();
        }
    }

    protected void throwAlreadyBuilt() {
        throw new IllegalStateException("DataType was already built from this builder. Reusing builder instances is not allowed.");
    }

    public int hashCode() {
        return Objects.hash(this.typeRef.get(), this.itemTypeBuilder, this.keyTypeBuilder, this.valueTypeBuilder, this.returnType, this.parametersType, this.mediaType);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultDataTypeBuilder other = (DefaultDataTypeBuilder)obj;
        return Objects.equals(this.typeRef.get(), other.typeRef.get()) && Objects.equals(this.itemTypeBuilder, other.itemTypeBuilder) && Objects.equals(this.keyTypeBuilder, other.keyTypeBuilder) && Objects.equals(this.valueTypeBuilder, other.valueTypeBuilder) && Objects.equals(this.returnType, other.returnType) && Objects.equals(this.parametersType, other.parametersType) && Objects.equals(this.mediaType, other.mediaType);
    }

    private static void addToConsumableClasses(String className) {
        try {
            consumableClasses.add(Class.forName(className, true, Thread.currentThread().getContextClassLoader()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static boolean isConsumable(Class<?> payloadClass) {
        if (consumableClasses.isEmpty()) {
            return false;
        }
        for (Class<?> c : consumableClasses) {
            if (!c.isAssignableFrom(payloadClass)) continue;
            return true;
        }
        return false;
    }

    static {
        DefaultDataTypeBuilder.addToConsumableClasses("javax.xml.stream.XMLStreamReader");
        DefaultDataTypeBuilder.addToConsumableClasses("javax.xml.transform.stream.StreamSource");
        consumableClasses.add(OutputHandler.class);
        consumableClasses.add(InputStream.class);
        consumableClasses.add(Reader.class);
        consumableClasses.add(Iterator.class);
    }

    private static final class ProxyIndicator {
        private final WeakReference<Class> targetClassRef;
        private final boolean isProxy;

        ProxyIndicator(Class targetClass, boolean proxy) {
            this.targetClassRef = new WeakReference<Class>(targetClass);
            this.isProxy = proxy;
        }

        public Class getTargetClass() {
            return (Class)this.targetClassRef.get();
        }

        public boolean isProxy() {
            return this.isProxy;
        }
    }
}

