/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.core.json.reader.memory;

import java.io.Serializable;
import org.mule.weave.v2.core.exception.InvalidNumberExpressionException;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.ArraySeq$;
import org.mule.weave.v2.model.structure.KeyValuePair;
import org.mule.weave.v2.model.structure.KeyValuePair$;
import org.mule.weave.v2.model.structure.ObjectSeq$;
import org.mule.weave.v2.model.values.ArrayValue;
import org.mule.weave.v2.model.values.BooleanValue$;
import org.mule.weave.v2.model.values.KeyValue$;
import org.mule.weave.v2.model.values.NullValue$;
import org.mule.weave.v2.model.values.NumberValue$;
import org.mule.weave.v2.model.values.ObjectValue;
import org.mule.weave.v2.model.values.StringValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.model.values.math.Number;
import org.mule.weave.v2.model.values.math.Number$;
import org.mule.weave.v2.module.core.json.reader.JsonSettings;
import org.mule.weave.v2.module.core.json.reader.JsonTokenizer;
import org.mule.weave.v2.module.core.json.reader.indexed.JsonLocation;
import org.mule.weave.v2.module.core.json.reader.indexed.JsonNumberFormatException;
import org.mule.weave.v2.module.core.json.reader.memory.InMemoryJsonArray;
import org.mule.weave.v2.module.core.json.reader.memory.InMemoryJsonObject;
import org.mule.weave.v2.module.core.json.reader.memory.InMemoryJsonParser$;
import org.mule.weave.v2.module.core.json.reader.memory.LazyJsonKeyValuePairIterator;
import org.mule.weave.v2.module.core.json.reader.memory.LazyJsonObjectValue$;
import org.mule.weave.v2.module.core.json.reader.memory.StreamingJsonArrayValue$;
import org.mule.weave.v2.module.core.json.reader.memory.StreamingJsonValueIterator$;
import org.mule.weave.v2.module.reader.SourceReader;
import org.mule.weave.v2.parser.location.DefaultLocationCapable$;
import org.mule.weave.v2.parser.location.Location;
import org.mule.weave.v2.parser.location.LocationCapable;
import scala.Function0;
import scala.Option;
import scala.collection.mutable.ArrayBuffer;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\t5a\u0001B\u0011#\u0001UB\u0001\u0002\u0011\u0001\u0003\u0006\u0004%\t%\u0011\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u0005\"Aa\n\u0001BC\u0002\u0013\u0005s\n\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003Q\u0011!1\u0006A!b\u0001\n\u00039\u0006\u0002C.\u0001\u0005\u0003\u0005\u000b\u0011\u0002-\t\u0011q\u0003!\u0011!Q\u0001\fuCQa\u0019\u0001\u0005\u0002\u0011DQ\u0001\u001c\u0001\u0005\u00025DQA\u001c\u0001\u0005\u0002=Dq!!\u0002\u0001\t\u0003\t9\u0001C\u0004\u0002\u0014\u0001!\t!!\u0006\t\u000f\u0005\u0005\u0002\u0001\"\u0003\u0002$!9\u0011\u0011\n\u0001\u0005\n\u0005-\u0003bBA-\u0001\u0011%\u00111\f\u0005\b\u0003K\u0002A\u0011BA4\u0011\u001d\tY\u0007\u0001C\u0005\u0003[Bq!!\u001d\u0001\t\u0013\t\u0019\bC\u0004\u0002x\u0001!)\"!\u001f\t\u000f\u0005-\u0005\u0001\"\u0005\u0002\u000e\"9\u0011\u0011\u0013\u0001\u0005\n\u0005M\u0005bBAL\u0001\u0011%\u0011\u0011\u0014\u0005\b\u0003C\u0003A\u0011BAR\u0011\u001d\t\u0019\r\u0001C\u0005\u0003\u000bDq!!4\u0001\t\u0013\ty\r\u0003\u0004\u0002f\u0002!\t!\u001c\u0005\b\u0003O\u0004A\u0011AAu\u0011\u001d\ti\u000f\u0001C\u0001\u0003_<\u0011\"!=#\u0003\u0003E\t!a=\u0007\u0011\u0005\u0012\u0013\u0011!E\u0001\u0003kDaa\u0019\u0010\u0005\u0002\u0005]\b\"CA}=E\u0005I\u0011AA~\u0005IIe.T3n_JL(j]8o!\u0006\u00148/\u001a:\u000b\u0005\r\"\u0013AB7f[>\u0014\u0018P\u0003\u0002&M\u00051!/Z1eKJT!a\n\u0015\u0002\t)\u001cxN\u001c\u0006\u0003S)\nAaY8sK*\u00111\u0006L\u0001\u0007[>$W\u000f\\3\u000b\u00055r\u0013A\u0001<3\u0015\ty\u0003'A\u0003xK\u00064XM\u0003\u00022e\u0005!Q.\u001e7f\u0015\u0005\u0019\u0014aA8sO\u000e\u00011c\u0001\u00017yA\u0011qGO\u0007\u0002q)\t\u0011(A\u0003tG\u0006d\u0017-\u0003\u0002<q\t1\u0011I\\=SK\u001a\u0004\"!\u0010 \u000e\u0003\u0011J!a\u0010\u0013\u0003\u001b)\u001bxN\u001c+pW\u0016t\u0017N_3s\u0003\u0011q\u0017-\\3\u0016\u0003\t\u0003\"a\u0011&\u000f\u0005\u0011C\u0005CA#9\u001b\u00051%BA$5\u0003\u0019a$o\\8u}%\u0011\u0011\nO\u0001\u0007!J,G-\u001a4\n\u0005-c%AB*ue&twM\u0003\u0002Jq\u0005)a.Y7fA\u0005)\u0011N\u001c9viV\t\u0001\u000b\u0005\u0002R'6\t!K\u0003\u0002&U%\u0011AK\u0015\u0002\r'>,(oY3SK\u0006$WM]\u0001\u0007S:\u0004X\u000f\u001e\u0011\u0002\u0011M,G\u000f^5oON,\u0012\u0001\u0017\t\u0003{eK!A\u0017\u0013\u0003\u0019)\u001bxN\\*fiRLgnZ:\u0002\u0013M,G\u000f^5oON\u0004\u0013aA2uqB\u0011a,Y\u0007\u0002?*\u0011\u0001\rL\u0001\u0006[>$W\r\\\u0005\u0003E~\u0013\u0011#\u0012<bYV\fG/[8o\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Q!Q-\u001b6l)\t1\u0007\u000e\u0005\u0002h\u00015\t!\u0005C\u0003]\u0011\u0001\u000fQ\fC\u0003A\u0011\u0001\u0007!\tC\u0003O\u0011\u0001\u0007\u0001\u000bC\u0004W\u0011A\u0005\t\u0019\u0001-\u0002\u0015I,\u0017\rZ*ue&tw\rF\u0001C\u0003i\u0011X\r\u001e:jKZ,g*\u001a=u'R\u0014X-Y7j]\u001e4\u0016\r\\;f)\u0005\u0001\bGA9z!\r\u0011Xo^\u0007\u0002g*\u0011AoX\u0001\u0007m\u0006dW/Z:\n\u0005Y\u001c(!\u0002,bYV,\u0007C\u0001=z\u0019\u0001!\u0011B\u001f\u0006\u0002\u0002\u0003\u0005)\u0011A>\u0003\u0007}#\u0013'\u0005\u0002}\u007fB\u0011q'`\u0005\u0003}b\u0012qAT8uQ&tw\rE\u00028\u0003\u0003I1!a\u00019\u0005\r\te._\u0001\u0006a\u0006\u00148/\u001a\u000b\u0003\u0003\u0013\u0001D!a\u0003\u0002\u0010A!!/^A\u0007!\rA\u0018q\u0002\u0003\u000b\u0003#Y\u0011\u0011!A\u0001\u0006\u0003Y(aA0%e\u0005\t\"/\u001a;sS\u00164XMT3yiZ\u000bG.^3\u0015\u0005\u0005]\u0001\u0007BA\r\u0003;\u0001BA];\u0002\u001cA\u0019\u00010!\b\u0005\u0015\u0005}A\"!A\u0001\u0002\u000b\u00051PA\u0002`IM\n!a\u00195\u0015\r\u0005\u0015\u00121FA\u001b!\r9\u0014qE\u0005\u0004\u0003SA$a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003[i\u0001\u0019AA\u0018\u0003\u0005\u0019\u0007cA\u001c\u00022%\u0019\u00111\u0007\u001d\u0003\t\rC\u0017M\u001d\u0005\b\u0003oi\u0001\u0019AA\u001d\u0003\u001d\u0011W/\u001b7eKJ\u0004B!a\u000f\u0002F5\u0011\u0011Q\b\u0006\u0005\u0003\u007f\t\t%\u0001\u0003mC:<'BAA\"\u0003\u0011Q\u0017M^1\n\t\u0005\u001d\u0013Q\b\u0002\u000e'R\u0014\u0018N\\4Ck&dG-\u001a:\u0002\u0015I,\u0017\r\u001a(v[\n,'\u000f\u0006\u0002\u0002NA!\u0011qJA+\u001b\t\t\tFC\u0002\u0002TM\fA!\\1uQ&!\u0011qKA)\u0005\u0019qU/\u001c2fe\u00069!/Z1e\u0013:$H\u0003BA/\u0003G\u00022aNA0\u0013\r\t\t\u0007\u000f\u0002\u0005+:LG\u000fC\u0004\u00028=\u0001\r!!\u000f\u0002\u0011I,\u0017\r\u001a$sC\u000e$B!!\n\u0002j!9\u0011q\u0007\tA\u0002\u0005e\u0012a\u0002:fC\u0012,\u0005\u0010\u001d\u000b\u0005\u0003K\ty\u0007C\u0004\u00028E\u0001\r!!\u000f\u0002'I,\u0017\rZ(oK>\u0013Xj\u001c:f\t&<\u0017\u000e^:\u0015\t\u0005u\u0013Q\u000f\u0005\b\u0003o\u0011\u0002\u0019AA\u001d\u0003Q\u0011X-\u00193[KJ|wJ]'pe\u0016$\u0015nZ5ugR!\u0011QLA>\u0011\u001d\t9d\u0005a\u0001\u0003sA3aEA@!\u0011\t\t)a\"\u000e\u0005\u0005\r%bAACq\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005%\u00151\u0011\u0002\bi\u0006LGN]3d\u0003%\u0011X-\u00193ES\u001eLG\u000f\u0006\u0003\u0002&\u0005=\u0005bBA\u001c)\u0001\u0007\u0011\u0011H\u0001\bC\u00124\u0018M\\2f)\u0011\t)#!&\t\u000f\u0005]R\u00031\u0001\u0002:\u0005i!/\u001a;sS\u00164X-\u0011:sCf$\"!a'\u0011\u0007I\fi*C\u0002\u0002 N\u0014!\"\u0011:sCf4\u0016\r\\;f\u0003A\u0011X-\u00193BeJ\f\u00170T3nE\u0016\u00148\u000f\u0006\u0003\u0002^\u0005\u0015\u0006B\u0002;\u0018\u0001\u0004\t9\u000b\u0005\u0004\u0002*\u0006M\u0016qW\u0007\u0003\u0003WSA!!,\u00020\u00069Q.\u001e;bE2,'bAAYq\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005U\u00161\u0016\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000f\r\u0003\u0002:\u0006u\u0006\u0003\u0002:v\u0003w\u00032\u0001_A_\t-\ty,!*\u0002\u0002\u0003\u0005)\u0011A>\u0003\u0007}#S\u0007K\u0002\u0018\u0003\u007f\naB]3ue&,g/Z(cU\u0016\u001cG\u000f\u0006\u0002\u0002HB\u0019!/!3\n\u0007\u0005-7OA\u0006PE*,7\r\u001e,bYV,\u0017!\u0005:fC\u0012|%M[3di6+WNY3sgR!\u0011QLAi\u0011\u001d\t\u0019.\u0007a\u0001\u0003+\fAa\u001b<qgB1\u0011\u0011VAZ\u0003/\u0004B!!7\u0002`6\u0011\u00111\u001c\u0006\u0004\u0003;|\u0016!C:ueV\u001cG/\u001e:f\u0013\u0011\t\t/a7\u0003\u0019-+\u0017PV1mk\u0016\u0004\u0016-\u001b:)\u0007e\ty(A\u0004sK\u0006$7*Z=\u0002)\u0005\u0004\b/\u001a8e\u0007\"\f'/\u00118e\u0003\u00124\u0018M\\2f)\u0011\t)#a;\t\u000f\u0005]2\u00041\u0001\u0002:\u0005Y1-\u00198SK\u0006$7\t[1s+\t\t)#\u0001\nJ]6+Wn\u001c:z\u0015N|g\u000eU1sg\u0016\u0014\bCA4\u001f'\tqb\u0007\u0006\u0002\u0002t\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\"!!@+\u0007a\u000byp\u000b\u0002\u0003\u0002A!!1\u0001B\u0005\u001b\t\u0011)A\u0003\u0003\u0003\b\u0005\r\u0015!C;oG\",7m[3e\u0013\u0011\u0011YA!\u0002\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class InMemoryJsonParser
implements JsonTokenizer {
    private final String name;
    private final SourceReader input;
    private final JsonSettings settings;
    private final EvaluationContext ctx;
    private long cursorCharLocation;
    private char cursorChar;
    private final char[] strBuffer;

    public static JsonSettings $lessinit$greater$default$3() {
        return InMemoryJsonParser$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public char currentChar() {
        return JsonTokenizer.currentChar$(this);
    }

    @Override
    public JsonLocation location() {
        return JsonTokenizer.location$(this);
    }

    @Override
    public String parseString() {
        return JsonTokenizer.parseString$(this);
    }

    @Override
    public boolean readChar() {
        return JsonTokenizer.readChar$(this);
    }

    @Override
    public void readEscapedChar(Option<scala.collection.mutable.StringBuilder> target) {
        JsonTokenizer.readEscapedChar$(this, target);
    }

    @Override
    public Option<scala.collection.mutable.StringBuilder> readEscapedChar$default$1() {
        return JsonTokenizer.readEscapedChar$default$1$(this);
    }

    @Override
    public void eof() {
        JsonTokenizer.eof$(this);
    }

    @Override
    public void requireFalse() {
        JsonTokenizer.requireFalse$(this);
    }

    @Override
    public void requireNull() {
        JsonTokenizer.requireNull$(this);
    }

    @Override
    public void requireTrue() {
        JsonTokenizer.requireTrue$(this);
    }

    @Override
    public boolean advance() {
        return JsonTokenizer.advance$(this);
    }

    @Override
    public boolean advanceChar() {
        return JsonTokenizer.advanceChar$(this);
    }

    @Override
    public boolean ws(char c) {
        return JsonTokenizer.ws$(this, c);
    }

    @Override
    public final void ws() {
        JsonTokenizer.ws$(this);
    }

    @Override
    public boolean advanceIf(char c) {
        return JsonTokenizer.advanceIf$(this, c);
    }

    @Override
    public void require(char c) {
        JsonTokenizer.require$(this, c);
    }

    @Override
    public boolean advanceCharIf(char c) {
        return JsonTokenizer.advanceCharIf$(this, c);
    }

    @Override
    public void requireChar(char c) {
        JsonTokenizer.requireChar$(this, c);
    }

    @Override
    public Nothing$ fail(String target, JsonLocation location, char errorChar) {
        return JsonTokenizer.fail$(this, target, location, errorChar);
    }

    @Override
    public JsonLocation fail$default$2() {
        return JsonTokenizer.fail$default$2$(this);
    }

    @Override
    public char fail$default$3() {
        return JsonTokenizer.fail$default$3$(this);
    }

    @Override
    public long cursorCharLocation() {
        return this.cursorCharLocation;
    }

    @Override
    public void cursorCharLocation_$eq(long x$1) {
        this.cursorCharLocation = x$1;
    }

    @Override
    public char cursorChar() {
        return this.cursorChar;
    }

    @Override
    public void cursorChar_$eq(char x$1) {
        this.cursorChar = x$1;
    }

    @Override
    public char[] strBuffer() {
        return this.strBuffer;
    }

    @Override
    public void org$mule$weave$v2$module$core$json$reader$JsonTokenizer$_setter_$strBuffer_$eq(char[] x$1) {
        this.strBuffer = x$1;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public SourceReader input() {
        return this.input;
    }

    public JsonSettings settings() {
        return this.settings;
    }

    public String readString() {
        this.requireChar('\"');
        String str = this.parseString();
        this.require('\"');
        return str;
    }

    public Value<?> retrieveNextStreamingValue() {
        this.ws();
        char c = this.cursorChar();
        switch (c) {
            case 'f': {
                this.requireFalse();
                return BooleanValue$.MODULE$.FALSE_BOOL();
            }
            case 't': {
                this.requireTrue();
                return BooleanValue$.MODULE$.TRUE_BOOL();
            }
            case 'n': {
                this.requireNull();
                return NullValue$.MODULE$;
            }
            case '{': {
                this.advance();
                JsonLocation jsonLocation = this.location();
                return LazyJsonObjectValue$.MODULE$.apply(new LazyJsonKeyValuePairIterator(this, this.ctx), DefaultLocationCapable$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> jsonLocation));
            }
            case '[': {
                this.advance();
                JsonLocation jsonLocation = this.location();
                return StreamingJsonArrayValue$.MODULE$.apply(StreamingJsonValueIterator$.MODULE$.apply(this), (LocationCapable)DefaultLocationCapable$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> jsonLocation));
            }
            case '\"': {
                JsonLocation jsonLocation = this.location();
                String str = this.readString();
                return StringValue$.MODULE$.apply(str, (LocationCapable)DefaultLocationCapable$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> jsonLocation));
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                JsonLocation jsonLocation = this.location();
                Number number = this.readNumber();
                return NumberValue$.MODULE$.apply(number, (LocationCapable)DefaultLocationCapable$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> jsonLocation), NumberValue$.MODULE$.apply$default$3());
            }
        }
        throw this.fail(new StringBuilder(59).append("false or true or null or {...} or [...] or number but was ").append(this.cursorChar()).append(".").toString(), this.location(), this.fail$default$3());
    }

    public Value<?> parse() {
        Value<?> value = this.retrieveNextValue();
        this.ws();
        this.eof();
        return value;
    }

    public Value<?> retrieveNextValue() {
        this.ws();
        char c = this.cursorChar();
        switch (c) {
            case 'f': {
                this.requireFalse();
                return BooleanValue$.MODULE$.FALSE_BOOL();
            }
            case 't': {
                this.requireTrue();
                return BooleanValue$.MODULE$.TRUE_BOOL();
            }
            case 'n': {
                this.requireNull();
                return NullValue$.MODULE$;
            }
            case '{': {
                return this.retrieveObject();
            }
            case '[': {
                return this.retrieveArray();
            }
            case '\"': {
                JsonLocation jsonLocation = this.location();
                String str = this.readString();
                return StringValue$.MODULE$.apply(str, (LocationCapable)DefaultLocationCapable$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> jsonLocation));
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                Number number = this.readNumber();
                JsonLocation jsonLocation = this.location();
                return NumberValue$.MODULE$.apply(number, (LocationCapable)DefaultLocationCapable$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> jsonLocation), NumberValue$.MODULE$.apply$default$3());
            }
        }
        throw this.fail(new StringBuilder(59).append("false or true or null or {...} or [...] or number but was ").append(this.cursorChar()).append(".").toString(), this.location(), this.fail$default$3());
    }

    private boolean ch(char c, StringBuilder builder) {
        boolean ret = this.advanceIf(c);
        Object object = ret ? builder.append(c) : BoxedUnit.UNIT;
        return ret;
    }

    private Number readNumber() {
        Number number;
        boolean bigDecimal = false;
        StringBuilder builder = new StringBuilder();
        this.ch('-', builder);
        this.readInt(builder);
        bigDecimal = this.readFrac(builder);
        if (this.readExp(builder)) {
            bigDecimal = false;
        }
        String numberStr = builder.toString();
        try {
            if (bigDecimal) {
                try {
                    number = Number$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(numberStr));
                }
                catch (Exception exception) {
                    number = Number$.MODULE$.apply(numberStr);
                }
            } else {
                number = Number$.MODULE$.apply(numberStr);
            }
        }
        catch (InvalidNumberExpressionException invalidNumberExpressionException) {
            throw new JsonNumberFormatException(numberStr, (Location)this.location());
        }
        return number;
    }

    private void readInt(StringBuilder builder) {
        if (!this.ch('0', builder)) {
            this.readOneOrMoreDigits(builder);
            return;
        }
    }

    private boolean readFrac(StringBuilder builder) {
        if (this.ch('.', builder)) {
            this.readOneOrMoreDigits(builder);
            return true;
        }
        return false;
    }

    private boolean readExp(StringBuilder builder) {
        if (this.ch('e', builder) || this.ch('E', builder)) {
            boolean bl = this.ch('-', builder) || this.ch('+', builder);
            this.readOneOrMoreDigits(builder);
            return true;
        }
        return false;
    }

    private void readOneOrMoreDigits(StringBuilder builder) {
        if (this.readDigit(builder)) {
            this.readZeroOrMoreDigits(builder);
            return;
        }
        throw this.fail("readDigit", this.fail$default$2(), this.fail$default$3());
    }

    public final void readZeroOrMoreDigits(StringBuilder builder) {
        while (this.readDigit(builder)) {
        }
    }

    public boolean readDigit(StringBuilder builder) {
        return this.cursorChar() >= '0' && this.cursorChar() <= '9' && this.advance(builder);
    }

    private boolean advance(StringBuilder builder) {
        builder.append(this.cursorChar());
        return this.advance();
    }

    private ArrayValue retrieveArray() {
        ArrayBuffer values = new ArrayBuffer();
        this.advance();
        this.ws();
        if (this.cursorChar() != ']') {
            this.readArrayMembers(values);
        }
        this.ws();
        this.require(']');
        return new InMemoryJsonArray(ArraySeq$.MODULE$.apply(values, true), (Location)this.location());
    }

    private void readArrayMembers(ArrayBuffer<Value<?>> values) {
        do {
            Value<?> value = this.retrieveNextValue();
            values.$plus$eq(value);
            this.ws();
        } while (this.ws(','));
    }

    private ObjectValue retrieveObject() {
        ArrayBuffer kvps = new ArrayBuffer();
        this.advance();
        this.ws();
        if (this.cursorChar() != '}') {
            this.readObjectMembers((ArrayBuffer<KeyValuePair>)kvps);
        }
        this.ws();
        this.require('}');
        return new InMemoryJsonObject(ObjectSeq$.MODULE$.apply(kvps, true), (Location)this.location());
    }

    private void readObjectMembers(ArrayBuffer<KeyValuePair> kvps) {
        do {
            String keyStr = this.readKey();
            Value<?> value = this.retrieveNextValue();
            kvps.$plus$eq((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply(keyStr), value, KeyValuePair$.MODULE$.apply$default$3(), KeyValuePair$.MODULE$.apply$default$4()));
            this.ws();
        } while (this.ws(','));
    }

    public String readKey() {
        String keyStr = this.readString();
        this.ws();
        this.require(':');
        return keyStr;
    }

    public boolean appendCharAndAdvance(StringBuilder builder) {
        builder.append(this.cursorChar());
        return this.advance();
    }

    public boolean canReadChar() {
        return (1L << this.cursorChar() & (long)(31 - this.cursorChar() >> 31) & 0x7FFFFFFBEFFFFFFFL) != 0L;
    }

    public InMemoryJsonParser(String name, SourceReader input, JsonSettings settings, EvaluationContext ctx) {
        this.name = name;
        this.input = input;
        this.settings = settings;
        this.ctx = ctx;
        JsonTokenizer.$init$(this);
    }
}

