/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.sdk;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import org.mule.weave.v2.parser.location.Position;
import org.mule.weave.v2.sdk.BinaryWeaveResource;
import org.mule.weave.v2.sdk.DefaultWeaveResource;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.sdk.WeaveResource$;
import org.mule.weave.v2.sdk.WeaveResourceFactory$;
import org.mule.weave.v2.utils.WeaveConstants$;
import scala.Function0;
import scala.Option;
import scala.io.BufferedSource;
import scala.io.Source$;

public final class WeaveResourceFactory$ {
    public static WeaveResourceFactory$ MODULE$;

    static {
        new WeaveResourceFactory$();
    }

    public WeaveResource fromContent(String content) {
        return this.fromContent("Unknown", content);
    }

    public WeaveResource fromContent(String url, String content) {
        return WeaveResource$.MODULE$.apply(url, content);
    }

    public BinaryWeaveResource fromBinaryInputStream(InputStream binaryContent, WeaveResource sourceWeaveResource) {
        BinaryWeaveResource binaryWeaveResource;
        try {
            binaryWeaveResource = new BinaryWeaveResource(binaryContent.readAllBytes(), sourceWeaveResource);
        }
        finally {
            if (binaryContent != null) {
                binaryContent.close();
            }
        }
        return binaryWeaveResource;
    }

    public BinaryWeaveResource fromBinaryFile(File binaryFile, WeaveResource sourceWeaveResource) {
        BinaryWeaveResource binaryWeaveResource;
        try (FileInputStream inputStream = new FileInputStream(binaryFile);){
            binaryWeaveResource = new BinaryWeaveResource(inputStream.readAllBytes(), sourceWeaveResource);
        }
        return binaryWeaveResource;
    }

    public WeaveResource fromFile(File file) {
        DefaultWeaveResource defaultWeaveResource;
        try (BufferedSource source = Source$.MODULE$.fromFile(file, WeaveConstants$.MODULE$.default_encoding());){
            defaultWeaveResource = WeaveResource$.MODULE$.apply(file.toURI().toURL().toExternalForm(), source.mkString());
        }
        return defaultWeaveResource;
    }

    public WeaveResource fromInputStream(String url, InputStream content) {
        DefaultWeaveResource defaultWeaveResource;
        try (BufferedSource source = Source$.MODULE$.fromInputStream(content, WeaveConstants$.MODULE$.default_encoding());){
            defaultWeaveResource = WeaveResource$.MODULE$.apply(url, source.mkString());
        }
        return defaultWeaveResource;
    }

    public WeaveResource fromUrl(URL url) {
        DefaultWeaveResource defaultWeaveResource;
        try (BufferedSource source = Source$.MODULE$.fromInputStream(url.openStream(), WeaveConstants$.MODULE$.default_encoding());){
            defaultWeaveResource = WeaveResource$.MODULE$.apply(url.toExternalForm(), source.mkString());
        }
        return defaultWeaveResource;
    }

    public WeaveResource lazyWeaveResource(String element, Function0<WeaveResource> weaveResourceProvider) {
        return new WeaveResource(weaveResourceProvider, element){
            private WeaveResource resolvedResource;
            private volatile boolean bitmap$0;
            private Function0 weaveResourceProvider$1;
            private final String element$1;

            public int offsetOf(int line, int column) {
                return WeaveResource.offsetOf$(this, line, column);
            }

            public Position positionOf(int offset) {
                return WeaveResource.positionOf$(this, offset);
            }

            public int lineNumberOf(int index) {
                return WeaveResource.lineNumberOf$(this, index);
            }

            public Option<Object> previousNonWSChar(int index) {
                return WeaveResource.previousNonWSChar$(this, index);
            }

            private WeaveResource resolvedResource$lzycompute() {
                anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if (!this.bitmap$0) {
                        this.resolvedResource = (WeaveResource)this.weaveResourceProvider$1.apply();
                        this.bitmap$0 = true;
                    }
                }
                this.weaveResourceProvider$1 = null;
                return this.resolvedResource;
            }

            private WeaveResource resolvedResource() {
                if (!this.bitmap$0) {
                    return this.resolvedResource$lzycompute();
                }
                return this.resolvedResource;
            }

            public String url() {
                return this.element$1;
            }

            public String content() {
                return this.resolvedResource().content();
            }
            {
                this.weaveResourceProvider$1 = weaveResourceProvider$1;
                this.element$1 = element$1;
                WeaveResource.$init$(this);
            }
        };
    }

    private WeaveResourceFactory$() {
        MODULE$ = this;
    }
}

