/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.stream.IntStream;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.ObjectComparator;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidatingVisitor;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.Visitor;
import org.json.JSONArray;

class ArraySchemaValidatingVisitor
extends Visitor {
    private final ValidatingVisitor owner;
    private JSONArray arraySubject;
    private ArraySchema arraySchema;
    private int subjectLength;

    public ArraySchemaValidatingVisitor(ValidatingVisitor owner) {
        this.owner = Objects.requireNonNull(owner, "owner cannot be null");
    }

    @Override
    void visitArraySchema(ArraySchema arraySchema) {
        this.owner.ifPassesTypeCheck(JSONArray.class, arraySchema.requiresArray(), arraySchema.isNullable(), arraySubject -> {
            this.arraySubject = arraySubject;
            this.subjectLength = arraySubject.length();
            this.arraySchema = arraySchema;
            super.visitArraySchema(arraySchema);
        });
    }

    @Override
    void visitMinItems(Integer minItems) {
        if (minItems != null && this.subjectLength < minItems) {
            this.owner.failure("expected minimum item count: " + minItems + ", found: " + this.subjectLength, "minItems");
        }
    }

    @Override
    void visitMaxItems(Integer maxItems) {
        if (maxItems != null && maxItems < this.subjectLength) {
            this.owner.failure("expected maximum item count: " + maxItems + ", found: " + this.subjectLength, "maxItems");
        }
    }

    @Override
    void visitUniqueItems(boolean uniqueItems) {
        if (!uniqueItems || this.subjectLength == 0) {
            return;
        }
        ArrayList<Object> uniques = new ArrayList<Object>(this.subjectLength);
        for (int i = 0; i < this.subjectLength; ++i) {
            Object item = this.arraySubject.get(i);
            for (Object e : uniques) {
                if (!ObjectComparator.deepEquals(e, item)) continue;
                this.owner.failure("array items are not unique", "uniqueItems");
                return;
            }
            uniques.add(item);
        }
    }

    @Override
    void visitAllItemSchema(Schema allItemSchema) {
        if (allItemSchema != null) {
            this.validateItemsAgainstSchema(IntStream.range(0, this.subjectLength), allItemSchema);
        }
    }

    @Override
    void visitItemSchema(int index, Schema itemSchema) {
        if (index >= this.subjectLength) {
            return;
        }
        Object subject = this.arraySubject.get(index);
        String idx = String.valueOf(index);
        this.ifFails(itemSchema, subject).map(exc -> exc.prepend(idx)).ifPresent(this.owner::failure);
    }

    @Override
    void visitAdditionalItems(boolean additionalItems) {
        int itemSchemaCount;
        List<Schema> itemSchemas = this.arraySchema.getItemSchemas();
        int n = itemSchemaCount = itemSchemas == null ? 0 : itemSchemas.size();
        if (itemSchemas != null && !additionalItems && this.subjectLength > itemSchemaCount) {
            this.owner.failure(String.format("expected: [%d] array items, found: [%d]", itemSchemaCount, this.subjectLength), "items");
        }
    }

    @Override
    void visitSchemaOfAdditionalItems(Schema schemaOfAdditionalItems) {
        if (schemaOfAdditionalItems == null || this.arraySchema.getItemSchemas() == null) {
            return;
        }
        int validationFrom = Math.min(this.subjectLength, this.arraySchema.getItemSchemas().size());
        this.validateItemsAgainstSchema(IntStream.range(validationFrom, this.subjectLength), schemaOfAdditionalItems);
    }

    private void validateItemsAgainstSchema(IntStream indices, Schema schema) {
        this.validateItemsAgainstSchema(indices, (int i) -> schema);
    }

    private void validateItemsAgainstSchema(IntStream indices, IntFunction<Schema> schemaForIndex) {
        for (int i : indices.toArray()) {
            String copyOfI = String.valueOf(i);
            this.ifFails(schemaForIndex.apply(i), this.arraySubject.get(i)).map(exc -> exc.prepend(copyOfI)).ifPresent(this.owner::failure);
        }
    }

    private Optional<ValidationException> ifFails(Schema schema, Object input) {
        return Optional.ofNullable(this.owner.getFailureOfSchema(schema, input));
    }

    @Override
    void visitContainedItemSchema(Schema containedItemSchema) {
        if (containedItemSchema == null) {
            return;
        }
        for (int i = 0; i < this.arraySubject.length(); ++i) {
            Optional<ValidationException> exception = this.ifFails(containedItemSchema, this.arraySubject.get(i));
            if (exception.isPresent()) continue;
            return;
        }
        this.owner.failure("expected at least one array item to match 'contains' schema", "contains");
    }
}

