/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.client;

import io.qameta.allure.Story;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.tcp.TcpClientSocketProperties;
import org.mule.service.http.test.common.AbstractHttpServiceTestCase;
import org.mule.service.http.test.netty.utils.TestUtils;
import org.mule.tck.junit5.DynamicPort;

@Story(value="Timeouts")
public class ClientTcpConnectionTimeoutTestCase
extends AbstractHttpServiceTestCase {
    private static final Integer CLIENT_CONNECTION_TIMEOUT_MILLIS = 1;
    @DynamicPort(systemProperty="tcpServerPort")
    Integer tcpServerPort;
    private HttpClient client;

    public ClientTcpConnectionTimeoutTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @BeforeEach
    void setup() {
        TcpClientSocketProperties withConnectionTimeout = TcpClientSocketProperties.builder().connectionTimeout(CLIENT_CONNECTION_TIMEOUT_MILLIS).build();
        HttpClientConfiguration clientConfig = new HttpClientConfiguration.Builder().setName("client-with-connection-timeout").setClientSocketProperties(withConnectionTimeout).build();
        this.client = this.service.getClientFactory().create(clientConfig);
        this.client.start();
    }

    @AfterEach
    void tearDown() {
        if (this.client != null) {
            this.client.stop();
        }
    }

    @EnabledOnOs(value={OS.MAC})
    @Test
    void clientTcpConnectionTimeout() throws Exception {
        try (ServerSocket serverSocket = new ServerSocket(this.tcpServerPort, 1);
             Socket auxClientSocket = new Socket("localhost", (int)this.tcpServerPort);){
            HttpRequest request = HttpRequest.builder().uri("http://localhost:" + this.tcpServerPort).build();
            long elapsedNanos = TestUtils.measuringNanoseconds(() -> {
                IOException error = (IOException)Assertions.assertThrows(IOException.class, () -> this.client.send(request));
                MatcherAssert.assertThat((Object)error, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)Matchers.anyOf((Matcher)Matchers.containsStringIgnoringCase((String)"timeout"), (Matcher)Matchers.containsStringIgnoringCase((String)"timed out"))));
            });
            long expectedTimeoutNanos = TimeUnit.MILLISECONDS.toNanos(CLIENT_CONNECTION_TIMEOUT_MILLIS.intValue());
            long toleranceNanos = TimeUnit.SECONDS.toNanos(1L);
            MatcherAssert.assertThat((Object)elapsedNanos, (Matcher)Matchers.lessThan((Comparable)Long.valueOf(expectedTimeoutNanos + toleranceNanos)));
        }
    }
}

