/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.http2;

import io.qameta.allure.Story;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.entity.FeedableHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.netty.impl.util.HttpResponseCreatorUtils;
import org.mule.service.http.test.common.AbstractHttpServiceTestCase;
import org.mule.service.http.test.common.http2.AbstractHttp2ClientServerTestCase;
import org.mule.service.http.test.common.http2.EchoLikeRequestHandler;

@Story(value="HTTP/2 Trailers")
class Http2TrailersTestCase
extends AbstractHttp2ClientServerTestCase {
    private static final String ECHO_PATH = "/echo";
    private static final String QUERY_PARAMS_TO_TRAILERS_PATH = "/query-params-to-trailers";
    private static final String TRAILER_NAME = "the-trailer";
    private static final String TRAILER_CLIENT_TO_SERVER = "client-to-server";
    private static final String TRAILER_SERVER_TO_CLIENT = "server-to-client";

    public Http2TrailersTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @BeforeEach
    void initRequestHandler() {
        this.server.addRequestHandler(ECHO_PATH, (RequestHandler)new EchoLikeRequestHandler()).start();
        this.server.addRequestHandler(QUERY_PARAMS_TO_TRAILERS_PATH, (requestContext, responseCallback) -> {
            FeedableHttpEntity feedableEntity = this.service.getEntityFactory().feedable();
            HttpResponse response = ((HttpResponseBuilder)HttpResponse.builder().statusCode(Integer.valueOf(200)).entity((HttpEntity)feedableEntity)).build();
            responseCallback.responseReady(response, (ResponseStatusCallback)new AbstractHttpServiceTestCase.IgnoreResponseStatusCallback());
            try {
                feedableEntity.completeWithTrailers(requestContext.getRequest().getQueryParams().toImmutableMultiMap());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).start();
    }

    @Test
    void trailersClientToServer() throws Exception {
        FeedableHttpEntity feedableEntity = this.service.getEntityFactory().feedable();
        HttpRequest request = ((HttpRequestBuilder)HttpRequest.builder().uri(this.urlForPath(this.server, ECHO_PATH)).entity((HttpEntity)feedableEntity)).build();
        CompletableFuture responseFuture = this.client.sendAsync(request);
        feedableEntity.completeWithTrailers(Http2TrailersTestCase.trailersFrom(TRAILER_NAME, TRAILER_CLIENT_TO_SERVER));
        HttpResponse response = (HttpResponse)responseFuture.get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)200));
        String bodyText = new String(response.getEntity().getBytes());
        MatcherAssert.assertThat((Object)bodyText, (Matcher)Matchers.containsString((String)Http2TrailersTestCase.multimapStringFor(TRAILER_NAME, TRAILER_CLIENT_TO_SERVER)));
    }

    @Test
    void trailersServerToClient() throws Exception {
        HttpRequest request = HttpRequest.builder().uri(this.urlForPath(this.server, "/query-params-to-trailers?the-trailer=server-to-client")).build();
        HttpResponse response = this.client.send(request);
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)200));
        MultiMap responseTrailers = (MultiMap)HttpResponseCreatorUtils.trailersAsFuture((HttpEntity)response.getEntity()).get();
        MatcherAssert.assertThat((Object)((String)responseTrailers.get((Object)TRAILER_NAME)), (Matcher)Matchers.is((Object)TRAILER_SERVER_TO_CLIENT));
    }

    private static MultiMap<String, String> trailersFrom(String name, String value) {
        MultiMap.StringMultiMap reqTrailers = new MultiMap.StringMultiMap();
        reqTrailers.put((Object)name, (Object)value);
        return reqTrailers;
    }

    private static String multimapStringFor(String name, String value) {
        return "trailers: MultiMap{[%s=[%s]]}".formatted(name, value);
    }
}

