/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.server;

import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mule.runtime.api.util.MultiMap;
import org.mule.service.http.netty.impl.server.NettyHttp2RequestAdapter;
import org.mule.service.http.test.common.AbstractHttpTestCase;

@Feature(value="HTTP/2 Support")
@Story(value="HTTP/2 Trailers")
class NettyHttp2RequestAdapterTestCase
extends AbstractHttpTestCase {
    private Http2HeadersFrame headersFrame;

    NettyHttp2RequestAdapterTestCase() {
    }

    @BeforeEach
    void setUp() {
        DefaultHttp2Headers headers = new DefaultHttp2Headers();
        headers.method((CharSequence)"POST");
        headers.path((CharSequence)"/some/path?queryParam=value");
        headers.scheme((CharSequence)"http");
        headers.add((Object)"content-length", (Object)"0");
        headers.add((Object)"x-header1", (Object)"value");
        headers.add((Object)"x-header2", List.of("value1", "value2"));
        this.headersFrame = new DefaultHttp2HeadersFrame((Http2Headers)headers);
    }

    @Test
    void methodComesFromThePseudoHeaders() {
        NettyHttp2RequestAdapter muleResponse = new NettyHttp2RequestAdapter(this.headersFrame);
        MatcherAssert.assertThat((Object)muleResponse.getMethod(), (Matcher)Matchers.is((Object)"POST"));
    }

    @Test
    void pathComesFromThePseudoHeaders() {
        NettyHttp2RequestAdapter muleResponse = new NettyHttp2RequestAdapter(this.headersFrame);
        MatcherAssert.assertThat((Object)muleResponse.getPath(), (Matcher)Matchers.is((Object)"/some/path"));
    }

    @Test
    void queryParametersComesFromThePseudoHeaders() {
        NettyHttp2RequestAdapter muleResponse = new NettyHttp2RequestAdapter(this.headersFrame);
        MultiMap queryParams = muleResponse.getQueryParams();
        MatcherAssert.assertThat((Object)((String)queryParams.get((Object)"queryParam")), (Matcher)Matchers.is((Object)"value"));
    }

    @Test
    void getHeadersIndividually() {
        NettyHttp2RequestAdapter muleResponse = new NettyHttp2RequestAdapter(this.headersFrame);
        MatcherAssert.assertThat((Object)muleResponse.getHeaderValue("content-length"), (Matcher)Matchers.is((Object)"0"));
        MatcherAssert.assertThat((Object)muleResponse.getHeaderValue("x-header1"), (Matcher)Matchers.is((Object)"value"));
        MatcherAssert.assertThat((Object)muleResponse.getHeaderValues("x-header2"), (Matcher)Matchers.contains((Object[])new String[]{"value1", "value2"}));
    }

    @Test
    void getAllHeaderNames() {
        NettyHttp2RequestAdapter muleResponse = new NettyHttp2RequestAdapter(this.headersFrame);
        MatcherAssert.assertThat((Object)muleResponse.getHeaderNames(), (Matcher)Matchers.contains((Object[])new String[]{"content-length", "x-header1", "x-header2"}));
    }

    @Test
    void getAllHeadersAsMultiMap() {
        NettyHttp2RequestAdapter muleResponse = new NettyHttp2RequestAdapter(this.headersFrame);
        MultiMap headers = muleResponse.getHeaders();
        MatcherAssert.assertThat((Object)((String)headers.get((Object)"content-length")), (Matcher)Matchers.is((Object)"0"));
        MatcherAssert.assertThat((Object)((String)headers.get((Object)"X-Header1")), (Matcher)Matchers.is((Object)"value"));
        MatcherAssert.assertThat((Object)headers.getAll((Object)"x-header2"), (Matcher)Matchers.contains((Object[])new String[]{"value1", "value2"}));
    }

    @Test
    void responseWithTrailers() throws IOException, ExecutionException, InterruptedException {
        NettyHttp2RequestAdapter muleResponse = new NettyHttp2RequestAdapter(this.headersFrame);
        CompletableFuture trailer1 = new CompletableFuture();
        CompletableFuture trailer2 = new CompletableFuture();
        muleResponse.getEntity().onComplete((trailers, throwable) -> {
            trailer1.complete((String)trailers.get((Object)"x-trailer1"));
            trailer2.complete((String)trailers.get((Object)"x-trailer2"));
        });
        muleResponse.addTrailer("x-trailer1", "value1");
        muleResponse.addTrailer("x-trailer2", "value2");
        muleResponse.finishEntityAndSetTrailers();
        MatcherAssert.assertThat((Object)((String)trailer1.get()), (Matcher)Matchers.is((Object)"value1"));
        MatcherAssert.assertThat((Object)((String)trailer2.get()), (Matcher)Matchers.is((Object)"value2"));
    }
}

