/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.internal.descriptor;

import java.util.Set;
import org.apache.commons.lang3.SystemUtils;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorCreateException;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorValidator;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupportedJvmArtifactDescriptorValidator
implements ArtifactDescriptorValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SupportedJvmArtifactDescriptorValidator.class);
    static final String DEPLOYABLE_ARTIFACT_JVM_ENFORCEMENT_PROPERTY = "mule.jvm.version.deployableArtifact.enforcement";
    static final String JVM_ENFORCEMENT_STRICT = "STRICT";
    static final String JVM_ENFORCEMENT_LOOSE = "LOOSE";
    static final String JVM_ENFORCEMENT_DISABLED = "DISABLED";
    private final String runningJdkVersion;
    private final String enforcementMode;

    public SupportedJvmArtifactDescriptorValidator() {
        this(SystemUtils.JAVA_SPECIFICATION_VERSION, System.getProperty(DEPLOYABLE_ARTIFACT_JVM_ENFORCEMENT_PROPERTY, JVM_ENFORCEMENT_STRICT));
    }

    SupportedJvmArtifactDescriptorValidator(String runningJdkVersion, String enforcementMode) {
        this.runningJdkVersion = runningJdkVersion;
        this.enforcementMode = enforcementMode;
    }

    @Override
    public void validate(ArtifactDescriptor descriptor) {
        if (descriptor instanceof DeployableArtifactDescriptor) {
            Set<String> supportedJavaVersions = ((DeployableArtifactDescriptor)descriptor).getSupportedJavaVersions();
            if (supportedJavaVersions.isEmpty() || supportedJavaVersions.contains(this.runningJdkVersion)) {
                return;
            }
            String errorMessage = this.getErrorMessageFor(descriptor, this.runningJdkVersion, supportedJavaVersions);
            if (JVM_ENFORCEMENT_STRICT.equals(this.enforcementMode)) {
                throw new ArtifactDescriptorCreateException(errorMessage);
            }
            if (JVM_ENFORCEMENT_LOOSE.equals(this.enforcementMode)) {
                LOGGER.warn(errorMessage);
            } else if (!JVM_ENFORCEMENT_DISABLED.equals(this.enforcementMode)) {
                throw new IllegalArgumentException("Unsupported mule.jvm.version.deployableArtifact.enforcementvalue: " + this.enforcementMode);
            }
        }
    }

    private String getErrorMessageFor(ArtifactDescriptor descriptor, String runningJdkVersion, Set<String> supportedJavaVersions) {
        String name = descriptor instanceof ApplicationDescriptor ? "Application '" + descriptor.getName() + "'" : (descriptor instanceof DomainDescriptor ? "Domain '" + descriptor.getName() + "'" : "Artifact '" + descriptor.getName() + "'");
        return String.format("%s does not support Java %s. Supported versions are: %s", name, runningJdkVersion, supportedJavaVersions);
    }
}

