/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.core.xml.reader;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.mule.weave.v2.core.io.SeekableStream;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.module.core.xml.reader.LimitedResettableInputStream;
import org.mule.weave.v2.module.core.xml.reader.SeekableInputStreamAdapter;
import org.mule.weave.v2.module.reader.SourceProvider;
import org.mule.weave.v2.module.reader.SourceProvider$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.util.matching.Regex;

public final class XmlEncodingDetector$ {
    public static XmlEncodingDetector$ MODULE$;
    private final int BUFFER_SIZE;

    static {
        new XmlEncodingDetector$();
    }

    private int BUFFER_SIZE() {
        return this.BUFFER_SIZE;
    }

    public SourceProvider updateSourceProviderEncoding(SourceProvider sourceProvider, EvaluationContext ctx) {
        InputStream inputStream;
        String detectedCharset;
        InputStream inputStream2;
        SeekableStream seekableStream;
        InputStream inputStream3 = sourceProvider.asInputStream(ctx);
        if (inputStream3 instanceof SeekableStream && (seekableStream = (SeekableStream)inputStream3).canBeConsumedMultipleTimes()) {
            inputStream2 = new SeekableInputStreamAdapter(seekableStream);
        } else if (inputStream3.markSupported()) {
            inputStream2 = inputStream3;
        } else if (inputStream3 != null) {
            InputStream inputStream4 = inputStream3;
            inputStream2 = new LimitedResettableInputStream(inputStream4, this.BUFFER_SIZE(), ctx);
        } else {
            throw new MatchError((Object)inputStream3);
        }
        InputStream is = inputStream2;
        String string = sourceProvider.charset().name();
        String sourceCharset = "UTF-16".equals(string) ? "UTF-16BE" : ("UTF-32".equals(string) ? "UTF-32BE" : string);
        String string2 = detectedCharset = (String)this.detectEncoding(is).getOrElse((Function0 & Serializable & scala.Serializable)() -> sourceCharset);
        String string3 = sourceCharset;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null) && !(is instanceof LimitedResettableInputStream)) {
            return sourceProvider;
        }
        InputStream inputStream5 = is;
        if (inputStream5 instanceof SeekableInputStreamAdapter) {
            SeekableInputStreamAdapter seekableInputStreamAdapter = (SeekableInputStreamAdapter)inputStream5;
            inputStream = (InputStream)seekableInputStreamAdapter.delegate();
        } else {
            inputStream = is;
        }
        return SourceProvider$.MODULE$.apply(inputStream, Charset.forName(detectedCharset));
    }

    private Option<String> detectEncoding(InputStream is) {
        None$ none$;
        try {
            is.mark(this.BUFFER_SIZE());
            byte[] bom = new byte[this.BUFFER_SIZE()];
            int read = is.read(bom, 0, 4);
            if (read == -1) {
                return None$.MODULE$;
            }
            int n = read;
            switch (n) {
                default: 
            }
            String bomEncoding = read >= 4 && bom[0] == 0 && bom[1] == 0 && bom[2] == (byte)254 && bom[3] == (byte)255 ? "UTF-32BE" : (read >= 4 && bom[0] == (byte)255 && bom[1] == (byte)254 && bom[2] == 0 && bom[3] == 0 ? "UTF-32LE" : (read >= 3 && bom[0] == (byte)239 && bom[1] == (byte)187 && bom[2] == (byte)191 ? "UTF-8" : (read >= 2 && bom[0] == (byte)254 && bom[1] == (byte)255 ? "UTF-16BE" : (read >= 2 && bom[0] == (byte)255 && bom[1] == (byte)254 ? "UTF-16LE" : null))));
            is.reset();
            if (bomEncoding != null) {
                return new Some((Object)bomEncoding);
            }
            byte[] buffer = new byte[128];
            int bytesRead = 0;
            boolean stopReading = false;
            while (bytesRead < 128 && !stopReading) {
                int n2 = is.read();
                if (n2 == -1) {
                    stopReading = true;
                    continue;
                }
                buffer[bytesRead] = (byte)n2;
                ++bytesRead;
                if (n2 != (byte)62) continue;
                stopReading = true;
            }
            is.reset();
            String xmlProlog = new String(buffer, 0, bytesRead, StandardCharsets.UTF_8);
            Regex encodingRegex = new StringOps(Predef$.MODULE$.augmentString("(?i)<\\?xml[^>]*encoding\\s*=\\s*[\"']([^\"']+)[\"']")).r();
            Option declaredEncoding = encodingRegex.findFirstMatchIn((CharSequence)xmlProlog).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.group(1));
            none$ = declaredEncoding;
        }
        catch (Exception exception) {
            is.reset();
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private XmlEncodingDetector$() {
        MODULE$ = this;
        this.BUFFER_SIZE = 128;
    }
}

