/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.maven.pom.parser.api.MavenPomParser;
import org.mule.runtime.api.artifact.ArtifactCoordinates;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.api.deployment.meta.MuleDeployableModel;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.globalconfig.api.GlobalConfigLoader;
import org.mule.runtime.module.artifact.activation.api.deployable.ArtifactModelResolver;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel;
import org.mule.runtime.module.artifact.activation.internal.maven.AbstractMavenDeployableProjectModelBuilder;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;

public class LightweightDeployableProjectModelBuilder
extends AbstractMavenDeployableProjectModelBuilder {
    private final ArtifactType artifactType;
    private final Optional<MuleDeployableModel> model;

    @Deprecated(since="4.11", forRemoval=true)
    public LightweightDeployableProjectModelBuilder(File projectFolder, boolean isDomain) {
        this(projectFolder, Optional.empty(), isDomain);
    }

    public LightweightDeployableProjectModelBuilder(Path projectFolder, ArtifactType artifactType) {
        this(projectFolder, Optional.empty(), artifactType);
    }

    @Deprecated(since="4.11", forRemoval=true)
    public LightweightDeployableProjectModelBuilder(File projectFolder, Optional<MuleDeployableModel> model, boolean isDomain) {
        super(GlobalConfigLoader.getMavenConfig(), projectFolder);
        this.model = model;
        this.artifactType = isDomain ? ArtifactType.DOMAIN : ArtifactType.APP;
    }

    public LightweightDeployableProjectModelBuilder(Path projectFolder, Optional<MuleDeployableModel> model, ArtifactType artifactType) {
        super(GlobalConfigLoader.getMavenConfig(), projectFolder.toFile());
        this.model = model;
        this.artifactType = artifactType;
    }

    @Override
    protected DeployableProjectModel doBuild(MavenPomParser parser, ArtifactCoordinates deployableArtifactCoordinates) {
        Supplier<MuleDeployableModel> deployableModelResolver = this.getDeployableModelResolver();
        MuleDeployableModel deployableModel = deployableModelResolver.get();
        List<String> exportedPackages = this.getAttribute(deployableModel.getClassLoaderModelLoaderDescriptor().getAttributes(), "exportedPackages");
        List<String> exportedResources = this.getAttribute(deployableModel.getClassLoaderModelLoaderDescriptor().getAttributes(), "exportedResources");
        return new DeployableProjectModel(exportedPackages, exportedResources, Collections.emptyList(), this.buildBundleDescriptor(deployableArtifactCoordinates, this.artifactType), deployableModelResolver, Optional.empty(), this.projectFolder, this.deployableBundleDependencies, this.sharedDeployableBundleDescriptors, this.additionalPluginDependencies);
    }

    @Override
    protected File getPomFromFolder(File projectFolder) {
        File file;
        block9: {
            File mavenFolder = new File(projectFolder, "META-INF/maven");
            Stream<Path> stream = Files.find(mavenFolder.toPath(), 3, (p, m) -> p.getFileName().toString().equals("pom.xml"), new FileVisitOption[0]);
            try {
                List pomLists = stream.collect(Collectors.toList());
                if (pomLists.size() != 1) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could find the pom in " + String.valueOf(mavenFolder.toPath()))));
                }
                file = ((Path)pomLists.get(0)).toFile();
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MuleRuntimeException((Throwable)e);
                }
            }
            stream.close();
        }
        return file;
    }

    @Override
    protected boolean isIncludeTestDependencies() {
        return Boolean.parseBoolean(this.getSimpleAttribute(this.getDeployableModelResolver().get().getClassLoaderModelLoaderDescriptor().getAttributes(), "includeTestDependencies", "false"));
    }

    private Supplier<MuleDeployableModel> getDeployableModelResolver() {
        return () -> this.model.orElseGet(() -> {
            if (this.artifactType.equals((Object)ArtifactType.DOMAIN)) {
                return ArtifactModelResolver.domainModelResolver().resolve(new File(this.projectFolder, "META-INF/mule-artifact"));
            }
            if (this.artifactType.equals((Object)ArtifactType.APP)) {
                return ArtifactModelResolver.applicationModelResolver().resolve(new File(this.projectFolder, "META-INF/mule-artifact"));
            }
            throw new IllegalStateException("No model resolver for artifactType " + String.valueOf(this.artifactType));
        });
    }

    private BundleDescriptor buildBundleDescriptor(ArtifactCoordinates artifactCoordinates, ArtifactType artifactType) {
        return new BundleDescriptor.Builder().setArtifactId(artifactCoordinates.getArtifactId()).setGroupId(artifactCoordinates.getGroupId()).setVersion(artifactCoordinates.getVersion()).setBaseVersion(artifactCoordinates.getVersion()).setType("jar").setClassifier(artifactType.getMavenArtifactClassifier()).build();
    }
}

