/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.serialization.dto;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.ast.api.error.ErrorTypeBuilder;

public class EnrichedErrorTypeRepository
implements ErrorTypeRepository {
    private final ErrorTypeRepository delegate;
    private final Map<ComponentIdentifier, ErrorType> deploymentErrorTypes = new HashMap<ComponentIdentifier, ErrorType>();
    private final Map<ComponentIdentifier, ErrorType> deploymentInternalErrorTypes = new HashMap<ComponentIdentifier, ErrorType>();

    public EnrichedErrorTypeRepository(ErrorTypeRepository delegate) {
        this.delegate = delegate;
    }

    public ErrorType addErrorType(ComponentIdentifier errorTypeIdentifier, ErrorType parentErrorType) {
        return this.delegate.getErrorType(errorTypeIdentifier).orElse(this.createNewErrorType(errorTypeIdentifier, parentErrorType, this.deploymentErrorTypes));
    }

    public ErrorType addInternalErrorType(ComponentIdentifier errorTypeIdentifier, ErrorType parentErrorType) {
        return this.delegate.getErrorType(errorTypeIdentifier).orElse(this.createNewErrorType(errorTypeIdentifier, parentErrorType, this.deploymentInternalErrorTypes));
    }

    public Optional<ErrorType> lookupErrorType(ComponentIdentifier errorTypeComponentIdentifier) {
        return Optional.ofNullable(this.delegate.lookupErrorType(errorTypeComponentIdentifier).orElse(this.deploymentErrorTypes.get(errorTypeComponentIdentifier)));
    }

    public Optional<ErrorType> getErrorType(ComponentIdentifier errorTypeIdentifier) {
        return Optional.ofNullable(Optional.ofNullable(this.delegate.getErrorType(errorTypeIdentifier).orElse(this.deploymentErrorTypes.get(errorTypeIdentifier))).orElse(this.deploymentInternalErrorTypes.get(errorTypeIdentifier)));
    }

    public Collection<String> getErrorNamespaces() {
        return Stream.concat(Stream.concat(Stream.concat(this.getErrorTypes().stream(), this.getInternalErrorTypes().stream()), new HashSet<ErrorType>(this.deploymentErrorTypes.values()).stream()), new HashSet<ErrorType>(this.deploymentInternalErrorTypes.values()).stream()).map(errorType -> errorType.getNamespace().toUpperCase()).distinct().collect(Collectors.toList());
    }

    public ErrorType getAnyErrorType() {
        return this.delegate.getAnyErrorType();
    }

    public ErrorType getSourceErrorType() {
        return this.delegate.getSourceErrorType();
    }

    public ErrorType getSourceResponseErrorType() {
        return this.delegate.getSourceResponseErrorType();
    }

    public ErrorType getCriticalErrorType() {
        return this.delegate.getCriticalErrorType();
    }

    public Set<ErrorType> getErrorTypes() {
        HashSet<ErrorType> errorTypes = new HashSet<ErrorType>(this.delegate.getErrorTypes());
        errorTypes.addAll(this.deploymentErrorTypes.values());
        return errorTypes;
    }

    public Set<ErrorType> getInternalErrorTypes() {
        HashSet<ErrorType> errorTypes = new HashSet<ErrorType>(this.delegate.getInternalErrorTypes());
        errorTypes.addAll(this.deploymentInternalErrorTypes.values());
        return errorTypes;
    }

    private ErrorType buildErrorType(ComponentIdentifier identifier, ErrorType parent) {
        if (this.deploymentErrorTypes.containsKey(identifier) || this.deploymentInternalErrorTypes.containsKey(identifier)) {
            throw new IllegalStateException(String.format("An error type with identifier '%s' already exists", identifier));
        }
        return ErrorTypeBuilder.builder().namespace(identifier.getNamespace()).identifier(identifier.getName()).parentErrorType(parent).build();
    }

    private ErrorType createNewErrorType(ComponentIdentifier errorTypeIdentifier, ErrorType parentErrorType, Map<ComponentIdentifier, ErrorType> errorTypes) {
        ErrorType errorType = this.buildErrorType(errorTypeIdentifier, parentErrorType);
        errorTypes.put(errorTypeIdentifier, errorType);
        return errorType;
    }
}

