/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.api.validation.ArtifactAstValidator;
import org.mule.runtime.ast.api.validation.ArtifactValidation;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResult;
import org.mule.runtime.ast.internal.validation.DefaultValidationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultValidator
implements ArtifactAstValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultValidator.class);
    private final List<ArtifactValidation> artifactValidations;
    private final List<Validation> componentValidations;

    public DefaultValidator(List<ArtifactValidation> artifactValidations, List<Validation> componentValidations) {
        this.artifactValidations = artifactValidations;
        this.componentValidations = componentValidations;
    }

    @Override
    public ValidationResult validate(ArtifactAst artifact) {
        DefaultValidationResult result = new DefaultValidationResult();
        this.artifactValidations.stream().forEach(validation -> {
            LOGGER.debug("Running validation '{}' on artifact...", validation);
            validation.validateMany(artifact).forEach(result::addItem);
        });
        MuleAstUtils.recursiveStreamWithHierarchy(artifact).forEach(ch -> this.componentValidations.stream().filter(validation -> {
            ArrayList<ComponentAst> hierarchy = new ArrayList<ComponentAst>((Collection)ch.getSecond());
            hierarchy.add((ComponentAst)ch.getFirst());
            return validation.applicable().test(hierarchy);
        }).forEach(validation -> {
            LOGGER.debug("Running validation '{}' on '{}'...", validation, ch.getFirst());
            validation.validateMany((ComponentAst)ch.getFirst(), artifact).forEach(result::addItem);
        }));
        return result;
    }
}

