/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.profiling.ProfilingService;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.Sink;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategyFactory;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.internal.processor.strategy.AbstractProcessingStrategy;
import org.mule.runtime.core.internal.processor.strategy.ComponentInnerProcessor;
import org.mule.runtime.core.internal.processor.strategy.StreamPerEventSink;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class BlockingProcessingStrategyFactory
implements ProcessingStrategyFactory {
    public static final ProcessingStrategy BLOCKING_PROCESSING_STRATEGY_INSTANCE = new BlockingProcessingStrategy();

    @Override
    public ProcessingStrategy create(ProfilingService profilingService, FeatureFlaggingService featureFlaggingService, SchedulerService schedulerService, Supplier<SchedulerConfig> schedulerBaseConfig, String schedulersNamePrefix, String artifactId, ArtifactType artifactType, LongSupplier shutdownTimeoutSupplier) {
        return BLOCKING_PROCESSING_STRATEGY_INSTANCE;
    }

    @Override
    public Class<? extends ProcessingStrategy> getProcessingStrategyType() {
        return BLOCKING_PROCESSING_STRATEGY_INSTANCE.getClass();
    }

    private static class BlockingProcessingStrategy
    extends AbstractProcessingStrategy {
        private BlockingProcessingStrategy() {
        }

        @Override
        public boolean isSynchronous() {
            return true;
        }

        @Override
        public Sink createSink(FlowConstruct flowConstruct, ReactiveProcessor pipeline) {
            return new StreamPerEventSink(pipeline, event -> {});
        }

        @Override
        public ReactiveProcessor onProcessor(ReactiveProcessor processor) {
            if (BlockingProcessingStrategy.needsMonoBlock(processor)) {
                return publisher -> Flux.deferContextual(ctx -> Flux.from((Publisher)publisher).handle((event, sink) -> {
                    try {
                        CoreEvent result = (CoreEvent)Mono.just((Object)event).transform((Function)processor).onErrorStop().contextWrite(ctx).block();
                        if (result != null) {
                            sink.next((Object)result);
                        }
                    }
                    catch (Throwable throwable) {
                        sink.error(Exceptions.wrapFatal(Exceptions.unwrap(throwable)));
                    }
                }));
            }
            return processor;
        }

        private static boolean needsMonoBlock(ReactiveProcessor processor) {
            if (processor instanceof ComponentInnerProcessor) {
                return !((ComponentInnerProcessor)processor).isBlocking();
            }
            return processor.getProcessingType() == ReactiveProcessor.ProcessingType.CPU_LITE_ASYNC;
        }
    }
}

