/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.repository.util;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.togglz.core.repository.util.MapSerializer;

public class DefaultMapSerializer
implements MapSerializer {
    private final boolean multiline;
    private final String lineSeparator;

    private DefaultMapSerializer(boolean multiline) {
        this(multiline, "\n");
    }

    private DefaultMapSerializer(boolean multiline, String lineSeparator) {
        this.multiline = multiline;
        this.lineSeparator = lineSeparator;
    }

    public static DefaultMapSerializer singleline() {
        return new DefaultMapSerializer(false);
    }

    public static DefaultMapSerializer multiline() {
        return new DefaultMapSerializer(true);
    }

    public static DefaultMapSerializer multiline(String lineSeparator) {
        return new DefaultMapSerializer(true, lineSeparator);
    }

    @Override
    public String serialize(Map<String, String> map) {
        try {
            if (map.isEmpty()) {
                return "";
            }
            Properties props = new Properties();
            props.putAll(map);
            StringWriter writer = new StringWriter();
            props.store(writer, null);
            ArrayList<String> lines = new ArrayList<String>();
            for (String line : ((Object)writer).toString().split("\r?\n")) {
                if (line.trim().isEmpty() || line.trim().startsWith("#")) continue;
                lines.add(line.trim());
            }
            Collections.sort(lines);
            StringBuilder builder = new StringBuilder();
            for (String line : lines) {
                if (this.multiline) {
                    if (builder.length() > 0) {
                        builder.append(this.lineSeparator);
                    }
                    builder.append(line);
                    continue;
                }
                if (builder.length() > 0) {
                    builder.append("&");
                }
                builder.append(line.replace("&", "\\u0026"));
            }
            return builder.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Map<String, String> deserialize(String s) {
        try {
            String input;
            String string = input = this.multiline ? s : s.replace('&', '\n');
            if (input == null || input.isEmpty()) {
                return Collections.emptyMap();
            }
            Properties props = new Properties();
            props.load(new StringReader(input));
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                result.put(entry.getKey().toString(), entry.getValue().toString());
            }
            return result;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

