/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.http2;

import io.qameta.allure.Feature;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.mule.runtime.http.api.Http1ProtocolConfig;
import org.mule.runtime.http.api.Http2ProtocolConfig;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.service.http.test.common.AbstractHttpServiceTestCase;
import org.mule.tck.junit5.DynamicPort;

@Feature(value="HTTP/2 Support")
public abstract class AbstractHttp2ClientServerTestCase
extends AbstractHttpServiceTestCase {
    @DynamicPort(systemProperty="http.port")
    private Integer port;
    protected HttpServer server;
    protected HttpClient client;

    public AbstractHttp2ClientServerTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @BeforeEach
    void setUp() throws Exception {
        HttpServerConfiguration serverConfig = new HttpServerConfiguration.Builder().setHost("localhost").setPort(this.port.intValue()).setName("HTTP/2 Server").setHttp1Config(new Http1ProtocolConfig(false)).setHttp2Config(new Http2ProtocolConfig(true)).build();
        this.server = this.service.getServerFactory().create(serverConfig);
        this.server.start();
        HttpClientConfiguration clientConfig = new HttpClientConfiguration.Builder().setName("HTTP/2 Client").setHttp1Config(new Http1ProtocolConfig(false)).setHttp2Config(new Http2ProtocolConfig(true)).build();
        this.client = this.service.getClientFactory().create(clientConfig);
        this.client.start();
    }

    @AfterEach
    void tearDown() {
        if (this.server != null) {
            this.server.stop();
            this.server.dispose();
        }
        if (this.client != null) {
            this.client.stop();
        }
    }
}

