/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.utils;

import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.qameta.allure.Issue;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.service.http.netty.impl.message.content.StreamedMultipartHttpEntity;
import org.mule.service.http.netty.impl.util.HttpResponseCreatorUtils;
import org.mule.service.http.test.common.AbstractHttpTestCase;
import reactor.netty.http.client.HttpClientResponse;

public class HttpResponseCreatorUtilsTestCase
extends AbstractHttpTestCase {
    private HttpResponseCreatorUtils httpResponseCreatorUtils;
    private CompletableFuture<MultiMap<String, String>> futureTrailers;

    @Before
    public void setUp() {
        this.futureTrailers = CompletableFuture.completedFuture(MultiMap.emptyMultiMap());
        this.httpResponseCreatorUtils = new HttpResponseCreatorUtils();
    }

    @Test
    @Issue(value="W-17843326")
    public void testCreateEntity_withMultipartContent() {
        ByteArrayInputStream inputStream = new ByteArrayInputStream("test content".getBytes());
        String contentType = "multipart/mixed";
        String contentLength = "100";
        int statusCode = 200;
        HttpEntity entity = HttpResponseCreatorUtils.createEntity((InputStream)inputStream, (String)contentType, (String)contentLength, (int)statusCode, this.futureTrailers);
        MatcherAssert.assertThat((Object)entity, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(StreamedMultipartHttpEntity.class)));
    }

    @Test
    @Issue(value="W-17843326")
    public void testCreateEntity_withContentLength() {
        ByteArrayInputStream inputStream = new ByteArrayInputStream("test content".getBytes());
        HttpEntity entity = HttpResponseCreatorUtils.createEntity((InputStream)inputStream, (String)"text/plain", (String)"100", (int)200, this.futureTrailers);
        MatcherAssert.assertThat((Object)entity, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(InputStreamHttpEntity.class)));
    }

    @Test
    @Issue(value="W-17843326")
    public void testCreateEntity_withEmptyResponse() {
        ByteArrayInputStream inputStream = new ByteArrayInputStream("".getBytes());
        HttpEntity entity = HttpResponseCreatorUtils.createEntity((InputStream)inputStream, (String)"text/plain", (String)"0", (int)204, this.futureTrailers);
        MatcherAssert.assertThat((Object)entity, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(EmptyHttpEntity.class)));
    }

    @Test
    @Issue(value="W-17843326")
    public void testBuildResponseHeaders_forHttpResponse() {
        HttpResponse response = (HttpResponse)Mockito.mock(HttpResponse.class);
        HttpHeaders headers = (HttpHeaders)Mockito.mock(HttpHeaders.class);
        Mockito.when((Object)response.status()).thenReturn((Object)((HttpResponseStatus)Mockito.mock(HttpResponseStatus.class)));
        Mockito.when((Object)response.headers()).thenReturn((Object)headers);
        Mockito.when((Object)response.status().code()).thenReturn((Object)200);
        Mockito.when((Object)response.status().reasonPhrase()).thenReturn((Object)"OK");
        HttpResponseBuilder builder = this.httpResponseCreatorUtils.buildResponseHeaders(response);
        MatcherAssert.assertThat((Object)builder.getStatusCode(), (Matcher)Matchers.is((Object)HttpResponseStatus.OK.code()));
        ((HttpHeaders)Mockito.verify((Object)headers, (VerificationMode)Mockito.times((int)1))).names();
    }

    @Test
    @Issue(value="W-17843326")
    public void testExtractHeader_forHttpResponse() {
        HttpResponse response = (HttpResponse)Mockito.mock(HttpResponse.class);
        HttpHeaders headers = (HttpHeaders)Mockito.mock(HttpHeaders.class);
        Mockito.when((Object)response.headers()).thenReturn((Object)headers);
        Mockito.when((Object)headers.contains("Content-Type")).thenReturn((Object)true);
        Mockito.when((Object)headers.get("Content-Type")).thenReturn((Object)"application/json");
        String header = this.httpResponseCreatorUtils.extractHeader(response, "Content-Type");
        MatcherAssert.assertThat((Object)header, (Matcher)Matchers.is((Object)"application/json"));
    }

    @Test
    @Issue(value="W-17843326")
    public void testExtractHeader_forHttpClientResponse() {
        HttpClientResponse response = (HttpClientResponse)Mockito.mock(HttpClientResponse.class);
        HttpHeaders headers = (HttpHeaders)Mockito.mock(HttpHeaders.class);
        Mockito.when((Object)response.responseHeaders()).thenReturn((Object)headers);
        Mockito.when((Object)headers.contains("Content-Length")).thenReturn((Object)true);
        Mockito.when((Object)headers.get("Content-Length")).thenReturn((Object)"100");
        String header = this.httpResponseCreatorUtils.extractHeader(response, "Content-Length");
        MatcherAssert.assertThat((Object)header, (Matcher)Matchers.is((Object)"100"));
    }
}

