/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2Headers;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.netty.impl.server.HttpWriter;

public final class Http2Writer
implements HttpWriter {
    private final ChannelHandlerContext ctx;
    private final Http2FrameStream frameStream;
    private HttpResponse response;

    public Http2Writer(ChannelHandlerContext ctx, Http2FrameStream frameStream) {
        this.ctx = ctx;
        this.frameStream = frameStream;
    }

    @Override
    public void writeResponseHeader(HttpRequest request, HttpResponse response, ChannelPromise promise) {
        this.response = response;
        Http2Headers headers = Http2Writer.extractHeaders(response);
        this.ctx.writeAndFlush((Object)new DefaultHttp2HeadersFrame(headers, false).stream(this.frameStream), promise);
    }

    @Override
    public void writeContent(ByteBuf content, boolean isLast, ChannelPromise promise) {
        this.ctx.writeAndFlush((Object)new DefaultHttp2DataFrame(content, isLast).stream(this.frameStream), promise);
    }

    private static Http2Headers extractHeaders(HttpResponse response) {
        Http2Headers headers = new DefaultHttp2Headers(false).status((CharSequence)String.valueOf(response.getStatusCode()));
        MultiMap responseHeaders = response.getHeaders();
        for (String key : responseHeaders.keySet()) {
            for (String value : responseHeaders.getAll((Object)key)) {
                headers.add((Object)key, (Object)value);
            }
        }
        return headers;
    }

    @Override
    public void writeTrailers(MultiMap<String, String> trailers, ChannelPromise promise) {
        if (trailers == null || trailers.isEmpty()) {
            this.ctx.writeAndFlush((Object)new DefaultHttp2DataFrame(Unpooled.EMPTY_BUFFER, true).stream(this.frameStream), promise);
            return;
        }
        DefaultHttp2Headers trailersToNetty = new DefaultHttp2Headers(false);
        for (String key : trailers.keySet()) {
            for (String value : trailers.getAll((Object)key)) {
                trailersToNetty.add((Object)key, (Object)value);
            }
        }
        this.ctx.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)trailersToNetty, true).stream(this.frameStream), promise);
    }
}

