/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.ssl.SslHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.service.http.netty.impl.server.NettyHttp2RequestAdapter;
import org.mule.service.http.netty.impl.server.NettyHttp2RequestReadyCallback;
import org.mule.service.http.netty.impl.server.NettyHttpRequestContext;
import org.mule.service.http.netty.impl.server.util.DefaultServerAddress;
import org.mule.service.http.netty.impl.server.util.HttpListenerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyToMuleHttp2RequestHandlerAdapter
extends SimpleChannelInboundHandler<Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyToMuleHttp2RequestHandlerAdapter.class);
    private final HttpListenerRegistry httpListenerRegistry;
    private final SslHandler sslHandler;
    private final Executor ioExecutor;
    private NettyHttp2RequestAdapter request;

    public NettyToMuleHttp2RequestHandlerAdapter(HttpListenerRegistry httpListenerRegistry, SslHandler sslHandler, Executor ioExecutor) {
        this.httpListenerRegistry = httpListenerRegistry;
        this.sslHandler = sslHandler;
        this.ioExecutor = ioExecutor;
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof Http2DataFrame) {
            Http2DataFrame dataFrame = (Http2DataFrame)msg;
            this.onDataFrameRead(dataFrame);
        } else if (msg instanceof Http2HeadersFrame) {
            Http2HeadersFrame headersFrame = (Http2HeadersFrame)msg;
            if (this.request == null) {
                this.onHeadersFrameRead(ctx, headersFrame);
            } else {
                this.onTrailersFrameRead(headersFrame);
            }
        } else {
            super.channelRead(ctx, msg);
        }
    }

    private void onHeadersFrameRead(ChannelHandlerContext ctx, Http2HeadersFrame headersFrame) throws IOException {
        InetSocketAddress socketAddress = (InetSocketAddress)ctx.channel().localAddress();
        DefaultServerAddress serverAddress = new DefaultServerAddress(socketAddress.getAddress(), socketAddress.getPort());
        this.request = new NettyHttp2RequestAdapter(headersFrame);
        if (headersFrame.isEndStream()) {
            this.request.finishEntityAndSetTrailers();
        }
        RequestHandler requestHandler = this.httpListenerRegistry.getRequestHandler(serverAddress, this.request);
        NettyHttpRequestContext requestContext = new NettyHttpRequestContext(this.request, ctx, this.sslHandler);
        NettyHttp2RequestReadyCallback responseReadyCallback = new NettyHttp2RequestReadyCallback(ctx, headersFrame.stream(), this.request, this.ioExecutor);
        try {
            this.ioExecutor.execute(() -> requestHandler.handleRequest((HttpRequestContext)requestContext, (HttpResponseReadyCallback)responseReadyCallback));
        }
        catch (RejectedExecutionException ree) {
            LOGGER.debug("IO Executor is busy, processing request synchronously");
            requestHandler.handleRequest((HttpRequestContext)requestContext, (HttpResponseReadyCallback)responseReadyCallback);
        }
    }

    private void onTrailersFrameRead(Http2HeadersFrame trailersFrame) throws IOException {
        for (Map.Entry entry : trailersFrame.headers()) {
            String headerName = ((CharSequence)entry.getKey()).toString();
            String headerValue = ((CharSequence)entry.getValue()).toString();
            this.request.addTrailer(headerName, headerValue);
        }
        if (trailersFrame.isEndStream()) {
            this.request.finishEntityAndSetTrailers();
        }
    }

    private void onDataFrameRead(Http2DataFrame dataFrame) throws IOException {
        ByteBuf content = dataFrame.content();
        this.request.pushContent(content);
        if (dataFrame.isEndStream()) {
            this.request.finishEntityAndSetTrailers();
        }
    }
}

