/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.http2;

import io.qameta.allure.Story;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.domain.entity.FeedableHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.test.common.AbstractHttpServiceTestCase;
import org.mule.service.http.test.common.http2.AbstractHttp2ClientServerTestCase;
import org.mule.tck.junit4.matcher.Eventually;

@Story(value="HTTP/2 Reactive")
class Http2ReactiveConsumptionTestCase
extends AbstractHttp2ClientServerTestCase {
    public static final String PROGRESSIVE_RESPONSE = "/progressive-response";
    public static final String PROGRESSIVE_REQUEST = "/progressive-request";
    private TestProgressiveHttpEntityReceiver entityReceiver;
    private FeedableHttpEntity feedableEntity;

    public Http2ReactiveConsumptionTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.feedableEntity = this.service.getEntityFactory().feedable();
        this.entityReceiver = new TestProgressiveHttpEntityReceiver();
    }

    @Override
    protected HttpClientConfiguration.Builder configureClient(HttpClientConfiguration.Builder clientConfigBuilder) {
        return clientConfigBuilder.setStreaming(true);
    }

    @Test
    void serverRespondingProgressively() throws Exception {
        this.setupServerToSendEntityProgressively();
        HttpResponse response = this.client.send(HttpRequest.builder().uri(this.urlForPath(this.server, PROGRESSIVE_RESPONSE)).build());
        this.entityReceiver.startReceivingEntity(response.getEntity());
        this.sendString("Fragment #1\n");
        this.entityReceiver.assertPartialPayload("Fragment #1\n");
        this.sendString("Fragment #2\n");
        this.entityReceiver.assertPartialPayload("Fragment #1\nFragment #2\n");
        this.sendString("Fragment #3\n");
        this.entityReceiver.assertPartialPayload("Fragment #1\nFragment #2\nFragment #3\n");
        this.feedableEntity.complete();
        MatcherAssert.assertThat((Object)this.entityReceiver.getTrailers().isEmpty(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    void clientSendingPostProgressively() throws Exception {
        this.setupServerToReceiveEntityReactively();
        CompletableFuture responseFuture = this.client.sendAsync(((HttpRequestBuilder)HttpRequest.builder().uri(this.urlForPath(this.server, PROGRESSIVE_REQUEST)).method("POST").entity((HttpEntity)this.feedableEntity)).build());
        this.sendString("Fragment #1\n");
        this.entityReceiver.assertPartialPayload("Fragment #1\n");
        this.sendString("Fragment #2\n");
        this.entityReceiver.assertPartialPayload("Fragment #1\nFragment #2\n");
        this.sendString("Fragment #3\n");
        this.entityReceiver.assertPartialPayload("Fragment #1\nFragment #2\nFragment #3\n");
        this.feedableEntity.complete();
        HttpResponse response = (HttpResponse)responseFuture.get();
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)200));
    }

    private void sendString(String dataFragment) throws IOException {
        this.feedableEntity.feed(ByteBuffer.wrap(dataFragment.getBytes()));
    }

    private void setupServerToSendEntityProgressively() {
        this.server.addRequestHandler(List.of("GET"), PROGRESSIVE_RESPONSE, (requestContext, responseCallback) -> {
            HttpResponse response = ((HttpResponseBuilder)HttpResponse.builder().statusCode(Integer.valueOf(200)).entity((HttpEntity)this.feedableEntity)).build();
            responseCallback.responseReady(response, (ResponseStatusCallback)new AbstractHttpServiceTestCase.IgnoreResponseStatusCallback());
        }).start();
    }

    private void setupServerToReceiveEntityReactively() {
        this.server.addRequestHandler(List.of("POST"), PROGRESSIVE_REQUEST, (requestContext, responseCallback) -> {
            this.entityReceiver.startReceivingEntity(requestContext.getRequest().getEntity());
            HttpResponse response = HttpResponse.builder().statusCode(Integer.valueOf(200)).build();
            this.entityReceiver.waitCompletion();
            responseCallback.responseReady(response, (ResponseStatusCallback)new AbstractHttpServiceTestCase.IgnoreResponseStatusCallback());
        }).start();
    }

    private static class TestProgressiveHttpEntityReceiver {
        private final StringBuilder partialPayload = new StringBuilder();
        private final CompletableFuture<MultiMap<String, String>> futureTrailers = new CompletableFuture();

        private TestProgressiveHttpEntityReceiver() {
        }

        void startReceivingEntity(HttpEntity entity) {
            entity.onData(data -> {
                String asString = StandardCharsets.UTF_8.decode((ByteBuffer)data).toString();
                this.partialPayload.append(asString);
            });
            entity.onComplete((trailers, error) -> {
                if (error != null) {
                    this.futureTrailers.completeExceptionally((Throwable)error);
                } else {
                    this.futureTrailers.complete((MultiMap<String, String>)trailers);
                }
            });
        }

        void assertPartialPayload(String expected) {
            MatcherAssert.assertThat((Object)this.partialPayload, (Matcher)Eventually.eventually((Matcher)Matchers.hasToString((String)expected)).every(10, TimeUnit.MILLISECONDS));
        }

        public MultiMap<String, String> getTrailers() throws ExecutionException, InterruptedException {
            return this.futureTrailers.get();
        }

        public void waitCompletion() {
            this.futureTrailers.join();
        }
    }
}

