/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.server;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.test.common.server.AbstractHttpServerTestCase;
import org.mule.service.http.test.netty.utils.NoOpResponseStatusCallback;
import org.mule.service.http.test.netty.utils.TestUtils;

class ServerHeaderCaseSensitivityTestCase
extends AbstractHttpServerTestCase {
    private static final String A_RAW_REQUEST_WITH_HEADERS = "GET /saveRequest HTTP/1.1\nHost: localhost\nUser-Agent: ObviouslyMe\nHeaderWithCase: HeaderValue\n\n";
    private final BlockingQueue<HttpRequest> receivedRequests = new LinkedBlockingQueue<HttpRequest>();

    public ServerHeaderCaseSensitivityTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Override
    protected String getServerName() {
        return "test-server";
    }

    @BeforeEach
    void setup() throws Exception {
        this.setUpServer();
        this.server.addRequestHandler("/saveRequest", (requestContext, responseCallback) -> {
            this.receivedRequests.add(requestContext.getRequest());
            responseCallback.responseReady(((HttpResponseBuilder)HttpResponse.builder().addHeader("HeaderWithCase", "HeaderValue")).build(), (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
    }

    @Test
    void receivedRequestLosesHeaderCaseWhenNoPropertySet() throws IOException, InterruptedException {
        String rawResponse = TestUtils.sendRawRequestToServer(A_RAW_REQUEST_WITH_HEADERS, "localhost", this.port);
        HttpRequest requestSeenByServer = this.receivedRequests.take();
        MatcherAssert.assertThat((Object)requestSeenByServer.getHeaderNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"host", "user-agent", "headerwithcase"}));
        MatcherAssert.assertThat((Object)rawResponse, (Matcher)Matchers.containsString((String)"headerwithcase"));
    }

    @Test
    void receivedRequestPreserveHeaderCaseWhenPropertySet() {
        TestUtils.preservingHeaderCase(() -> {
            String rawResponse;
            try {
                rawResponse = TestUtils.sendRawRequestToServer(A_RAW_REQUEST_WITH_HEADERS, "localhost", this.port);
                HttpRequest requestSeenByServer = this.receivedRequests.take();
                MatcherAssert.assertThat((Object)requestSeenByServer.getHeaderNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Host", "User-Agent", "HeaderWithCase"}));
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
            MatcherAssert.assertThat((Object)rawResponse, (Matcher)Matchers.containsString((String)"HeaderWithCase"));
        });
    }
}

